/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.service.nfs;

import java.io.File;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.acplt.oncrpc.OncRpcException;
import org.acplt.oncrpc.apps.jportmap.OncRpcEmbeddedPortmap;
import org.acplt.oncrpc.server.OncRpcServerStub;
import org.openthinclient.mountd.ListExporter;
import org.openthinclient.mountd.MountDaemon;
import org.openthinclient.nfsd.NFSServer;
import org.openthinclient.nfsd.PathManager;
import org.openthinclient.service.common.Service;
import org.openthinclient.service.nfs.ExportsParser;
import org.openthinclient.service.nfs.NFS;
import org.openthinclient.service.nfs.NFSExport;
import org.openthinclient.service.nfs.NFSServiceConfiguration;
import org.openthinclient.service.nfs.Portmapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NFSService
implements Service<NFSServiceConfiguration>,
NFS {
    private static final Logger LOG = LoggerFactory.getLogger(NFSService.class);
    private static String ATTR_SPEC = "spec";
    private static String ATTR_NAME = "name";
    private static String ATTR_ROOT = "root";
    private RpcServerThread nfsServer;
    private RpcServerThread mountDaemon;
    private RpcServerThread myPortmapper;
    private final ListExporter exporter = new ListExporter();
    private PathManager pathManager;
    private Timer flushTimer;
    private NFSServiceConfiguration configuration;
    private boolean isRunning = false;

    public boolean isRunning() {
        return this.isRunning;
    }

    public void setConfiguration(NFSServiceConfiguration configuration) {
        this.configuration = configuration;
    }

    public NFSServiceConfiguration getConfiguration() {
        return this.configuration;
    }

    public Class<NFSServiceConfiguration> getConfigurationClass() {
        return NFSServiceConfiguration.class;
    }

    public void startService() throws Exception {
        this.isRunning = true;
        this.exporter.getExports().addAll(this.getConfiguration().getExports());
        if (OncRpcEmbeddedPortmap.isPortmapRunning()) {
            LOG.info("Portmapper already running");
        } else {
            LOG.info("Portmapper not found; starting PORTMAP server.");
            this.myPortmapper = new RpcServerThread("portmapper", new Portmapper(this.configuration.getPortmapPort(), this.configuration.getPortmapProgramNumber())){

                @Override
                protected void doRunServer() throws OncRpcException, IOException {
                    this.server.run(this.server.transports);
                }
            };
        }
        this.pathManager = new PathManager(null != this.configuration.getPathDBLocation() ? this.configuration.getPathDBLocation() : null, this.exporter);
        this.nfsServer = new RpcServerThread("NFS server", new NFSServer(this.pathManager, this.configuration.getNfsPort(), this.configuration.getNfsProgramNumber()));
        this.mountDaemon = new RpcServerThread("mount daemon", new MountDaemon(this.pathManager, this.exporter, this.configuration.getMountdPort(), this.configuration.getMountdProgramNumber()));
        if (this.configuration.getFlushInterval() > 0) {
            this.flushTimer = new Timer("NFS database flush", true);
            this.flushTimer.scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    if (null != NFSService.this.pathManager) {
                        try {
                            NFSService.this.pathManager.flushPathDatabase();
                        }
                        catch (IOException e) {
                            LOG.warn("Could not flush path database", (Throwable)e);
                        }
                    }
                }
            }, this.configuration.getFlushInterval() * 1000, (long)(this.configuration.getFlushInterval() * 1000));
        }
    }

    public void stopService() throws Exception {
        this.isRunning = false;
        if (null != this.flushTimer) {
            this.flushTimer.cancel();
            this.flushTimer = null;
        }
        if (this.mountDaemon != null) {
            LOG.info("Stopping mount daemon");
            this.mountDaemon.terminate();
            this.mountDaemon = null;
        }
        if (this.nfsServer != null) {
            LOG.info("Stopping NFS server");
            this.nfsServer.terminate();
            this.nfsServer = null;
        }
        if (this.myPortmapper != null) {
            LOG.info("Stopping embedded portmapper");
            this.myPortmapper.terminate();
            this.myPortmapper = null;
        }
        if (this.pathManager != null) {
            LOG.info("Stopping path manager");
            this.pathManager.shutdown();
            this.pathManager = null;
        }
    }

    public void restartService() {
        LOG.info("Restarting NFS service");
        try {
            this.stopService();
        }
        catch (Exception ex) {
            LOG.error("Error while stopping NFS server for restart:", (Throwable)ex);
        }
        try {
            this.startService();
        }
        catch (Exception ex) {
            LOG.error("Error while restarting NFS server:", (Throwable)ex);
        }
    }

    @Override
    public void addExport(String exportSpec) throws UnknownHostException {
        LOG.info("Adding export: " + exportSpec);
        ExportsParser parser = new ExportsParser();
        this.exporter.addExport(parser.parse(exportSpec));
    }

    @Override
    public void addExport(NFSExport export) {
        LOG.info("Exporting " + export);
        this.exporter.addExport(export);
    }

    @Override
    public boolean removeExport(String name2) {
        boolean result = this.exporter.removeExport(name2);
        if (result) {
            LOG.info("Removed NFSExport: " + name2);
        } else {
            LOG.info("NFSExport to be removed not found: " + name2);
        }
        return result;
    }

    public void setExports(Element o) {
        NodeList nl = o.getChildNodes();
        if (nl != null) {
            for (int i = 0; i < nl.getLength(); ++i) {
                Node nod = nl.item(i);
                if (nod == null) continue;
                String sSpec = null;
                String sName = null;
                String sRoot = null;
                NamedNodeMap nnm = nod.getAttributes();
                if (nnm == null) continue;
                Node nSpec = nnm.getNamedItem(ATTR_SPEC);
                Node nName = nnm.getNamedItem(ATTR_NAME);
                Node nRoot = nnm.getNamedItem(ATTR_ROOT);
                if (nSpec != null) {
                    sSpec = nSpec.getNodeValue();
                }
                if (nName != null) {
                    sName = nName.getNodeValue();
                }
                if (nRoot != null) {
                    sRoot = nRoot.getNodeValue();
                }
                if (sSpec != null) {
                    try {
                        ExportsParser parser = new ExportsParser();
                        this.addExport(parser.parse(sSpec));
                    }
                    catch (UnknownHostException uhe) {
                        LOG.warn("INVALID Configuration - unknown Host:", (Throwable)uhe);
                    }
                    continue;
                }
                if (sName != null && sRoot != null) {
                    NFSExport export = new NFSExport();
                    export.setName(sName);
                    export.setRoot(new File(sRoot));
                    this.addExport(export);
                    continue;
                }
                LOG.warn("INVALID Configuration" + nnm.toString());
            }
        }
    }

    @Override
    public boolean moveLocalFile(File from, File to) {
        if (!from.exists()) {
            return false;
        }
        this.pathManager.flushFile(from);
        this.pathManager.flushFile(to);
        if (!this.pathManager.handleForFileExists(from)) {
            return from.renameTo(to);
        }
        if (from.renameTo(to) && this.pathManager.createMissigHandles(to)) {
            this.pathManager.movePath(from, to);
            return true;
        }
        return false;
    }

    @Override
    public boolean moveMoreFiles(HashMap<File, File> fromToMap) {
        for (File keyFile : fromToMap.keySet()) {
            if (this.moveLocalFile(keyFile, fromToMap.get(keyFile))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean removeFilesFromNFS(List<File> fileList) {
        return this.pathManager.removeFileFromNFS(fileList);
    }

    private class RpcServerThread
    extends Thread {
        protected OncRpcServerStub server;
        private boolean terminateCalled;

        RpcServerThread(String name2, OncRpcServerStub server) {
            super(name2);
            this.terminateCalled = false;
            this.server = server;
            this.setDaemon(true);
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                LOG.info("Starting " + this.getName());
                this.doRunServer();
                RpcServerThread rpcServerThread = this;
                synchronized (rpcServerThread) {
                    if (!this.terminateCalled) {
                        LOG.error(this.getName() + " terminated unexpectedly.");
                    } else {
                        LOG.info(this.getName() + " terminated");
                    }
                }
            }
            catch (Throwable e) {
                LOG.error(this.getName() + " died with exception.", e);
            }
        }

        protected void doRunServer() throws OncRpcException, IOException {
            this.server.run();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void terminate() {
            RpcServerThread rpcServerThread = this;
            synchronized (rpcServerThread) {
                this.terminateCalled = true;
            }
            LOG.debug("Stopping " + this.getName());
            this.server.stopRpcProcessing();
            try {
                this.join();
            }
            catch (InterruptedException e) {
                LOG.error("Exception shutting down " + this.getName(), (Throwable)e);
            }
        }
    }
}

