/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.service.dhcp;

import java.net.InetSocketAddress;
import org.apache.directory.server.dhcp.DhcpException;
import org.apache.directory.server.dhcp.messages.DhcpMessage;
import org.apache.directory.server.dhcp.messages.MessageType;
import org.apache.directory.server.dhcp.options.AddressOption;
import org.apache.directory.server.dhcp.options.DhcpOption;
import org.apache.directory.server.dhcp.options.OptionsField;
import org.apache.directory.server.dhcp.options.dhcp.ServerIdentifier;
import org.apache.directory.server.dhcp.options.dhcp.VendorClassIdentifier;
import org.apache.directory.server.dhcp.options.vendor.RootPath;
import org.openthinclient.common.model.Client;
import org.openthinclient.common.model.Profile;
import org.openthinclient.common.model.service.ClientService;
import org.openthinclient.common.model.service.RealmService;
import org.openthinclient.common.model.service.UnrecognizedClientService;
import org.openthinclient.common.model.util.Config;
import org.openthinclient.common.model.util.ConfigProperty;
import org.openthinclient.ldap.DirectoryException;
import org.openthinclient.service.dhcp.AbstractPXEService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BasePXEService
extends AbstractPXEService {
    protected static final Logger logger = LoggerFactory.getLogger(BasePXEService.class);

    public BasePXEService(RealmService realmService, ClientService clientService, UnrecognizedClientService unrecognizedClientService) throws DirectoryException {
        super(realmService, clientService, unrecognizedClientService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DhcpMessage handleDISCOVER(InetSocketAddress localAddress, InetSocketAddress clientAddress, DhcpMessage request) throws DhcpException {
        AbstractPXEService.Conversation conversation;
        BasePXEService.expireConversations();
        if (!this.assertCorrectPort(localAddress, 67, request)) {
            return null;
        }
        if (!this.isPXEClient(request)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Ignoring non-PXE DISCOVER" + this.getLogDetail(localAddress, clientAddress, request));
            }
            return null;
        }
        AbstractPXEService.RequestID requestID = new AbstractPXEService.RequestID(request);
        if (logger.isInfoEnabled()) {
            logger.info("Got PXE DISCOVER" + this.getLogDetail(localAddress, clientAddress, request));
        }
        AbstractPXEService.Conversation conversation2 = conversation = new AbstractPXEService.Conversation(request);
        synchronized (conversation2) {
            conversations.put(requestID, conversation);
            String hwAddressString = request.getHardwareAddress().getNativeRepresentation();
            Client client = this.getClient(hwAddressString, clientAddress, request);
            if (null == client) {
                logger.info("Client not eligible for PXE proxy service");
                this.trackUnrecognizedClient(request, null, null);
                return null;
            }
            if ("00:00:00:00:00:00".equals(client.getIpHostNumber())) {
                this.trackUnrecognizedClient(request, null, null);
            }
            conversation.setClient(client);
            logger.info("Conversation started");
            return this.myHandleOFFER(localAddress, clientAddress, request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DhcpMessage myHandleOFFER(InetSocketAddress localAddress, InetSocketAddress clientAddress, DhcpMessage offer) throws DhcpException {
        AbstractPXEService.RequestID id = new AbstractPXEService.RequestID(offer);
        AbstractPXEService.Conversation conversation = (AbstractPXEService.Conversation)conversations.get(id);
        if (null == conversation) {
            if (logger.isDebugEnabled()) {
                logger.debug("Got OFFER for which there is no conversation" + this.getLogDetail(localAddress, clientAddress, offer));
            }
            return null;
        }
        AbstractPXEService.Conversation conversation2 = conversation;
        synchronized (conversation2) {
            if (conversation.isExpired()) {
                if (logger.isInfoEnabled()) {
                    logger.info("Got OFFER for an expired conversation: " + conversation);
                }
                conversations.remove(id);
                return null;
            }
            if (logger.isInfoEnabled()) {
                logger.info("Got OFFER within " + conversation);
            }
            InetSocketAddress serverAddress = this.determineServerAddress(localAddress);
            conversation.setApplicableServerAddress(serverAddress);
            DhcpMessage reply = this.initGeneralReply(serverAddress, offer);
            reply.setMessageType(MessageType.DHCPOFFER);
            OptionsField options = reply.getOptions();
            VendorClassIdentifier vci = new VendorClassIdentifier();
            vci.setString("PXEClient");
            options.add((DhcpOption)vci);
            Client client = conversation.getClient();
            if (null != client) {
                reply.setNextServerAddress(this.getNextServerAddress((ConfigProperty<String>)Config.BootOptions.TFTPBootserver, conversation.getApplicableServerAddress(), client));
            }
            if (logger.isInfoEnabled()) {
                logger.info("Sending PXE proxy offer " + offer);
            }
            return reply;
        }
    }

    protected abstract InetSocketAddress determineServerAddress(InetSocketAddress var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected DhcpMessage handleREQUEST(InetSocketAddress localAddress, InetSocketAddress clientAddress, DhcpMessage request) throws DhcpException {
        if (!this.isPXEClient(request)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Ignoring non-PXE REQUEST" + this.getLogDetail(localAddress, clientAddress, request));
            }
            return null;
        }
        if (logger.isInfoEnabled()) {
            logger.info("Got PXE REQUEST" + this.getLogDetail(localAddress, clientAddress, request));
        }
        if (BasePXEService.isZeroAddress(clientAddress.getAddress())) {
            if (logger.isDebugEnabled()) {
                logger.debug("Ignoring PXE REQUEST from 0.0.0.0" + this.getLogDetail(localAddress, clientAddress, request));
            }
            return null;
        }
        if (!this.assertCorrectPort(localAddress, 4011, request)) {
            return null;
        }
        AbstractPXEService.RequestID id = new AbstractPXEService.RequestID(request);
        AbstractPXEService.Conversation conversation = (AbstractPXEService.Conversation)conversations.get(id);
        if (null == conversation) {
            if (logger.isInfoEnabled()) {
                logger.info("Got PXE REQUEST for which there is no conversation" + this.getLogDetail(localAddress, clientAddress, request));
            }
            return null;
        }
        AbstractPXEService.Conversation conversation2 = conversation;
        synchronized (conversation2) {
            AddressOption serverIdentOption;
            if (conversation.isExpired()) {
                if (logger.isInfoEnabled()) {
                    logger.info("Got PXE REQUEST for an expired conversation: " + conversation);
                }
                conversations.remove(id);
                return null;
            }
            Client client = conversation.getClient();
            if (null == client) {
                logger.warn("Got PXE request which we didn't send an offer. Someone else is serving PXE around here?");
                return null;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Got PXE REQUEST within " + conversation);
            }
            if (null != (serverIdentOption = (AddressOption)request.getOptions().get(ServerIdentifier.class)) && serverIdentOption.getAddress().isAnyLocalAddress()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Ignoring PXE REQUEST for server " + serverIdentOption);
                }
                return null;
            }
            InetSocketAddress serverAddress = conversation.getApplicableServerAddress();
            DhcpMessage reply = this.initGeneralReply(serverAddress, request);
            reply.setMessageType(MessageType.DHCPACK);
            OptionsField options = reply.getOptions();
            VendorClassIdentifier vci = new VendorClassIdentifier();
            vci.setString("PXEClient");
            options.add((DhcpOption)vci);
            reply.setNextServerAddress(this.getNextServerAddress((ConfigProperty<String>)Config.BootOptions.TFTPBootserver, serverAddress, client));
            String rootPath = this.getNextServerAddress((ConfigProperty<String>)Config.BootOptions.NFSRootserver, serverAddress, client).getHostAddress() + ":" + (String)Config.BootOptions.NFSRootPath.get((Profile)client);
            options.add((DhcpOption)new RootPath(rootPath));
            String bootFileName = (String)Config.BootOptions.BootfileName.get((Profile)client);
            if (null != bootFileName) {
                reply.setBootFileName(bootFileName);
            } else {
                logger.warn("BootOptions.BootfileName == null. Using default.");
                reply.setBootFileName("/pxelinux.0");
            }
            if (logger.isInfoEnabled()) {
                logger.info("Sending PXE proxy ACK rootPath=" + rootPath + " bootFileName=" + reply.getBootFileName() + " nextServerAddress=" + reply.getNextServerAddress().getHostAddress() + " reply=" + reply);
            }
            return reply;
        }
    }
}

