/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.service.dhcp;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.util.Enumeration;
import org.apache.mina.common.IoAcceptor;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoServiceConfig;
import org.openthinclient.common.model.service.ClientService;
import org.openthinclient.common.model.service.RealmService;
import org.openthinclient.common.model.service.UnrecognizedClientService;
import org.openthinclient.ldap.DirectoryException;
import org.openthinclient.service.dhcp.BasePXEService;

public class SingleHomedPXEService
extends BasePXEService {
    private InetAddress serverAddress;

    public SingleHomedPXEService(RealmService realmService, ClientService clientService, UnrecognizedClientService unrecognizedClientService) throws DirectoryException {
        super(realmService, clientService, unrecognizedClientService);
    }

    @Override
    protected InetSocketAddress determineServerAddress(InetSocketAddress localAddress) {
        return localAddress;
    }

    @Override
    public void init(IoAcceptor acceptor, IoHandler handler, IoServiceConfig config) throws IOException {
        logger.warn("-------------------------------------------------------------");
        logger.warn("  Using SingleHomedPXEService implementation. ");
        logger.warn("  This type of service might be problematic on multi-homed systems.");
        logger.warn("  (for more details, see log messages with level INFO)");
        logger.info("");
        InetAddress localAddress = this.getConfiguredLocalAddress();
        if (null == localAddress) {
            Enumeration<NetworkInterface> i = NetworkInterface.getNetworkInterfaces();
            block0: while (i.hasMoreElements()) {
                NetworkInterface nif = i.nextElement();
                if (nif.isLoopback() || nif.isPointToPoint() || nif.isVirtual() || !nif.isUp()) continue;
                Enumeration<InetAddress> j = nif.getInetAddresses();
                while (j.hasMoreElements()) {
                    InetAddress address = j.nextElement();
                    if (!(address instanceof Inet4Address) || address.isLoopbackAddress()) continue;
                    localAddress = address;
                    break block0;
                }
            }
        }
        if (null == localAddress) {
            logger.warn("  Could not determine ANY local address to use. PXE service will be unavailable");
        } else {
            this.serverAddress = localAddress;
            acceptor.bind((SocketAddress)new InetSocketAddress(this.serverAddress, 67), handler, config);
            logger.info("  Binding on " + this.serverAddress);
            InetSocketAddress pxePort = new InetSocketAddress(localAddress, 4011);
            acceptor.bind((SocketAddress)pxePort, handler, config);
            logger.info("  Binding on " + pxePort);
        }
        logger.warn("-------------------------------------------------------------");
    }

    private InetAddress getConfiguredLocalAddress() {
        return this.serverAddress;
    }
}

