/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.kdc.authentication;

import java.util.Map;
import org.apache.directory.server.kerberos.kdc.authentication.AuthenticationContext;
import org.apache.directory.server.kerberos.shared.crypto.checksum.ChecksumType;
import org.apache.directory.server.kerberos.shared.crypto.checksum.RsaMd5Checksum;
import org.apache.directory.server.kerberos.shared.crypto.checksum.Sha1Checksum;
import org.apache.directory.server.kerberos.shared.replay.InMemoryReplayCache;
import org.apache.directory.server.kerberos.shared.replay.ReplayCache;
import org.apache.directory.server.kerberos.shared.service.LockBox;
import org.apache.mina.common.IoSession;
import org.apache.mina.handler.chain.IoHandlerCommand;

public class ConfigureAuthenticationChain
implements IoHandlerCommand {
    private static final ReplayCache replayCache = new InMemoryReplayCache();
    private static final LockBox lockBox = new LockBox();
    private String contextKey = "context";

    public void execute(IoHandlerCommand.NextCommand next, IoSession session, Object message) throws Exception {
        AuthenticationContext authContext = (AuthenticationContext)((Object)session.getAttribute(this.getContextKey()));
        authContext.setReplayCache(replayCache);
        authContext.setLockBox(lockBox);
        Map checksumEngines = authContext.getChecksumEngines();
        checksumEngines.put(ChecksumType.RSA_MD5, new RsaMd5Checksum());
        checksumEngines.put(ChecksumType.SHA1, new Sha1Checksum());
        next.execute(session, message);
    }

    public String getContextKey() {
        return this.contextKey;
    }
}

