/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.pkgmgr;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.openthinclient.pkgmgr.PackageManagerConfiguration;
import org.openthinclient.pkgmgr.PackageManagerException;
import org.openthinclient.pkgmgr.PackageManagerTaskSummary;
import org.openthinclient.pkgmgr.SourcesList;
import org.openthinclient.pkgmgr.db.Package;
import org.openthinclient.pkgmgr.db.PackageInstalledContent;
import org.openthinclient.pkgmgr.db.Source;
import org.openthinclient.pkgmgr.exception.SourceIntegrityViolationException;
import org.openthinclient.pkgmgr.op.PackageListUpdateReport;
import org.openthinclient.pkgmgr.op.PackageManagerOperation;
import org.openthinclient.pkgmgr.op.PackageManagerOperationReport;
import org.openthinclient.progress.ListenableProgressFuture;
import org.openthinclient.util.dpkg.LocalPackageRepository;

public interface PackageManager {
    public PackageManagerConfiguration getConfiguration();

    public Collection<Package> getInstalledPackages();

    public Collection<Package> getInstallablePackagesWithoutInstalledOfSameVersion();

    public Collection<Package> getUpdateablePackages();

    public long getFreeDiskSpace() throws PackageManagerException;

    public Collection<Package> getInstallablePackages() throws PackageManagerException;

    public void close() throws PackageManagerException;

    public Collection<String> getChangelogFile(Package var1) throws IOException;

    public ListenableProgressFuture<PackageListUpdateReport> updateCacheDB();

    public PackageManagerTaskSummary fetchTaskSummary();

    public boolean addWarning(String var1);

    public PackageManagerOperation createOperation();

    public ListenableProgressFuture<PackageManagerOperationReport> execute(PackageManagerOperation var1);

    public SourcesList getSourcesList();

    public LocalPackageRepository getLocalPackageRepository();

    public boolean isInstallable(Package var1);

    public boolean isInstalled(Package var1);

    public void deleteSource(Source var1) throws SourceIntegrityViolationException;

    public Source saveSource(Source var1);

    public Collection<Source> findAllSources();

    public void saveSources(List<Source> var1);

    public ListenableProgressFuture<PackageListUpdateReport> deleteSourcePackagesFromCacheDB(Source var1);

    public List<PackageInstalledContent> getInstalledPackageContents(Package var1);
}

