/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.pkgmgr.connect;

import com.google.common.io.ByteStreams;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.zip.GZIPInputStream;
import org.openthinclient.manager.util.http.DownloadManager;
import org.openthinclient.pkgmgr.I18N;
import org.openthinclient.pkgmgr.PackageManagerConfiguration;
import org.openthinclient.pkgmgr.PackageManagerException;
import org.openthinclient.pkgmgr.db.Source;
import org.openthinclient.pkgmgr.exception.PackageManagerDownloadException;
import org.openthinclient.progress.ProgressReceiver;
import org.openthinclient.util.dpkg.LocalPackageList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackageListDownloader {
    public static final String PACKAGES_GZ = "Packages.gz";
    private static final Logger logger = LoggerFactory.getLogger(PackageListDownloader.class);
    private final PackageManagerConfiguration configuration;
    private final DownloadManager downloadManager;

    public PackageListDownloader(PackageManagerConfiguration configuration, DownloadManager downloadManager) {
        this.configuration = configuration;
        this.downloadManager = downloadManager;
    }

    public LocalPackageList download(Source source, ProgressReceiver progressReceiver) throws PackageManagerException {
        try {
            return this.downloadPackagesGz(source, progressReceiver);
        }
        catch (Exception e) {
            throw new PackageManagerDownloadException("Package list download failed.", source.getUrl(), e);
        }
    }

    private LocalPackageList downloadPackagesGz(Source source, ProgressReceiver progressReceiver) throws Exception {
        URL packagesGZUrl = this.createPackagesGZUrl(source);
        if (packagesGZUrl == null) {
            return null;
        }
        File targetFile = this.asTargetFile(packagesGZUrl);
        return (LocalPackageList)this.downloadManager.download(packagesGZUrl.toURI(), in -> {
            in = new GZIPInputStream(in);
            try (FileOutputStream out = new FileOutputStream(targetFile);){
                ByteStreams.copy((InputStream)in, (OutputStream)out);
            }
            return new LocalPackageList(source, targetFile);
        }, progressReceiver);
    }

    private File asTargetFile(URL packagesGZUrl) {
        File listsDir = this.configuration.getListsDir();
        String filename = packagesGZUrl.getHost() + "_" + packagesGZUrl.getFile().replaceAll("[/\\.-]", "_");
        return new File(listsDir, filename);
    }

    private URL createPackagesGZUrl(Source source) {
        URL url = source.getUrl();
        String targetPath = url.getFile();
        String distribution = "";
        if (!targetPath.endsWith("/") && !"".startsWith("/")) {
            targetPath = targetPath + "/";
        }
        if (!(targetPath = targetPath + "").endsWith("/")) {
            targetPath = targetPath + "/";
        }
        targetPath = targetPath + PACKAGES_GZ;
        try {
            return new URL(url.getProtocol(), url.getHost(), url.getPort(), targetPath);
        }
        catch (MalformedURLException e) {
            String message = I18N.getMessage("sourcesList.corrupt");
            logger.error(message, (Throwable)e);
            return null;
        }
    }
}

