/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.pkgmgr.op;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.openthinclient.pkgmgr.db.Package;
import org.openthinclient.pkgmgr.op.InstallPlanStep;

public class InstallPlan {
    private final List<InstallPlanStep> steps = new ArrayList<InstallPlanStep>();

    public List<InstallPlanStep> getSteps() {
        return this.steps;
    }

    public Stream<InstallPlanStep.PackageInstallStep> getPackageInstallSteps() {
        return this.steps.stream().filter(step -> step instanceof InstallPlanStep.PackageInstallStep).map(step -> (InstallPlanStep.PackageInstallStep)step);
    }

    public Stream<InstallPlanStep.PackageVersionChangeStep> getPackageVersionChangeSteps() {
        return this.steps.stream().filter(step -> step instanceof InstallPlanStep.PackageVersionChangeStep).map(step -> (InstallPlanStep.PackageVersionChangeStep)step);
    }

    public Stream<InstallPlanStep.PackageUninstallStep> getPackageUninstallSteps() {
        return this.steps.stream().filter(step -> step instanceof InstallPlanStep.PackageUninstallStep).map(step -> (InstallPlanStep.PackageUninstallStep)step);
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("steps", this.steps).toString();
    }

    public Map<InstallPlanStep, Package> getInstallPlanStepMap() {
        HashMap<InstallPlanStep, Package> installPlanMap = new HashMap<InstallPlanStep, Package>();
        installPlanMap.putAll(this.getPackageInstallSteps().collect(Collectors.toMap(Function.identity(), InstallPlanStep.PackageInstallStep::getPackage)));
        installPlanMap.putAll(this.getPackageUninstallSteps().collect(Collectors.toMap(Function.identity(), InstallPlanStep.PackageUninstallStep::getInstalledPackage)));
        installPlanMap.putAll(this.getPackageVersionChangeSteps().collect(Collectors.toMap(Function.identity(), InstallPlanStep.PackageVersionChangeStep::getTargetPackage)));
        return installPlanMap;
    }
}

