/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.util.dpkg;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openthinclient.pkgmgr.PackageManagerException;
import org.openthinclient.pkgmgr.db.Package;
import org.openthinclient.pkgmgr.db.Version;
import org.openthinclient.pkgmgr.op.InstallPlan;
import org.openthinclient.pkgmgr.op.InstallPlanStep;
import org.openthinclient.pkgmgr.op.PackageManagerOperation;
import org.openthinclient.pkgmgr.op.PackageManagerOperationResolver;
import org.openthinclient.util.dpkg.PackageReference;
import org.openthinclient.util.dpkg.PackageReferenceList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class PackageManagerOperationResolverImpl
implements PackageManagerOperationResolver {
    private static final Logger LOG = LoggerFactory.getLogger(PackageManagerOperationResolverImpl.class);
    private final Supplier<Collection<Package>> installedPackagesSupplier;
    private final Supplier<Collection<Package>> availablePackagesSupplier;

    public PackageManagerOperationResolverImpl(Supplier<Collection<Package>> installedPackagesSupplier, Supplier<Collection<Package>> availablePackagesSupplier) {
        this.installedPackagesSupplier = installedPackagesSupplier;
        this.availablePackagesSupplier = availablePackagesSupplier;
    }

    @Override
    public PackageManagerOperationResolver.ResolveState resolve(Collection<Package> packagesToInstall, Collection<Package> packagesToUninstall) {
        Collection<Package> installedPackages = this.installedPackagesSupplier.get();
        Collection<Package> availablePackages = this.availablePackagesSupplier.get();
        for (Package pkg : packagesToInstall) {
            if (availablePackages.stream().anyMatch(available -> this.isSamePackage(pkg, (Package)available))) continue;
            throw new PackageManagerException("Not a valid package: " + pkg);
        }
        PackageManagerOperationResolver.ResolveState resolveState = new PackageManagerOperationResolver.ResolveState();
        this.findPackageChanges(packagesToInstall, installedPackages).forEach(resolveState.getInstallPlan().getSteps()::add);
        this.findPackagesToUninstall(packagesToUninstall, installedPackages).forEach(resolveState.getInstallPlan().getSteps()::add);
        this.findPackagesToBeReplaced(resolveState.getInstallPlan(), installedPackages).forEach(resolveState.getInstallPlan().getSteps()::add);
        this.findPackagesToInstall(packagesToInstall, resolveState.getInstallPlan()).forEach(resolveState.getInstallPlan().getSteps()::add);
        this.findDependenciesToInstall(resolveState.getInstallPlan(), installedPackages, availablePackages, resolveState.getUnresolved()).forEach(resolveState.getInstallPlan().getSteps()::add);
        this.checkUnsatisfiedDependencies(resolveState.getInstallPlan(), installedPackages, resolveState.getUnresolved());
        this.checkInstallConflicts(resolveState.getInstallPlan(), installedPackages, resolveState.getConflicts());
        return resolveState;
    }

    private Stream<InstallPlanStep> findPackagesToBeReplaced(InstallPlan installPlan, Collection<Package> installedPackages) {
        ArrayList<Package> result = new ArrayList<Package>();
        List packagesToInstall = Stream.concat(installPlan.getPackageInstallSteps().map(InstallPlanStep.PackageInstallStep::getPackage), installPlan.getPackageVersionChangeSteps().map(InstallPlanStep.PackageVersionChangeStep::getTargetPackage)).collect(Collectors.toList());
        for (Package packageToInstall : packagesToInstall) {
            Optional<Package> matchingPackage = installedPackages.stream().filter(installedPackage -> packageToInstall.getReplaces().isReferenced((Package)installedPackage)).findFirst();
            if (!matchingPackage.isPresent()) continue;
            result.add(matchingPackage.get());
            LOG.debug("Found matching installed package {} to be replaced by {}", (Object)matchingPackage.get().toStringWithNameAndVersion(), (Object)packageToInstall.toStringWithNameAndVersion());
        }
        return result.stream().map(InstallPlanStep.PackageUninstallStep::new);
    }

    private void checkUnsatisfiedDependencies(InstallPlan installPlan, Collection<Package> installedPackages, Collection<PackageManagerOperation.UnresolvedDependency> unresolved) {
        List unistallPackages = installPlan.getPackageUninstallSteps().map(InstallPlanStep.PackageUninstallStep::getInstalledPackage).collect(Collectors.toList());
        ArrayList<Package> existingWithoutUnistalled = new ArrayList<Package>(installedPackages);
        existingWithoutUnistalled.removeAll(unistallPackages);
        List versionChangeUnistall = installPlan.getPackageVersionChangeSteps().map(InstallPlanStep.PackageVersionChangeStep::getInstalledPackage).collect(Collectors.toList());
        existingWithoutUnistalled.removeAll(versionChangeUnistall);
        List packagesToInstallAndExistingWithoutUninstalled = Stream.concat(installPlan.getPackageInstallSteps().map(InstallPlanStep.PackageInstallStep::getPackage), installPlan.getPackageVersionChangeSteps().map(InstallPlanStep.PackageVersionChangeStep::getTargetPackage)).collect(Collectors.toList());
        packagesToInstallAndExistingWithoutUninstalled.addAll(existingWithoutUnistalled);
        existingWithoutUnistalled.forEach(pck -> pck.getDepends().forEach(dependencyOfInstalledPackage -> {
            Optional<Package> resolvedDependencyToExistingOrNewPackage = packagesToInstallAndExistingWithoutUninstalled.stream().filter(ewuPac -> dependencyOfInstalledPackage.matches((Package)ewuPac)).findFirst();
            if (!resolvedDependencyToExistingOrNewPackage.isPresent()) {
                LOG.debug(pck.toStringWithNameAndVersion() + " misses dependency " + dependencyOfInstalledPackage);
                unresolved.add(new PackageManagerOperation.UnresolvedDependency((Package)pck, (PackageReference)dependencyOfInstalledPackage));
            }
        }));
        Map<InstallPlanStep, Package> installPlanMap = installPlan.getInstallPlanStepMap();
        installPlanMap.putAll(installPlan.getPackageVersionChangeSteps().collect(Collectors.toMap(Function.identity(), InstallPlanStep.PackageVersionChangeStep::getInstalledPackage)));
        ArrayList toRemoveFromUnistallList = new ArrayList();
        unresolved.forEach(unresolvedDependecy -> {
            for (Map.Entry entry : installPlanMap.entrySet()) {
                Package package1 = (Package)entry.getValue();
                if (!unresolvedDependecy.getMissing().matches(package1) && !package1.getProvides().contains(unresolvedDependecy.getMissing())) continue;
                toRemoveFromUnistallList.add(entry.getKey());
            }
        });
        installPlan.getSteps().removeAll(toRemoveFromUnistallList);
    }

    private void checkInstallConflicts(InstallPlan installPlan, Collection<Package> installedPackages, Collection<PackageManagerOperation.PackageConflict> conflicts) {
        List<Package> installableAndExistingPackages = this.createInstallabeAndExistingPackageList(installPlan, installedPackages);
        List<Package> packagesToInstall = Stream.concat(installPlan.getPackageInstallSteps().map(InstallPlanStep.PackageInstallStep::getPackage), installPlan.getPackageVersionChangeSteps().map(InstallPlanStep.PackageVersionChangeStep::getTargetPackage)).collect(Collectors.toList());
        packagesToInstall.forEach(installPackage -> installPackage.getConflicts().forEach(packageReference -> conflicts.addAll(this.packageReferenceMatches((Package)installPackage, (PackageReference)packageReference, installableAndExistingPackages))));
        installableAndExistingPackages.forEach(installedPackage -> installedPackage.getConflicts().forEach(installedPackageConflict -> conflicts.addAll(this.packageReferenceMatches((Package)installedPackage, (PackageReference)installedPackageConflict, packagesToInstall))));
        List<Package> existingAndUpdatedPackages = installableAndExistingPackages;
        existingAndUpdatedPackages.removeAll(installPlan.getPackageInstallSteps().map(InstallPlanStep.PackageInstallStep::getPackage).collect(Collectors.toList()));
        existingAndUpdatedPackages.forEach(installedPackage -> {
            installedPackage.getConflicts().forEach(installedPackageConflict -> packagesToInstall.forEach(packageToInstall -> {
                if (packageToInstall.getProvides().contains(installedPackageConflict)) {
                    conflicts.addAll(this.packageReferenceMatchesInProvides((Package)installedPackage, (PackageReference)installedPackageConflict, packagesToInstall));
                }
            }));
            installedPackage.getProvides().forEach(installedPackageProvides -> packagesToInstall.forEach(packageToInstall -> {
                if (packageToInstall.getConflicts().contains(installedPackageProvides)) {
                    LOG.debug(packageToInstall.forConflictsToString() + " 'conflicts' matches to installedPackage 'provides' " + installedPackage);
                    conflicts.add(new PackageManagerOperation.PackageConflict((Package)packageToInstall, (Package)installedPackage));
                }
            }));
        });
        ArrayList<InstallPlanStep> toRemoveFromInstallList = new ArrayList<InstallPlanStep>();
        block0: for (PackageManagerOperation.PackageConflict packageConflict : conflicts) {
            Package source = packageConflict.getSource();
            for (Map.Entry<InstallPlanStep, Package> entry : installPlan.getInstallPlanStepMap().entrySet()) {
                if (!this.isSamePackage(source, entry.getValue()) && !this.isSourcePackageConflictsMatchesProvidedPackages(source, entry.getValue())) continue;
                toRemoveFromInstallList.add(entry.getKey());
                continue block0;
            }
        }
        installPlan.getSteps().removeAll(toRemoveFromInstallList);
    }

    private boolean isSourcePackageConflictsMatchesProvidedPackages(Package source, Package somePackage) {
        PackageReferenceList conflicts = source.getConflicts();
        PackageReferenceList provides = somePackage.getProvides();
        return CollectionUtils.containsAny((Collection)conflicts, (Collection)provides);
    }

    private Collection<PackageManagerOperation.PackageConflict> packageReferenceMatches(Package source, PackageReference conflictPackageReference, List<Package> installableAndExistingPackages) {
        return installableAndExistingPackages.stream().filter(pck -> conflictPackageReference.matches((Package)pck)).map(pck -> new PackageManagerOperation.PackageConflict(source, (Package)pck)).collect(Collectors.toList());
    }

    private Collection<PackageManagerOperation.PackageConflict> packageReferenceMatchesInProvides(Package source, PackageReference conflictPackageReference, List<Package> installableAndExistingPackages) {
        return installableAndExistingPackages.stream().filter(pck -> pck.getProvides().stream().filter(pckp -> pckp.equals(conflictPackageReference)).findAny().isPresent()).map(pck -> new PackageManagerOperation.PackageConflict(source, (Package)pck)).collect(Collectors.toList());
    }

    private Stream<InstallPlanStep> findDependenciesToInstall(InstallPlan installPlan, Collection<Package> installedPackages, Collection<Package> availablePackages, Collection<PackageManagerOperation.UnresolvedDependency> unresolved) {
        List<Package> installableAndExistingPackages = this.createInstallabeAndExistingPackageList(installPlan, installedPackages);
        HashSet dependenciesToInstall = new HashSet();
        Stream<Package> packagesToInstall = Stream.concat(installPlan.getPackageInstallSteps().map(InstallPlanStep.PackageInstallStep::getPackage), installPlan.getPackageVersionChangeSteps().map(InstallPlanStep.PackageVersionChangeStep::getTargetPackage));
        packagesToInstall.forEach(packageToInstall -> {
            Collection<Package> dependencies = this.resolveDependencies((Package)packageToInstall, (Set<Package>)new HashSet<Package>(), (Collection<Package>)installableAndExistingPackages, availablePackages, unresolved);
            for (Package dependency : dependencies) {
                boolean isInstalled = false;
                for (Package installed : installedPackages) {
                    if (!installed.getName().equals(dependency.getName())) continue;
                    dependenciesToInstall.add(new InstallPlanStep.PackageVersionChangeStep(installed, dependency));
                    isInstalled = true;
                    break;
                }
                if (isInstalled) continue;
                dependenciesToInstall.add(new InstallPlanStep.PackageInstallStep(dependency));
            }
        });
        LOG.debug("packagesToInstall {} has dependenciesToInstall {}", packagesToInstall, dependenciesToInstall);
        return dependenciesToInstall.stream();
    }

    private List<Package> createInstallabeAndExistingPackageList(InstallPlan installPlan, Collection<Package> installedPackages) {
        List<Package> installableAndExistingPackages = Stream.concat(installPlan.getPackageInstallSteps().map(InstallPlanStep.PackageInstallStep::getPackage), Stream.concat(installPlan.getPackageVersionChangeSteps().map(InstallPlanStep.PackageVersionChangeStep::getTargetPackage), installedPackages.stream())).collect(Collectors.toList());
        List unistallPackages = installPlan.getPackageUninstallSteps().map(InstallPlanStep.PackageUninstallStep::getInstalledPackage).collect(Collectors.toList());
        installableAndExistingPackages.removeAll(unistallPackages);
        List versionChangeUnistall = installPlan.getPackageVersionChangeSteps().map(InstallPlanStep.PackageVersionChangeStep::getInstalledPackage).collect(Collectors.toList());
        installableAndExistingPackages.removeAll(versionChangeUnistall);
        return installableAndExistingPackages;
    }

    private Collection<Package> resolveDependencies(Package packageToInstall, Set<Package> foundDependencies, Collection<Package> installableAndExistingPackages, Collection<Package> availablePackages, Collection<PackageManagerOperation.UnresolvedDependency> unresolved) {
        HashSet<Package> dependenciesToInstall = new HashSet<Package>();
        ArrayList providedDependencies = new ArrayList();
        PackageReferenceList depends = packageToInstall.getDepends();
        installableAndExistingPackages.forEach(installedPackage -> installedPackage.getReplaces().forEach(installedReplacedPackageReference -> this.processExistingPackageReference(providedDependencies, depends, (PackageReference)installedReplacedPackageReference)));
        installableAndExistingPackages.forEach(installedPackage -> installedPackage.getProvides().forEach(installedProvidedPackageReference -> this.processExistingPackageReference(providedDependencies, depends, (PackageReference)installedProvidedPackageReference)));
        depends.forEach(packageReference -> {
            LOG.debug("packageToInstall {} depends {}", (Object)packageToInstall, packageReference);
            if (!providedDependencies.contains(packageReference) && packageReference instanceof PackageReference.SingleReference) {
                PackageReference.SingleReference singleReference = (PackageReference.SingleReference)packageReference;
                Optional<Package> findFirst = installableAndExistingPackages.stream().filter(singleReference::matches).findFirst();
                if (!findFirst.isPresent()) {
                    Optional<Package> findFirst2 = availablePackages.stream().filter(singleReference::matches).sorted((p1, p2) -> -p1.compareTo((Package)p2)).findFirst();
                    if (findFirst2.isPresent()) {
                        dependenciesToInstall.add(findFirst2.get());
                    } else {
                        unresolved.add(new PackageManagerOperation.UnresolvedDependency(packageToInstall, (PackageReference)packageReference));
                    }
                }
            }
        });
        ArrayList deepDependencies = new ArrayList();
        dependenciesToInstall.forEach(dep -> {
            if (!foundDependencies.contains(dep)) {
                foundDependencies.add((Package)dep);
                deepDependencies.addAll(this.resolveDependencies((Package)dep, foundDependencies, installableAndExistingPackages, availablePackages, unresolved));
            }
        });
        dependenciesToInstall.addAll(deepDependencies);
        return dependenciesToInstall;
    }

    private void processExistingPackageReference(List<PackageReference> providedDependencies, PackageReferenceList depends, PackageReference existingPackageReference) {
        if (existingPackageReference instanceof PackageReference.SingleReference) {
            PackageReference.SingleReference singleReference = (PackageReference.SingleReference)existingPackageReference;
            depends.forEach(dependsPackageReference -> {
                Package p = new Package();
                p.setName(singleReference.getName());
                if (singleReference.getVersion() != null) {
                    p.setVersion(singleReference.getVersion());
                } else {
                    p.setVersion(new Version());
                }
                if (dependsPackageReference.matches(p)) {
                    providedDependencies.add((PackageReference)dependsPackageReference);
                }
            });
        }
    }

    protected Stream<InstallPlanStep> findPackagesToInstall(Collection<Package> packagesToInstall, InstallPlan installPlan) {
        return packagesToInstall.stream().filter(pkg -> !this.isPartOfInstallPlan((Package)pkg, installPlan)).map(InstallPlanStep.PackageInstallStep::new);
    }

    protected boolean isPartOfInstallPlan(Package pkg, InstallPlan installPlan) {
        return installPlan.getSteps().stream().anyMatch(step -> {
            if (step instanceof InstallPlanStep.PackageInstallStep) {
                return this.isSamePackage(pkg, ((InstallPlanStep.PackageInstallStep)step).getPackage());
            }
            if (step instanceof InstallPlanStep.PackageVersionChangeStep) {
                InstallPlanStep.PackageVersionChangeStep change = (InstallPlanStep.PackageVersionChangeStep)step;
                return this.isSamePackage(pkg, change.getInstalledPackage()) || this.isSamePackage(pkg, change.getTargetPackage());
            }
            return false;
        });
    }

    private Stream<InstallPlanStep> findPackagesToUninstall(Collection<Package> packagesToUninstall, Collection<Package> installedPackages) {
        ArrayList<Package> result = new ArrayList<Package>();
        for (Package packageToUninstall : packagesToUninstall) {
            Optional<Package> matchingPackage = installedPackages.stream().filter(installedPackage -> this.isSamePackage(packageToUninstall, (Package)installedPackage)).findFirst();
            if (!matchingPackage.isPresent()) {
                LOG.warn("Found no matching installed package for {} {} to be uninstalled", (Object)packageToUninstall.getName(), (Object)packageToUninstall.getVersion());
                continue;
            }
            result.add(matchingPackage.get());
        }
        return result.stream().map(InstallPlanStep.PackageUninstallStep::new);
    }

    protected boolean isSamePackage(Package pkg, Package other) {
        LOG.trace("isSamePackage: ", (Object)pkg, (Object)other);
        return pkg == other || pkg.getName().equals(other.getName()) && pkg.getVersion().equals(other.getVersion());
    }

    protected Stream<InstallPlanStep> findPackageChanges(Collection<Package> packagesToInstall, Collection<Package> installedPackages) {
        return packagesToInstall.stream().flatMap(packageToInstall -> {
            String name = packageToInstall.getName();
            return installedPackages.stream().filter(pkg -> pkg.getName().equals(name)).map(pkg -> new InstallPlanStep.PackageVersionChangeStep((Package)pkg, (Package)packageToInstall));
        });
    }

    @Override
    public boolean isValid(PackageManagerOperationResolver.ResolveState resolveState) {
        return false;
    }
}

