/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.dhcp.options;

import java.io.UnsupportedEncodingException;
import org.apache.directory.server.dhcp.options.DhcpOption;

public abstract class StringOption
extends DhcpOption {
    private String string;

    @Override
    public void setData(byte[] data) {
        try {
            this.string = new String(data, "ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("ASCII encoding unavailable");
        }
    }

    @Override
    public byte[] getData() {
        if (null == this.string) {
            return new byte[0];
        }
        try {
            return this.string.getBytes("ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("ASCII encoding unavailable");
        }
    }

    public String getString() {
        return this.string;
    }

    public void setString(String string) {
        this.string = string;
    }
}

