/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web.dashboard;

import ch.qos.cal10n.IMessageConveyor;
import ch.qos.cal10n.MessageConveyor;
import com.vaadin.data.HasValue;
import com.vaadin.data.provider.ListDataProvider;
import com.vaadin.icons.VaadinIcons;
import com.vaadin.navigator.View;
import com.vaadin.server.ExternalResource;
import com.vaadin.server.Resource;
import com.vaadin.server.Responsive;
import com.vaadin.server.ThemeResource;
import com.vaadin.shared.ui.ContentMode;
import com.vaadin.spring.annotation.SpringView;
import com.vaadin.ui.BrowserFrame;
import com.vaadin.ui.Button;
import com.vaadin.ui.ComboBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.CssLayout;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Image;
import com.vaadin.ui.JavaScript;
import com.vaadin.ui.Label;
import com.vaadin.ui.Link;
import com.vaadin.ui.Panel;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import java.io.Serializable;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.PostConstruct;
import org.openthinclient.common.model.Realm;
import org.openthinclient.common.model.UnrecognizedClient;
import org.openthinclient.common.model.service.ApplicationService;
import org.openthinclient.common.model.service.ClientService;
import org.openthinclient.common.model.service.DeviceService;
import org.openthinclient.common.model.service.UnrecognizedClientService;
import org.openthinclient.ldap.DirectoryException;
import org.openthinclient.pkgmgr.PackageManager;
import org.openthinclient.service.update.UpdateChecker;
import org.openthinclient.web.dashboard.ContentPanel;
import org.openthinclient.web.dashboard.DashboardNotificationService;
import org.openthinclient.web.event.DashboardEvent;
import org.openthinclient.web.i18n.ConsoleWebMessages;
import org.openthinclient.web.ui.PrivacyNoticeInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.vaadin.spring.events.EventBus;
import org.vaadin.spring.events.annotation.EventBusListenerMethod;
import org.vaadin.spring.sidebar.annotation.SideBarItem;
import org.vaadin.spring.sidebar.annotation.ThemeIcon;

@SpringView(name="")
@SideBarItem(sectionId="client-management", caption="Dashboard", order=10)
@ThemeIcon(value="icon/dashboard.svg")
public class DashboardView
extends Panel
implements View {
    public static final String NAME = "";
    private static final String NEWS_URL = "https://openthinclient.com/manager_news/?";
    private static final Logger LOGGER = LoggerFactory.getLogger(DashboardView.class);
    @Autowired
    private ClientService clientService;
    @Autowired
    private ApplicationService applicationService;
    @Autowired
    private DeviceService deviceService;
    @Autowired
    private UnrecognizedClientService unrecognizedClientService;
    @Autowired
    private UpdateChecker updateChecker;
    @Autowired
    private PackageManager packageManager;
    @Value(value="${application.version}")
    private String applicationVersion;
    private EventBus.SessionEventBus eventBus;
    private final IMessageConveyor mc;
    private CssLayout dashboardPanels;
    private ComboBox<UnrecognizedClient> macCombo;

    @Autowired
    public DashboardView(EventBus.SessionEventBus eventBus, DashboardNotificationService notificationService) {
        this.setSizeFull();
        this.mc = new MessageConveyor(UI.getCurrent().getLocale());
        this.eventBus = eventBus;
        eventBus.publish((Object)this, (Object)new DashboardEvent.UpdateHeaderLabelEvent(this.mc.getMessage((Enum)ConsoleWebMessages.UI_DASHBOARDVIEW_HEADER, new Object[0])));
    }

    @PostConstruct
    public void init() {
        VerticalLayout root = new VerticalLayout();
        root.addComponents(new Component[]{this.buildContent(), new PrivacyNoticeInfo()});
        this.setContent((Component)root);
    }

    private Component buildContent() {
        this.dashboardPanels = new CssLayout();
        this.dashboardPanels.addStyleName("dashboard-panels");
        Responsive.makeResponsive((Component[])new Component[]{this.dashboardPanels});
        InfoContentPanel thinclientInfo = new InfoContentPanel(this.mc.getMessage((Enum)ConsoleWebMessages.UI_CLIENT_HEADER, new Object[0]), new ThemeResource("icon/thinclient.svg"), this.getInfoContent(() -> this.clientService.count()));
        InfoContentPanel applicationInfo = new InfoContentPanel(this.mc.getMessage((Enum)ConsoleWebMessages.UI_APPLICATION_HEADER, new Object[0]), new ThemeResource("icon/application.svg"), this.getInfoContent(() -> this.applicationService.count()));
        InfoContentPanel devicesInfo = new InfoContentPanel(this.mc.getMessage((Enum)ConsoleWebMessages.UI_DEVICE_HEADER, new Object[0]), new ThemeResource("icon/device.svg"), this.getInfoContent(() -> this.deviceService.count()));
        this.dashboardPanels.addComponents(new Component[]{thinclientInfo, applicationInfo, devicesInfo});
        UnregisteredClientsPanel ucp = new UnregisteredClientsPanel(this.mc.getMessage((Enum)ConsoleWebMessages.UI_DASHBOARDVIEW_UNREGISTERED_CLIENTS, new Object[0]), (Resource)new ThemeResource("icon/thinclient.svg"));
        this.dashboardPanels.addComponent((Component)ucp);
        this.dashboardPanels.addComponent((Component)new UpdatePanel());
        ContentPanel helpPanel = new ContentPanel(this.mc.getMessage((Enum)ConsoleWebMessages.UI_DASHBOARDVIEW_PANEL_HELP_TITLE, new Object[0]), (Resource)new ThemeResource("icon/help.svg"));
        helpPanel.addStyleName("size-1x2");
        helpPanel.addComponent((Component)new Label(this.mc.getMessage((Enum)ConsoleWebMessages.UI_DASHBOARDVIEW_PANEL_HELP_CONTENT, new Object[0]), ContentMode.HTML));
        ContentPanel toolsPanel = new ContentPanel(this.mc.getMessage((Enum)ConsoleWebMessages.UI_DASHBOARDVIEW_PANEL_TOOLS_TITLE, new Object[0]), (Resource)new ThemeResource("icon/meter.svg"));
        toolsPanel.addStyleName("size-1x2");
        toolsPanel.addComponent((Component)new Label(this.mc.getMessage((Enum)ConsoleWebMessages.UI_DASHBOARDVIEW_PANEL_TOOLS_CONTENT, new Object[0]), ContentMode.HTML));
        this.dashboardPanels.addComponents(new Component[]{helpPanel, toolsPanel, new NewsBrowser()});
        return this.dashboardPanels;
    }

    private String getInfoContent(Supplier<Integer> contentSupplier) {
        String info = NAME;
        try {
            info = String.valueOf(contentSupplier.get());
        }
        catch (Exception e) {
            LOGGER.warn("Cannot load content: " + e.getMessage());
        }
        return info;
    }

    @EventBusListenerMethod
    public void updatePXEClientList(DashboardEvent.PXEClientListRefreshEvent event) {
        try {
            Set clients = this.unrecognizedClientService.findAll();
            LOGGER.debug("Update PXE-client list, size {}", (Object)clients.size());
            this.macCombo.setDataProvider(new ListDataProvider((Collection)clients));
        }
        catch (Exception e) {
            LOGGER.warn("Cannot load content: " + e.getMessage());
        }
    }

    public void attach() {
        super.attach();
        this.eventBus.subscribe((Object)this);
    }

    public void detach() {
        this.eventBus.unsubscribe((Object)this);
        super.detach();
    }

    class UnregisteredClientsPanel
    extends ContentPanel {
        public UnregisteredClientsPanel(String title, Resource resource) {
            super(title, resource);
            this.addStyleName("unregistered-clients");
            this.setSpacing(false);
            this.addImageStyleName("dashboard-panel-image-circle");
            DashboardView.this.macCombo = new ComboBox();
            DashboardView.this.macCombo.setPlaceholder(DashboardView.this.mc.getMessage((Enum)ConsoleWebMessages.UI_THINCLIENT_MAC, new Object[0]));
            DashboardView.this.macCombo.setEmptySelectionAllowed(false);
            try {
                DashboardView.this.macCombo.setDataProvider(new ListDataProvider((Collection)DashboardView.this.unrecognizedClientService.findAll()));
            }
            catch (Exception e) {
                LOGGER.warn("Cannot load content: " + e.getMessage());
            }
            DashboardView.this.macCombo.setItemCaptionGenerator(UnrecognizedClient::getMacAddress);
            DashboardView.this.macCombo.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> UI.getCurrent().getNavigator().navigateTo("client_view/register/" + ((UnrecognizedClient)event.getValue()).getMacAddress()));
            HorizontalLayout hl = new HorizontalLayout();
            Button btn = new Button(DashboardView.this.mc.getMessage((Enum)ConsoleWebMessages.UI_PACKAGESOURCES_BUTTON_UPDATE_CAPTION, new Object[0]));
            btn.addStyleName("dashboard-panel-unregistered-clients-button");
            btn.setIcon((Resource)VaadinIcons.REFRESH);
            btn.addStyleName("borderless");
            btn.addClickListener((Button.ClickListener & Serializable)event -> {
                try {
                    DashboardView.this.macCombo.setDataProvider(new ListDataProvider((Collection)DashboardView.this.unrecognizedClientService.findAll()));
                }
                catch (Exception e) {
                    LOGGER.warn("Cannot load content: " + e.getMessage());
                }
            });
            Button btnCleanClients = new Button();
            btnCleanClients.addStyleName("dashboard-panel-unregistered-clients-clean-button");
            btnCleanClients.setIcon((Resource)VaadinIcons.TRASH);
            btnCleanClients.addStyleName("borderless");
            btnCleanClients.addClickListener((Button.ClickListener & Serializable)event -> {
                try {
                    DashboardView.this.unrecognizedClientService.findAll().forEach(directoryObject -> {
                        Realm realm = directoryObject.getRealm();
                        try {
                            realm.getDirectory().delete(directoryObject);
                        }
                        catch (DirectoryException e) {
                            LOGGER.info("Cannot delete unrecognizedClient: " + directoryObject + ": " + e.getMessage());
                        }
                    });
                    DashboardView.this.macCombo.setDataProvider(new ListDataProvider((Collection)DashboardView.this.unrecognizedClientService.findAll()));
                }
                catch (Exception e) {
                    LOGGER.warn("Cannot load content: " + e.getMessage());
                }
            });
            hl.addComponents(new Component[]{btn, btnCleanClients});
            this.addComponent((Component)hl);
            this.addComponent((Component)DashboardView.this.macCombo);
        }
    }

    class NewsBrowser
    extends CssLayout {
        public NewsBrowser() {
            this.addStyleNames(new String[]{"news-browser", "dashboard-panel", "size-2x3"});
            BrowserFrame frame = new BrowserFrame(null, (Resource)new ExternalResource("about:blank"));
            CssLayout fallback = new CssLayout();
            fallback.addComponents(new Component[]{new Image(null, (Resource)new ThemeResource("open_news.png")), new Label(DashboardView.this.mc.getMessage((Enum)ConsoleWebMessages.UI_DASHBOARDVIEW_PANEL_NEW_BROWSER_FALLBACK, new Object[0]), ContentMode.HTML)});
            fallback.addStyleName("fallback");
            this.addComponents(new Component[]{frame, fallback});
            JavaScript.getCurrent().execute(String.format("loadBrowserFrame('.news-browser .v-browserframe', '%s')", DashboardView.NEWS_URL + DashboardView.this.applicationVersion));
        }
    }

    class UpdatePanel
    extends ContentPanel {
        private static final String managerUpdateURL = "/ui/settings#!support";
        private static final String packagesUpdateURL = "/ui/settings#!package-management";
        private Label newVersionLabel;
        private Label newPackagesLabel;

        public UpdatePanel() {
            super(DashboardView.this.mc.getMessage((Enum)ConsoleWebMessages.UI_DASHBOARDVIEW_UPDATE_NOTICE_CAPTION, new Object[0]), (Resource)new ThemeResource("icon/bell.svg"));
            this.newVersionLabel = new Label();
            this.newPackagesLabel = new Label();
            this.addStyleNames(new String[]{"update-notification", "size-1x2"});
            if (DashboardView.this.updateChecker.hasNetworkError()) {
                Label errorNotification = new Label(DashboardView.this.mc.getMessage((Enum)ConsoleWebMessages.UI_DASHBOARDVIEW_UPDATE_NOTICE_NETWORK_ERROR, new Object[0]));
                errorNotification.setCaption(DashboardView.this.mc.getMessage((Enum)ConsoleWebMessages.UI_DASHBOARDVIEW_UPDATE_NOTICE_NETWORK_ERROR_CAPTION, new Object[0]));
                errorNotification.setIcon((Resource)VaadinIcons.EXCLAMATION_CIRCLE_O);
                errorNotification.setStyleName("update-error");
                this.addComponents(new Component[]{errorNotification});
            } else {
                CssLayout managerNotification = new CssLayout();
                managerNotification.setStyleName("manager-updates");
                CssLayout packagesNotification = new CssLayout();
                packagesNotification.setStyleName("package-updates");
                this.addComponents(new Component[]{managerNotification, packagesNotification});
                managerNotification.addComponents(new Component[]{new Label("openthinclient-Manager " + DashboardView.this.applicationVersion), new Link("Manager Updates", (Resource)new ExternalResource(managerUpdateURL)), this.newVersionLabel});
                this.updateManagerStatus(DashboardView.this.updateChecker.getNewVersion());
                packagesNotification.addComponents(new Component[]{new Label("openthinclient-OS"), new Link(DashboardView.this.mc.getMessage((Enum)ConsoleWebMessages.UI_PACKAGEMANAGERMAINNAVIGATORVIEW_CAPTION, new Object[0]), (Resource)new ExternalResource(packagesUpdateURL)), this.newPackagesLabel});
                this.updatePackageStatus(DashboardView.this.packageManager.getUpdateablePackages());
            }
        }

        void updateManagerStatus(Optional<String> newVersion) {
            if (newVersion.isPresent()) {
                this.newVersionLabel.setCaption(DashboardView.this.mc.getMessage((Enum)ConsoleWebMessages.UI_DASHBOARDVIEW_UPDATE_NOTICE_MANAGER_UPDATABLE, new Object[]{newVersion.get()}));
                this.newVersionLabel.setIcon((Resource)VaadinIcons.EXCLAMATION_CIRCLE_O);
            } else {
                this.newVersionLabel.setCaption(DashboardView.this.mc.getMessage((Enum)ConsoleWebMessages.UI_DASHBOARDVIEW_UPDATE_NOTICE_MANAGER_CURRENT, new Object[0]));
                this.newVersionLabel.setIcon((Resource)VaadinIcons.CHECK);
            }
        }

        void updatePackageStatus(Collection updatablePackages) {
            if (updatablePackages.size() > 0) {
                this.newPackagesLabel.setCaption(DashboardView.this.mc.getMessage((Enum)ConsoleWebMessages.UI_DASHBOARDVIEW_UPDATE_NOTICE_PACKAGES_UPDATABLE, new Object[0]));
                this.newPackagesLabel.setIcon((Resource)VaadinIcons.EXCLAMATION_CIRCLE_O);
            } else {
                this.newPackagesLabel.setCaption(DashboardView.this.mc.getMessage((Enum)ConsoleWebMessages.UI_DASHBOARDVIEW_UPDATE_NOTICE_PACKAGES_CURRENT, new Object[0]));
                this.newPackagesLabel.setIcon((Resource)VaadinIcons.CHECK);
            }
        }
    }

    class InfoContentPanel
    extends ContentPanel {
        public InfoContentPanel(String message, ThemeResource themeResource, String caption) {
            super(message, (Resource)themeResource);
            this.addImageStyleName("dashboard-panel-image-circle");
            if (caption != null) {
                Label label = new Label(caption);
                label.addStyleName("content-panel-number-large");
                this.addComponent((Component)label);
            }
        }
    }
}

