/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web.pkgmngr.ui.presenter;

import java.util.ArrayList;
import java.util.List;
import org.openthinclient.pkgmgr.db.Package;
import org.openthinclient.util.dpkg.PackageReference;
import org.openthinclient.util.dpkg.PackageReferenceList;
import org.openthinclient.web.pkgmngr.ui.view.AbstractPackageItem;
import org.openthinclient.web.pkgmngr.ui.view.MissingPackageItem;
import org.openthinclient.web.pkgmngr.ui.view.ResolvedPackageItem;

public class PackageDetailsUtil {
    public static MissingPackageItem createMissingPackageItem(PackageReference.SingleReference sr) {
        return PackageDetailsUtil.createMissingPackageItem(" (Missing)", sr);
    }

    public static MissingPackageItem createMissingPackageItem(String missingLabel, PackageReference.SingleReference sr) {
        String relation = sr.getRelation() != null ? sr.getRelation().getTextualRepresentation() + " " : "";
        String version = sr.getVersion() != null ? sr.getVersion().toStringWithoutEpoch() : "";
        return new MissingPackageItem(sr.getName() + missingLabel, relation.concat(version));
    }

    public static List<AbstractPackageItem> getReferencedPackageItems(PackageReferenceList packageReferenceList, List<Package> availablePackages, List<String> usedPackages) {
        ArrayList<AbstractPackageItem> items = new ArrayList<AbstractPackageItem>();
        for (PackageReference pr : packageReferenceList) {
            boolean isReferenced = false;
            for (Package _package : availablePackages) {
                if (!pr.matches(_package) || usedPackages.contains(_package.getName())) continue;
                items.add(new ResolvedPackageItem((PackageReference.SingleReference)pr));
                isReferenced = true;
                usedPackages.add(_package.getName());
            }
            if (isReferenced || !(pr instanceof PackageReference.SingleReference)) continue;
            items.add(PackageDetailsUtil.createMissingPackageItem("", (PackageReference.SingleReference)pr));
        }
        return items;
    }
}

