/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web.thinclient;

import ch.qos.cal10n.IMessageConveyor;
import ch.qos.cal10n.MessageConveyor;
import com.vaadin.spring.annotation.SpringView;
import com.vaadin.ui.UI;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import org.openthinclient.common.model.Application;
import org.openthinclient.common.model.ApplicationGroup;
import org.openthinclient.common.model.Client;
import org.openthinclient.common.model.DirectoryObject;
import org.openthinclient.common.model.User;
import org.openthinclient.common.model.UserGroup;
import org.openthinclient.common.model.schema.Schema;
import org.openthinclient.common.model.schema.provider.SchemaProvider;
import org.openthinclient.common.model.service.ApplicationGroupService;
import org.openthinclient.common.model.service.ApplicationService;
import org.openthinclient.common.model.service.ClientService;
import org.openthinclient.common.model.service.UserGroupService;
import org.openthinclient.common.model.service.UserService;
import org.openthinclient.web.OTCSideBar;
import org.openthinclient.web.dashboard.DashboardNotificationService;
import org.openthinclient.web.i18n.ConsoleWebMessages;
import org.openthinclient.web.thinclient.AbstractThinclientGroupView;
import org.openthinclient.web.thinclient.ProfileReferencesPanel;
import org.openthinclient.web.thinclient.model.Item;
import org.openthinclient.web.thinclient.presenter.ReferencePanelPresenter;
import org.openthinclient.web.ui.ManagerUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.vaadin.spring.events.EventBus;
import org.vaadin.spring.sidebar.annotation.ThemeIcon;

@SpringView(name="applicationgroup_view", ui={ManagerUI.class})
@ThemeIcon(value="icon/applicationgroup-white.svg")
public final class ApplicationGroupView
extends AbstractThinclientGroupView {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApplicationGroupView.class);
    public static final String NAME = "applicationgroup_view";
    public static final String ICON = "icon/applicationgroup-white.svg";
    public static final ConsoleWebMessages TITLE_KEY = ConsoleWebMessages.UI_APPLICATIONGROUP_HEADER;
    @Autowired
    private ClientService clientService;
    @Autowired
    private ApplicationGroupService applicationGroupService;
    @Autowired
    private ApplicationService applicationService;
    @Autowired
    private UserService userService;
    @Autowired
    private UserGroupService userGroupService;
    @Autowired
    private SchemaProvider schemaProvider;
    @Autowired
    @Qualifier(value="deviceSideBar")
    private OTCSideBar deviceSideBar;
    private final IMessageConveyor mc = new MessageConveyor(UI.getCurrent().getLocale());

    public ApplicationGroupView(EventBus.SessionEventBus eventBus, DashboardNotificationService notificationService) {
        super(ConsoleWebMessages.UI_APPLICATIONGROUP_HEADER, eventBus, notificationService);
    }

    @PostConstruct
    public void setup() {
        this.addStyleName("application_view");
        this.addCreateActionButton(this.mc.getMessage((Enum)ConsoleWebMessages.UI_THINCLIENT_ADD_GROUP_LABEL, new Object[0]), ICON, "applicationgroup_view/create");
    }

    @Override
    public HashSet getAllItems() {
        return (HashSet)this.applicationGroupService.findAll();
    }

    @Override
    public Schema getSchema(String schemaName) {
        return this.schemaProvider.getSchema(ApplicationGroup.class, schemaName);
    }

    @Override
    public Map<String, String> getSchemaNames() {
        return Stream.of(this.schemaProvider.getSchemaNames(ApplicationGroup.class)).collect(Collectors.toMap(schemaName -> schemaName, schemaName -> this.getSchema((String)schemaName).getLabel()));
    }

    @Override
    public ProfileReferencesPanel createReferencesPanel(DirectoryObject item) {
        ApplicationGroup applicationGroup = (ApplicationGroup)item;
        Set members = applicationGroup.getMembers();
        ProfileReferencesPanel referencesPanel = new ProfileReferencesPanel(item.getClass());
        ReferencePanelPresenter refPresenter = new ReferencePanelPresenter(referencesPanel);
        Set allApplications = this.applicationService.findAll();
        refPresenter.showReference(applicationGroup.getApplications(), this.mc.getMessage((Enum)ConsoleWebMessages.UI_APPLICATION_HEADER, new Object[0]), allApplications, Application.class, values -> this.saveApplicationGroupReference(applicationGroup, (List<Item>)values), null, false);
        Set allClients = this.clientService.findAllClientMetaData();
        refPresenter.showReference(members, this.mc.getMessage((Enum)ConsoleWebMessages.UI_CLIENT_HEADER, new Object[0]), allClients, Client.class, values -> this.saveReference((DirectoryObject)applicationGroup, (List<Item>)values, allClients, Client.class));
        Set allUsers = this.userService.findAll();
        this.getRealmService().findAllRealms().forEach(realm -> allUsers.removeAll(realm.getAdministrators().getMembers()));
        refPresenter.showReference(members, this.mc.getMessage((Enum)ConsoleWebMessages.UI_USER_HEADER, new Object[0]), allUsers, User.class, values -> this.saveReference((DirectoryObject)applicationGroup, (List<Item>)values, allUsers, User.class));
        Set allUserGroups = this.userGroupService.findAll();
        refPresenter.showReference(members, this.mc.getMessage((Enum)ConsoleWebMessages.UI_USERGROUP_HEADER, new Object[0]), allUserGroups, UserGroup.class, values -> this.saveReference((DirectoryObject)applicationGroup, (List<Item>)values, allUserGroups, UserGroup.class));
        return referencesPanel;
    }

    private void saveApplicationGroupReference(ApplicationGroup applicationGroup, List<Item> values) {
        List<Application> oldValues = this.applicationService.findAll().stream().filter(application -> application.getMembers().contains(applicationGroup)).collect(Collectors.toList());
        LOGGER.debug(applicationGroup.getName() + " applications: {}", oldValues);
        oldValues.forEach(oldItem -> {
            if (values.stream().anyMatch(a -> a.getName().equals(oldItem.getName()))) {
                LOGGER.info("Keep oldValue as member: " + oldItem);
            } else {
                LOGGER.info("Remove oldValue from applicationGroup: " + oldItem);
                if (oldItem.getMembers().contains(applicationGroup)) {
                    oldItem.getMembers().remove(applicationGroup);
                    this.applicationService.save((DirectoryObject)oldItem);
                } else {
                    LOGGER.info("ApplicationGroup (to remove) not found in members of " + oldItem);
                }
            }
        });
        values.forEach(newValue -> {
            Application application = (Application)this.applicationService.findByName(newValue.getName());
            if (application != null) {
                if (!oldValues.contains(application)) {
                    LOGGER.info("Add ApplicationGroup to members of: " + newValue);
                    applicationGroup.getApplications().add(application);
                    application.getMembers().add(applicationGroup);
                    this.applicationService.save((DirectoryObject)application);
                }
            } else {
                LOGGER.info("Application not found for " + newValue);
            }
        });
    }

    @Override
    public <T extends DirectoryObject> T getFreshProfile(String name) {
        return (T)this.applicationGroupService.findByName(name);
    }

    @Override
    public void save(DirectoryObject profile) {
        LOGGER.info("Save: " + profile);
        this.applicationGroupService.save((DirectoryObject)((ApplicationGroup)profile));
    }

    @Override
    public Client getClient(String name) {
        return (Client)this.clientService.findByName(name);
    }

    @Override
    public String getViewName() {
        return NAME;
    }

    @Override
    public String getParentViewName() {
        return "application_view";
    }

    @Override
    public ConsoleWebMessages getViewTitleKey() {
        return TITLE_KEY;
    }

    @Override
    public void selectItem(DirectoryObject directoryObject) {
        LOGGER.info("sideBar: " + (Object)((Object)this.deviceSideBar));
        this.deviceSideBar.selectItem(NAME, directoryObject, this.getAllItems());
    }
}

