/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web.thinclient;

import ch.qos.cal10n.IMessageConveyor;
import ch.qos.cal10n.MessageConveyor;
import com.vaadin.icons.VaadinIcons;
import com.vaadin.server.Resource;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.CssLayout;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.NativeButton;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import java.util.List;
import org.openthinclient.web.i18n.ConsoleWebMessages;
import org.openthinclient.web.thinclient.component.CollapseablePanel;
import org.openthinclient.web.thinclient.component.ItemGroupPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfilePanel
extends CssLayout {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProfilePanel.class);
    private VerticalLayout rows;
    private CssLayout panelCaption;
    private VerticalLayout panelMetaInformation;
    private Button copyAction;
    private Button deleteProfileAction;
    private ItemGroupPanel metaDataIGP;
    IMessageConveyor mc = new MessageConveyor(UI.getCurrent().getLocale());
    private Label infoLabel;
    private NativeButton save;
    private NativeButton reset;

    public ProfilePanel(String name, Class clazz) {
        this.addStyleName("card");
        this.panelCaption = new CssLayout();
        this.panelCaption.addStyleName("settings-caption");
        Label label = new Label(name);
        this.panelCaption.addComponent((Component)label);
        this.copyAction = new Button();
        this.copyAction.setDescription(this.mc.getMessage((Enum)ConsoleWebMessages.UI_PROFILE_PANEL_BUTTON_ALT_TEXT_COPY, new Object[0]));
        this.copyAction.setIcon((Resource)VaadinIcons.COPY_O);
        this.copyAction.addStyleName("borderless-colored");
        this.copyAction.addStyleName("small");
        this.copyAction.addStyleName("icon-only");
        this.panelCaption.addComponent((Component)this.copyAction);
        this.deleteProfileAction = new Button();
        this.deleteProfileAction.setDescription(this.mc.getMessage((Enum)ConsoleWebMessages.UI_PROFILE_PANEL_BUTTON_ALT_TEXT_DELETE, new Object[0]));
        this.deleteProfileAction.setIcon((Resource)VaadinIcons.TRASH);
        this.deleteProfileAction.addStyleName("borderless-colored");
        this.deleteProfileAction.addStyleName("icon-only");
        this.panelCaption.addComponent((Component)this.deleteProfileAction);
        this.addComponent((Component)this.panelCaption);
        this.panelMetaInformation = new VerticalLayout();
        this.addComponent((Component)this.panelMetaInformation);
        this.panelMetaInformation.setVisible(false);
        this.panelMetaInformation.setMargin(false);
        this.panelMetaInformation.setSpacing(false);
        this.panelMetaInformation.addStyleName("panelMetaInformation");
        this.rows = new VerticalLayout();
        this.addComponent((Component)this.rows);
        this.rows.setMargin(false);
        this.rows.setSpacing(false);
        this.rows.setStyleName("panelRows");
        this.setStyleName("profilePanel");
        this.addStyleName("formPanel_" + clazz.getSimpleName().toLowerCase());
        this.addComponent((Component)this.createActionsBar());
    }

    public void addPanelCaptionComponent(Component component) {
        this.panelCaption.addComponent(component, this.panelCaption.getComponentCount() - 2);
    }

    private HorizontalLayout createActionsBar() {
        this.save = new NativeButton(this.mc.getMessage((Enum)ConsoleWebMessages.UI_BUTTON_SAVE, new Object[0]));
        this.save.addStyleName("profile_save");
        this.save.setEnabled(false);
        this.reset = new NativeButton(this.mc.getMessage((Enum)ConsoleWebMessages.UI_BUTTON_RESET, new Object[0]));
        this.reset.addStyleName("profile_reset");
        this.infoLabel = new Label();
        this.infoLabel.setCaption("");
        this.infoLabel.setVisible(true);
        this.infoLabel.setStyleName("propertyLabel");
        this.infoLabel.addStyleName("itemGroupInfoLabel");
        HorizontalLayout actions = new HorizontalLayout();
        actions.setSizeFull();
        actions.addComponents(new Component[]{this.reset, this.save});
        HorizontalLayout proprow = new HorizontalLayout();
        proprow.setStyleName("property-action");
        proprow.addComponent((Component)this.infoLabel);
        proprow.addComponent((Component)actions);
        return proprow;
    }

    public void setError(String caption) {
        this.infoLabel.setCaption(caption);
        this.infoLabel.removeStyleName("form_success");
        this.infoLabel.addStyleName("form_error");
        this.infoLabel.setVisible(true);
    }

    public void setInfo(String caption) {
        this.infoLabel.setCaption(caption);
        this.infoLabel.removeStyleName("form_error");
        this.infoLabel.addStyleName("form_success");
        this.infoLabel.setVisible(true);
    }

    public void handleItemGroupVisibility(CollapseablePanel cp) {
        this.rows.forEach(component -> {
            CollapseablePanel igp = (CollapseablePanel)component;
            if (!igp.equals(cp)) {
                igp.collapseItems();
            }
        });
    }

    public void setPanelMetaInformation(List<Component> components) {
        this.panelMetaInformation.addComponents(components.toArray(new Component[0]));
    }

    public Button getCopyAction() {
        return this.copyAction;
    }

    public Button getDeleteProfileAction() {
        return this.deleteProfileAction;
    }

    public void showMetaInformation() {
    }

    public VerticalLayout getRows() {
        return this.rows;
    }

    public Button getSaveButton() {
        return this.save;
    }

    public Button getResetButton() {
        return this.reset;
    }

    public void setDisabledMode() {
        this.save.setEnabled(false);
        this.reset.setEnabled(false);
    }
}

