/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web.thinclient.component;

import com.vaadin.icons.VaadinIcons;
import com.vaadin.navigator.Navigator;
import com.vaadin.server.Resource;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.CssLayout;
import com.vaadin.ui.UI;
import java.io.Serializable;
import org.openthinclient.web.thinclient.model.Item;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemButtonComponent
extends CssLayout {
    private static final Logger LOGGER = LoggerFactory.getLogger(ItemButtonComponent.class);
    private Button itemButton;

    public ItemButtonComponent(Item item, boolean isReadOnly) {
        this.addStyleName("referenceItem");
        Button referencedItemsButton = new Button(item.getName());
        referencedItemsButton.addStyleName("link");
        referencedItemsButton.addStyleName("referenceItemLink");
        referencedItemsButton.addClickListener((Button.ClickListener & Serializable)e -> {
            Navigator navigator = UI.getCurrent().getNavigator();
            String navigationState = item.getType().name().toLowerCase() + "_view/edit/" + item.getName();
            LOGGER.info("Navigate to " + navigationState);
            navigator.navigateTo(navigationState);
        });
        this.addComponent((Component)referencedItemsButton);
        if (!isReadOnly) {
            this.itemButton = new Button();
            this.itemButton.setIcon((Resource)VaadinIcons.CLOSE_CIRCLE_O);
            this.itemButton.addStyleName("icon-only");
            this.itemButton.addStyleName("borderless-colored");
            this.itemButton.addStyleName("referenceItemIconButton");
            this.itemButton.setVisible(false);
            this.addComponent((Component)this.itemButton);
        }
    }

    public void addClickListener(Button.ClickListener clickListener) {
        if (this.itemButton != null) {
            this.itemButton.setVisible(true);
            this.itemButton.addClickListener(clickListener);
        }
    }
}

