/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web.thinclient.property;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.openthinclient.web.thinclient.model.ItemConfiguration;
import org.openthinclient.web.thinclient.model.SelectOption;
import org.openthinclient.web.thinclient.property.OtcProperty;

public class OtcBooleanProperty
extends OtcProperty {
    private ItemConfiguration config;
    private String valueOfTrue;
    private String valueOfFalse;
    private String labelOfTrue;
    private String labelOfFalse;
    private static final String JUST_ONE_WORD = "\\s*\\S+\\s*";

    public OtcBooleanProperty(String label, String tip, String key, String initialValue, SelectOption falseOption, SelectOption trueOption) {
        super(label, tip, key, initialValue);
        this.valueOfTrue = trueOption.getValue();
        this.valueOfFalse = falseOption.getValue();
        this.labelOfTrue = trueOption.getLabel();
        if (this.labelOfTrue.matches(JUST_ONE_WORD)) {
            this.labelOfTrue = null;
        }
        this.labelOfFalse = falseOption.getLabel();
        if (this.labelOfFalse.matches(JUST_ONE_WORD)) {
            this.labelOfFalse = null;
        }
    }

    @Override
    public void setConfiguration(ItemConfiguration bean) {
        this.config = bean;
    }

    @Override
    public ItemConfiguration getConfiguration() {
        return this.config;
    }

    public boolean isValue() {
        if (this.config.getValue() == null || this.config.getValue().length() == 0) {
            return this.getInitialValue().equals(this.valueOfTrue);
        }
        return this.config.getValue().equals(this.valueOfTrue);
    }

    public void setValue(boolean value) {
        this.config.setValue(value ? this.valueOfTrue : this.valueOfFalse);
    }

    public String getLabelFor(boolean value) {
        return value ? this.labelOfTrue : this.labelOfFalse;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("label", (Object)this.getLabel()).append("key", (Object)this.getKey()).append("initialValue", (Object)this.getInitialValue()).append("value", this.isValue()).toString();
    }
}

