/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web.thinclient.property;

import edu.emory.mathcs.backport.java.util.Arrays;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.openthinclient.web.thinclient.component.ItemGroupPanel;
import org.openthinclient.web.thinclient.property.OtcProperty;

public class OtcPropertyGroup {
    private final String label;
    private List<OtcProperty> otcProperties = new ArrayList<OtcProperty>();
    private List<OtcPropertyGroup> groups = new ArrayList<OtcPropertyGroup>();
    private Consumer<ItemGroupPanel> valueWrittenConsumer;
    private boolean displayHeaderLabel = true;
    private boolean collapseOnDisplay = false;

    public OtcPropertyGroup(String label, OtcProperty ... otcProperties) {
        this.label = label;
        if (otcProperties != null) {
            Arrays.asList((Object[])otcProperties).forEach(o -> this.otcProperties.add((OtcProperty)o));
        }
    }

    public List<OtcProperty> getOtcProperties() {
        return this.otcProperties;
    }

    public String getLabel() {
        return this.label;
    }

    public List<OtcPropertyGroup> getGroups() {
        return this.groups;
    }

    public void addGroup(OtcPropertyGroup group) {
        this.groups.add(group);
    }

    public void addProperty(OtcProperty property) {
        this.otcProperties.add(property);
    }

    public void removeProperty(String key) {
        this.otcProperties.stream().filter(otcProperty -> otcProperty.getKey().equals(key)).findFirst().ifPresent(otcProperty -> this.otcProperties.remove(otcProperty));
    }

    public Optional<OtcProperty> getProperty(String key) {
        return this.otcProperties.stream().filter(otcProperty -> otcProperty.getKey().equals(key)).findFirst();
    }

    public List<OtcPropertyGroup> getAllOtcPropertyGroups() {
        ArrayList<OtcPropertyGroup> all = new ArrayList<OtcPropertyGroup>(this.groups);
        this.groups.forEach(group -> all.addAll(group.getAllOtcPropertyGroups()));
        return all;
    }

    public void onValueWritten(Consumer<ItemGroupPanel> consumer) {
        this.valueWrittenConsumer = consumer;
    }

    public Consumer<ItemGroupPanel> getValueWrittenConsumer() {
        return this.valueWrittenConsumer;
    }

    public void addGroup(int index, OtcPropertyGroup group) {
        this.groups.add(index, group);
    }

    public boolean isCollapseOnDisplay() {
        return this.collapseOnDisplay;
    }

    public void setCollapseOnDisplay(boolean collapseOnDisplay) {
        this.collapseOnDisplay = collapseOnDisplay;
    }

    public boolean isDisplayHeaderLabel() {
        return this.displayHeaderLabel;
    }

    public void setDisplayHeaderLabel(boolean displayHeaderLabel) {
        this.displayHeaderLabel = displayHeaderLabel;
    }
}

