/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web.ui;

import ch.qos.cal10n.IMessageConveyor;
import ch.qos.cal10n.MessageConveyor;
import com.vaadin.icons.VaadinIcons;
import com.vaadin.server.Resource;
import com.vaadin.shared.ui.ContentMode;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.CssLayout;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.Window;
import java.io.Serializable;
import org.openthinclient.web.i18n.ConsoleWebMessages;
import org.openthinclient.web.ui.PrivacyNotice;

public class PrivacyNoticeInfo
extends CssLayout {
    Label infoText;
    Button ackButton;
    Button showButton;
    IMessageConveyor mc;
    PrivacyNotice privacyNotice = PrivacyNotice.load();
    Window popupWindow;

    public PrivacyNoticeInfo() {
        this.mc = new MessageConveyor(UI.getCurrent().getLocale());
        this.infoText = new Label(this.mc.getMessage((Enum)ConsoleWebMessages.UI_DASHBOARDVIEW_PRIVACY_NOTICE_INFO, new Object[0]));
        this.ackButton = new Button((Resource)VaadinIcons.CLOSE_CIRCLE_O, (Button.ClickListener & Serializable)ev -> this.collapse());
        this.showButton = new Button(this.mc.getMessage((Enum)ConsoleWebMessages.UI_DASHBOARDVIEW_PRIVACY_NOTICE_CAPTION, new Object[0]), (Button.ClickListener & Serializable)ev -> this.popup());
        this.showButton.setStyleName("link");
        this.popupWindow = this.buildPopupWindow();
        this.addStyleName("privacy-notice-info");
        if (this.privacyNotice.isAcknowledged()) {
            this.collapse();
        } else {
            this.expand();
        }
    }

    private Window buildPopupWindow() {
        String lang = UI.getCurrent().getLocale().getLanguage();
        Label text = new Label(this.privacyNotice.get(lang), ContentMode.HTML);
        Button closeButton = new Button("OK");
        VerticalLayout layout = new VerticalLayout(new Component[]{text, closeButton});
        layout.setSpacing(false);
        layout.addStyleName("privacy-notice-content");
        Window win = new Window(this.mc.getMessage((Enum)ConsoleWebMessages.UI_DASHBOARDVIEW_PRIVACY_NOTICE_CAPTION, new Object[0]), (Component)layout);
        win.setResizable(false);
        win.addCloseListener((Window.CloseListener & Serializable)event -> UI.getCurrent().removeWindow(this.popupWindow));
        closeButton.addClickListener((Button.ClickListener & Serializable)ev -> win.close());
        return win;
    }

    public void expand() {
        this.addStyleName("expanded");
        this.removeAllComponents();
        this.addComponents(new Component[]{new HorizontalLayout(new Component[]{this.infoText, this.showButton}), this.ackButton});
    }

    public void collapse() {
        this.privacyNotice.setAcknowledged();
        this.removeStyleName("expanded");
        this.removeAllComponents();
        this.addComponents(new Component[]{this.showButton});
    }

    public void popup() {
        UI.getCurrent().removeWindow(this.popupWindow);
        UI.getCurrent().addWindow(this.popupWindow);
        this.popupWindow.center();
        this.collapse();
    }
}

