/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.spring.sidebar.components;

import com.vaadin.annotations.StyleSheet;
import com.vaadin.navigator.ViewChangeListener;
import com.vaadin.server.Sizeable;
import com.vaadin.ui.Accordion;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.NativeButton;
import com.vaadin.ui.Panel;
import com.vaadin.ui.VerticalLayout;
import java.util.Collection;
import org.vaadin.spring.sidebar.SideBarItemDescriptor;
import org.vaadin.spring.sidebar.SideBarSectionDescriptor;
import org.vaadin.spring.sidebar.SideBarUtils;
import org.vaadin.spring.sidebar.components.AbstractSideBar;

@StyleSheet(value={"vaadin://addons/sidebar/sidebar.css"})
public class AccordionSideBar
extends AbstractSideBar<Accordion> {
    private static final long serialVersionUID = 2268915666228648275L;
    public static final String SIDE_BAR_STYLE = "sideBar";
    public static final String SIDE_BAR_SECTION_ITEM_STYLE = "sideBarSectionItem";
    public static final String SIDE_BAR_SECTION_STYLE = "sideBarSection";
    public static final String SELECTED_STYLE = "selected";

    public AccordionSideBar(SideBarUtils sideBarUtils) {
        super(sideBarUtils);
        this.addStyleName(SIDE_BAR_STYLE);
        this.setHeight("100%");
        this.setWidth("150px");
    }

    @Override
    protected Accordion createCompositionRoot() {
        Accordion accordion = new Accordion();
        accordion.setSizeFull();
        return accordion;
    }

    @Override
    protected AbstractSideBar.SectionComponentFactory<Accordion> createDefaultSectionComponentFactory() {
        return new DefaultSectionComponentFactory();
    }

    @Override
    protected AbstractSideBar.ItemComponentFactory createDefaultItemComponentFactory() {
        return new DefaultItemComponentFactory();
    }

    public class DefaultItemComponentFactory
    implements AbstractSideBar.ItemComponentFactory {
        @Override
        public Component createItemComponent(SideBarItemDescriptor descriptor) {
            if (descriptor instanceof SideBarItemDescriptor.ViewItemDescriptor) {
                return new ViewItemButton((SideBarItemDescriptor.ViewItemDescriptor)descriptor);
            }
            return new ItemButton(descriptor);
        }
    }

    public class DefaultSectionComponentFactory
    implements AbstractSideBar.SectionComponentFactory<Accordion> {
        private AbstractSideBar.ItemComponentFactory itemComponentFactory;

        @Override
        public void setItemComponentFactory(AbstractSideBar.ItemComponentFactory itemComponentFactory) {
            this.itemComponentFactory = itemComponentFactory;
        }

        @Override
        public void createSection(Accordion compositionRoot, SideBarSectionDescriptor descriptor, Collection<SideBarItemDescriptor> itemDescriptors) {
            Panel panel = new Panel();
            panel.addStyleName(AccordionSideBar.SIDE_BAR_SECTION_STYLE);
            panel.setSizeFull();
            VerticalLayout layout = new VerticalLayout();
            panel.setContent((Component)layout);
            for (SideBarItemDescriptor item : itemDescriptors) {
                layout.addComponent(this.itemComponentFactory.createItemComponent(item));
            }
            compositionRoot.addTab((Component)panel, descriptor.getCaption());
        }
    }

    static class ViewItemButton
    extends ItemButton
    implements ViewChangeListener {
        private static final long serialVersionUID = -9062573995531971821L;
        private final String viewName;

        ViewItemButton(SideBarItemDescriptor.ViewItemDescriptor descriptor) {
            super(descriptor);
            this.viewName = descriptor.getViewName();
        }

        public void attach() {
            super.attach();
            if (this.getUI().getNavigator() == null) {
                throw new IllegalStateException("Please configure the Navigator before you attach the SideBar to the UI");
            }
            this.getUI().getNavigator().addViewChangeListener((ViewChangeListener)this);
        }

        public void detach() {
            this.getUI().getNavigator().removeViewChangeListener((ViewChangeListener)this);
            super.detach();
        }

        public boolean beforeViewChange(ViewChangeListener.ViewChangeEvent event) {
            return true;
        }

        public void afterViewChange(ViewChangeListener.ViewChangeEvent event) {
            if (event.getViewName().equals(this.viewName)) {
                this.addStyleName(AccordionSideBar.SELECTED_STYLE);
            } else {
                this.removeStyleName(AccordionSideBar.SELECTED_STYLE);
            }
        }
    }

    static class ItemButton
    extends NativeButton {
        private static final long serialVersionUID = 7051031354148037389L;

        ItemButton(final SideBarItemDescriptor descriptor) {
            this.setCaption(descriptor.getCaption());
            this.setIcon(descriptor.getIcon());
            this.setId(descriptor.getItemId());
            this.setDisableOnClick(true);
            this.addStyleName(AccordionSideBar.SIDE_BAR_SECTION_ITEM_STYLE);
            this.setWidth(100.0f, Sizeable.Unit.PERCENTAGE);
            this.addClickListener(new Button.ClickListener(){
                private static final long serialVersionUID = -8512905888847432801L;

                public void buttonClick(Button.ClickEvent event) {
                    try {
                        descriptor.itemInvoked(this.getUI());
                    }
                    finally {
                        this.setEnabled(true);
                    }
                }
            });
        }
    }
}

