/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.common.model.schema.provider;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.openthinclient.common.model.schema.Schema;
import org.openthinclient.common.model.schema.provider.SchemaLoadingException;
import org.openthinclient.common.model.schema.provider.SchemaProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;

public abstract class AbstractSchemaProvider
implements SchemaProvider {
    public static final String SCHEMA_PATH = "schema";
    private static final JAXBContext CONTEXT;
    private static final Logger logger;
    protected Map<String, Map<String, Schema>> typeCache = new HashMap<String, Map<String, Schema>>();

    @Override
    public Schema getSchema(Class profileType, String schemaName) throws SchemaLoadingException {
        try {
            String profileTypeName = profileType.getName().toLowerCase();
            profileTypeName = profileTypeName.substring(profileTypeName.lastIndexOf(46) + 1);
            if (!this.typeCache.containsKey(profileTypeName)) {
                this.getSchemaNames(profileType);
            }
            Map<String, Schema> schemas = this.typeCache.get(profileTypeName);
            if (null != schemaName && schemas.containsKey(schemaName)) {
                return schemas.get(schemaName);
            }
            return schemas.get(profileTypeName);
        }
        catch (Exception e) {
            logger.error("Schema couldn't be loaded! " + e);
            return null;
        }
    }

    @Override
    public String[] getSchemaNames(Class profileType) throws SchemaLoadingException {
        Object schemas;
        String profileTypeName = profileType.getName().toLowerCase();
        if (!this.typeCache.containsKey(profileTypeName = profileTypeName.substring(profileTypeName.lastIndexOf(46) + 1))) {
            schemas = new ArrayList<Schema>();
            schemas.addAll(this.loadAllSchemas(profileTypeName));
            schemas.addAll(this.loadDefaultSchema(profileTypeName));
            Map<String, Schema> schemasByName = this.typeCache.get(profileTypeName);
            if (null == schemasByName) {
                schemasByName = new HashMap<String, Schema>();
                this.typeCache.put(profileTypeName, schemasByName);
            }
            Iterator iterator = schemas.iterator();
            while (iterator.hasNext()) {
                Schema schema = (Schema)iterator.next();
                schemasByName.put(schema.getName(), schema);
            }
        }
        if (null == (schemas = this.typeCache.get(profileTypeName))) {
            logger.error("No schemas found for " + profileType);
            return new String[0];
        }
        String[] keys = new String[schemas.keySet().size()];
        return schemas.keySet().toArray(keys);
    }

    protected abstract List<Schema> loadDefaultSchema(String var1) throws SchemaLoadingException;

    protected abstract List<Schema> loadAllSchemas(String var1) throws SchemaLoadingException;

    protected Schema loadSchema(InputStream is) throws SchemaLoadingException {
        try {
            InputSource source = new InputSource(is);
            Unmarshaller unmarshaller = CONTEXT.createUnmarshaller();
            return (Schema)unmarshaller.unmarshal(source);
        }
        catch (Exception e) {
            throw new SchemaLoadingException("Schema couldn't be loaded!", e);
        }
    }

    @Override
    public void reload() {
        this.typeCache = new HashMap<String, Map<String, Schema>>();
    }

    static {
        logger = LoggerFactory.getLogger(AbstractSchemaProvider.class);
        try {
            CONTEXT = JAXBContext.newInstance((Class[])new Class[]{Schema.class});
        }
        catch (JAXBException e) {
            throw new RuntimeException("Failed to initialize JAXB mapping", e);
        }
    }
}

