/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.manager.standalone.config;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.openthinclient.db.conf.DataSourceConfiguration;
import org.openthinclient.manager.standalone.config.DirectoryServicesConfiguration;
import org.openthinclient.manager.standalone.migrate.Migrations;
import org.openthinclient.meta.PackageMetadataManager;
import org.openthinclient.service.common.ServiceManager;
import org.openthinclient.service.common.home.ManagerHome;
import org.openthinclient.service.common.home.impl.ApplianceConfiguration;
import org.openthinclient.service.common.home.impl.ManagerHomeFactory;
import org.openthinclient.service.common.license.LicenseUpdaterConfiguration;
import org.openthinclient.service.update.UpdateCheckerConfiguration;
import org.openthinclient.sysreport.config.StatisticsReportingConfiguration;
import org.openthinclient.web.WebApplicationConfiguration;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;

@SpringBootApplication
@Import(value={WebApplicationConfiguration.class, DataSourceConfiguration.class, DirectoryServicesConfiguration.class, LicenseUpdaterConfiguration.class, UpdateCheckerConfiguration.class, StatisticsReportingConfiguration.class})
public class ManagerStandaloneServerConfiguration {
    @Bean
    public ManagerHome managerHome() {
        ManagerHomeFactory factory = new ManagerHomeFactory();
        ManagerHome managerHome = factory.create();
        Migrations.runEarlyMigrations(managerHome);
        return managerHome;
    }

    @Bean
    public ServiceManager serviceManager() {
        return new ServiceManager();
    }

    @Bean
    public ApplianceConfiguration applianceConfiguration() throws IOException {
        return ApplianceConfiguration.get((ManagerHome)this.managerHome());
    }

    @Bean
    public PackageMetadataManager packageMetadataManager() throws Exception {
        Path managerHomeRoot = this.managerHome().getLocation().toPath();
        Path metadataDirectory = managerHomeRoot.resolve("nfs/root/package-metadata");
        if (!Files.isDirectory(metadataDirectory, new LinkOption[0])) {
            Files.createDirectories(metadataDirectory, new FileAttribute[0]);
        }
        return new PackageMetadataManager(metadataDirectory, managerHomeRoot);
    }
}

