/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.viritin.button;

import com.vaadin.server.FileDownloader;
import com.vaadin.server.Resource;
import com.vaadin.server.StreamResource;
import com.vaadin.ui.AbstractComponent;
import com.vaadin.ui.Button;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Serializable;
import org.vaadin.viritin.fluency.ui.FluentAbstractComponent;

public class DownloadButton
extends Button
implements FluentAbstractComponent<DownloadButton> {
    private static final long serialVersionUID = 356223526447669958L;
    private ContentWriter writer;
    private MimeTypeProvider mimeTypeProvider;
    private FileNameProvider fileNameProvider;
    private final StreamResource streamResource = new StreamResource(new StreamResource.StreamSource(){
        private static final long serialVersionUID = 3641967669172064511L;

        public InputStream getStream() {
            try {
                PipedOutputStream out = new PipedOutputStream();
                PipedInputStream in = new PipedInputStream(out);
                DownloadButton.this.writeResponce(out);
                return in;
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }, ""){
        private static final long serialVersionUID = -8221900203840804581L;

        public String getFilename() {
            if (DownloadButton.this.fileNameProvider != null) {
                return DownloadButton.this.fileNameProvider.getFileName();
            }
            return DownloadButton.this.getFileName();
        }

        public String getMIMEType() {
            if (DownloadButton.this.mimeTypeProvider != null) {
                return DownloadButton.this.mimeTypeProvider.getMimeType();
            }
            return super.getMIMEType();
        }
    };

    public DownloadButton() {
        new FileDownloader((Resource)this.streamResource).extend((AbstractComponent)this);
    }

    public DownloadButton(ContentWriter writer) {
        this();
        this.writer = writer;
    }

    protected void writeResponce(final PipedOutputStream out) {
        new Thread(){

            @Override
            public void run() {
                try {
                    DownloadButton.this.getWriter().write(out);
                    out.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }.start();
    }

    public ContentWriter getWriter() {
        return this.writer;
    }

    public String getMimeType() {
        return this.streamResource.getMIMEType();
    }

    public DownloadButton setMimeType(String mimeType) {
        this.streamResource.setMIMEType(mimeType);
        return this;
    }

    public DownloadButton setCacheTime(long cacheTime) {
        this.streamResource.setCacheTime(cacheTime);
        return this;
    }

    public DownloadButton setWriter(ContentWriter writer) {
        this.writer = writer;
        return this;
    }

    public String getFileName() {
        return this.fileNameProvider != null ? this.fileNameProvider.getFileName() : "file";
    }

    public DownloadButton setFileName(final String fileName) {
        this.fileNameProvider = new FileNameProvider(){
            private static final long serialVersionUID = -3449552786114328636L;

            @Override
            public String getFileName() {
                return fileName;
            }
        };
        return this;
    }

    @Override
    public DownloadButton withIcon(Resource icon) {
        this.setIcon(icon);
        return this;
    }

    public MimeTypeProvider getMimeTypeProvider() {
        return this.mimeTypeProvider;
    }

    public FileNameProvider getFileNameProvider() {
        return this.fileNameProvider;
    }

    public DownloadButton setFileNameProvider(FileNameProvider fileNameProvider) {
        this.fileNameProvider = fileNameProvider;
        return this;
    }

    public DownloadButton setMimeTypeProvider(MimeTypeProvider mimeTypeProvider) {
        this.mimeTypeProvider = mimeTypeProvider;
        return this;
    }

    public static interface MimeTypeProvider
    extends Serializable {
        public String getMimeType();
    }

    public static interface FileNameProvider
    extends Serializable {
        public String getFileName();
    }

    public static interface ContentWriter {
        public void write(OutputStream var1);
    }
}

