/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.viritin.form;

import com.vaadin.data.BeanValidationBinder;
import com.vaadin.data.Binder;
import com.vaadin.data.HasValue;
import com.vaadin.data.StatusChangeListener;
import com.vaadin.server.ClientConnector;
import com.vaadin.ui.AbstractComponentContainer;
import com.vaadin.ui.AbstractField;
import com.vaadin.ui.AbstractTextField;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.CustomComponent;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.UI;
import com.vaadin.ui.Window;
import java.io.Serializable;
import org.vaadin.viritin.button.DeleteButton;
import org.vaadin.viritin.button.MButton;
import org.vaadin.viritin.button.PrimaryButton;
import org.vaadin.viritin.layouts.MHorizontalLayout;

public abstract class AbstractForm<T>
extends CustomComponent {
    private boolean settingBean;
    private T entity;
    private SavedHandler<T> savedHandler;
    private ResetHandler<T> resetHandler;
    private DeleteHandler<T> deleteHandler;
    private String modalWindowTitle = "Edit entry";
    private String saveCaption = "Save";
    private String deleteCaption = "Delete";
    private String cancelCaption = "Cancel";
    private Window popup;
    private Binder<T> binder;
    private boolean hasChanges = false;
    private Button saveButton;
    private Button resetButton;
    private Button deleteButton;

    public AbstractForm(Class<T> entityType) {
        this.addAttachListener(new ClientConnector.AttachListener(){
            private static final long serialVersionUID = 3193438171004932112L;

            public void attach(ClientConnector.AttachEvent event) {
                AbstractForm.this.lazyInit();
            }
        });
        this.binder = new BeanValidationBinder(entityType);
        this.binder.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
            if (!this.settingBean) {
                this.hasChanges = true;
            }
        });
        this.binder.addStatusChangeListener((StatusChangeListener & Serializable)e -> {
            if (!this.settingBean) {
                this.hasChanges = true;
            }
            this.adjustResetButtonState();
            this.adjustSaveButtonState();
        });
    }

    public void setEntity(T entity) {
        this.entity = entity;
        this.settingBean = true;
        this.lazyInit();
        if (entity != null) {
            this.binder.setBean(entity);
            this.hasChanges = false;
            this.setVisible(true);
        } else {
            this.binder.setBean(null);
            this.hasChanges = false;
            this.setVisible(false);
        }
        this.settingBean = false;
    }

    public boolean hasChanges() {
        return this.hasChanges;
    }

    public void setSavedHandler(SavedHandler<T> savedHandler) {
        this.savedHandler = savedHandler;
        this.getSaveButton().setVisible(this.savedHandler != null);
    }

    public void setResetHandler(ResetHandler<T> resetHandler) {
        this.resetHandler = resetHandler;
        this.getResetButton().setVisible(this.resetHandler != null);
    }

    public void setDeleteHandler(DeleteHandler<T> deleteHandler) {
        this.deleteHandler = deleteHandler;
        this.getDeleteButton().setVisible(this.deleteHandler != null);
    }

    public ResetHandler<T> getResetHandler() {
        return this.resetHandler;
    }

    public SavedHandler<T> getSavedHandler() {
        return this.savedHandler;
    }

    public DeleteHandler<T> getDeleteHandler() {
        return this.deleteHandler;
    }

    public String getSaveCaption() {
        return this.saveCaption;
    }

    public void setSaveCaption(String saveCaption) {
        this.saveCaption = saveCaption;
    }

    public String getModalWindowTitle() {
        return this.modalWindowTitle;
    }

    public void setModalWindowTitle(String modalWindowTitle) {
        this.modalWindowTitle = modalWindowTitle;
    }

    public String getDeleteCaption() {
        return this.deleteCaption;
    }

    public void setDeleteCaption(String deleteCaption) {
        this.deleteCaption = deleteCaption;
    }

    public String getCancelCaption() {
        return this.cancelCaption;
    }

    public void setCancelCaption(String cancelCaption) {
        this.cancelCaption = cancelCaption;
    }

    public Binder<T> getBinder() {
        return this.binder;
    }

    public void setBinder(Binder<T> binder) {
        this.binder = binder;
    }

    protected void lazyInit() {
        if (this.getCompositionRoot() == null) {
            this.setCompositionRoot(this.createContent());
            this.bind();
        }
    }

    protected void bind() {
        this.binder.bindInstanceFields((Object)this);
    }

    protected abstract Component createContent();

    protected void adjustSaveButtonState() {
        if (this.isBound()) {
            boolean valid = this.binder.isValid();
            this.getSaveButton().setEnabled(this.hasChanges() && valid);
        }
    }

    public Button getSaveButton() {
        if (this.saveButton == null) {
            this.setSaveButton(this.createSaveButton());
        }
        return this.saveButton;
    }

    protected Button createSaveButton() {
        return (Button)new PrimaryButton(this.getSaveCaption()).withVisible(false);
    }

    protected boolean isBound() {
        return this.binder != null && this.binder.getBean() != null;
    }

    protected Button createResetButton() {
        return (Button)new MButton(this.getCancelCaption()).withVisible(false);
    }

    public Button getResetButton() {
        if (this.resetButton == null) {
            this.setResetButton(this.createResetButton());
        }
        return this.resetButton;
    }

    public void setResetButton(Button resetButton) {
        this.resetButton = resetButton;
        this.resetButton.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = -19755976436277487L;

            public void buttonClick(Button.ClickEvent event) {
                AbstractForm.this.reset(event);
            }
        });
    }

    protected Button createDeleteButton() {
        return (Button)new DeleteButton(this.getDeleteCaption()).withVisible(false);
    }

    public void setDeleteButton(Button deleteButton) {
        this.deleteButton = deleteButton;
        deleteButton.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = -2693734056915561664L;

            public void buttonClick(Button.ClickEvent event) {
                AbstractForm.this.delete(event);
            }
        });
    }

    public Button getDeleteButton() {
        if (this.deleteButton == null) {
            this.setDeleteButton(this.createDeleteButton());
        }
        return this.deleteButton;
    }

    protected void adjustResetButtonState() {
        if (this.popup != null && this.popup.getParent() != null) {
            this.getResetButton().setEnabled(true);
            return;
        }
        if (this.isBound()) {
            boolean modified = this.hasChanges();
            this.getResetButton().setEnabled(modified || this.popup != null);
        }
    }

    private void setSaveButton(Button button) {
        this.saveButton = button;
        this.saveButton.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = -2058398434893034442L;

            public void buttonClick(Button.ClickEvent event) {
                AbstractForm.this.save(event);
            }
        });
    }

    public T getEntity() {
        return this.entity;
    }

    protected void save(Button.ClickEvent e) {
        this.savedHandler.onSave(this.getEntity());
        this.hasChanges = false;
        this.adjustSaveButtonState();
        this.adjustResetButtonState();
    }

    protected void reset(Button.ClickEvent e) {
        this.resetHandler.onReset(this.getEntity());
        this.hasChanges = false;
        this.adjustSaveButtonState();
        this.adjustResetButtonState();
    }

    protected void delete(Button.ClickEvent e) {
        this.deleteHandler.onDelete(this.getEntity());
        this.hasChanges = false;
    }

    public HorizontalLayout getToolbar() {
        return new MHorizontalLayout(new Component[]{this.getSaveButton(), this.getResetButton(), this.getDeleteButton()});
    }

    public Window openInModalPopup() {
        this.popup = new Window(this.getModalWindowTitle(), (Component)this);
        this.popup.setModal(true);
        UI.getCurrent().addWindow(this.popup);
        this.focusFirst();
        return this.popup;
    }

    public void focusFirst() {
        Component compositionRoot = this.getCompositionRoot();
        this.findFieldAndFocus(compositionRoot);
    }

    private boolean findFieldAndFocus(Component compositionRoot) {
        if (compositionRoot instanceof AbstractComponentContainer) {
            AbstractComponentContainer cc = (AbstractComponentContainer)compositionRoot;
            for (Component component : cc) {
                if (component instanceof AbstractTextField) {
                    AbstractTextField abstractTextField = (AbstractTextField)component;
                    abstractTextField.selectAll();
                    return true;
                }
                if (component instanceof AbstractField) {
                    AbstractField abstractField = (AbstractField)component;
                    abstractField.focus();
                    return true;
                }
                if (!(component instanceof AbstractComponentContainer) || !this.findFieldAndFocus(component)) continue;
                return true;
            }
        }
        return false;
    }

    public Window getPopup() {
        return this.popup;
    }

    public void closePopup() {
        if (this.getPopup() != null) {
            this.getPopup().close();
        }
    }

    public static interface DeleteHandler<T>
    extends Serializable {
        public void onDelete(T var1);
    }

    public static interface ResetHandler<T>
    extends Serializable {
        public void onReset(T var1);
    }

    public static interface SavedHandler<T>
    extends Serializable {
        public void onSave(T var1);
    }
}

