/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.viritin.label;

import com.vaadin.shared.ui.ContentMode;
import com.vaadin.ui.Label;
import org.jsoup.Jsoup;
import org.jsoup.safety.Whitelist;

public class Header
extends Label {
    private static final long serialVersionUID = -2879612973232108854L;
    private String text;
    private int headerLevel = 1;

    protected Whitelist getWhitelist() {
        return Whitelist.none();
    }

    @Deprecated
    public Header setWhitelist(Whitelist whitelist) {
        this.markAsDirty();
        return this;
    }

    public String getText() {
        return this.text;
    }

    public Header setText(String text) {
        this.text = text;
        this.markAsDirty();
        return this;
    }

    public int getHeaderLevel() {
        return this.headerLevel;
    }

    public Header setHeaderLevel(int headerLevel) {
        if (headerLevel < 1 || headerLevel > 6) {
            throw new IllegalArgumentException("Header levels 1-6 supported");
        }
        this.headerLevel = headerLevel;
        this.markAsDirty();
        return this;
    }

    public Header(String headerText) {
        this.text = headerText;
    }

    public void setValue(String newStringValue) {
        this.setText(newStringValue);
    }

    public void beforeClientResponse(boolean initial) {
        this.render();
        super.beforeClientResponse(initial);
    }

    private void render() {
        if (this.text != null) {
            this.setContentMode(ContentMode.HTML);
            StringBuilder sb = new StringBuilder("<h");
            sb.append(this.headerLevel);
            sb.append(">");
            sb.append(Jsoup.clean((String)this.text, (Whitelist)this.getWhitelist()));
            sb.append("</h");
            sb.append(this.headerLevel);
            sb.append(">");
            super.setValue(sb.toString());
            this.text = null;
        }
    }

    public Header withStyleName(String ... styleNames) {
        for (String styleName : styleNames) {
            this.addStyleName(styleName);
        }
        return this;
    }
}

