/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.viritin.label;

import com.vaadin.shared.ui.ContentMode;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.jsoup.Jsoup;
import org.jsoup.safety.Whitelist;
import org.markdown4j.Markdown4jProcessor;
import org.vaadin.viritin.MSize;
import org.vaadin.viritin.label.MLabel;

public class RichText
extends MLabel {
    private static final long serialVersionUID = -6926829115110918731L;
    private transient Whitelist whitelist;
    private String richText;

    public RichText() {
        this.setWidth("100%");
    }

    public RichText(String content) {
        this.setWidth("100%");
        this.setRichText(content);
    }

    public RichText withMarkDown(String markdown) {
        try {
            return this.setRichText(new Markdown4jProcessor().process(markdown));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public RichText withMarkDown(InputStream markdown) {
        try {
            return this.setRichText(new Markdown4jProcessor().process(markdown));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public RichText withSafeHtml(String html) {
        return this.setRichText(html);
    }

    public RichText withSafeHtml(InputStream markdown) {
        try {
            return this.setRichText(IOUtils.toString((InputStream)markdown, (String)"UTF-8"));
        }
        catch (IOException ex) {
            throw new RuntimeException("Input stream coulnd't be read!", ex);
        }
    }

    public RichText withNewLines(String text) {
        return this.setRichText(text.replaceAll("(\\r|\\n|\\r\\n)+", "<br />"));
    }

    public Whitelist getWhitelist() {
        if (this.whitelist == null) {
            return Whitelist.relaxed();
        }
        return this.whitelist;
    }

    @Deprecated
    public RichText setWhitelist(Whitelist whitelist) {
        this.whitelist = whitelist;
        this.markAsDirty();
        return this;
    }

    public void setValue(String newStringValue) {
        this.setRichText(newStringValue);
    }

    public String getText() {
        return this.richText;
    }

    public RichText setRichText(String text) {
        this.richText = text;
        this.markAsDirty();
        return this;
    }

    public void beforeClientResponse(boolean initial) {
        this.setContentMode(ContentMode.HTML);
        super.setValue(Jsoup.clean((String)this.richText, (Whitelist)this.getWhitelist()));
        super.beforeClientResponse(initial);
    }

    public RichText withMarkDownResource(String resourceName) {
        return this.withMarkDown(this.getClass().getResourceAsStream(resourceName));
    }

    public RichText withSafeHtmlResource(String resourceName) {
        return this.withSafeHtml(this.getClass().getResourceAsStream(resourceName));
    }

    @Override
    public RichText withContent(String content) {
        return this.setRichText(content);
    }

    @Override
    public RichText withContentMode(ContentMode mode) {
        this.setContentMode(mode);
        return this;
    }

    @Override
    public RichText withValue(String value) {
        return this.setRichText(value);
    }

    @Override
    public RichText withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    public RichText withVisible(boolean visible) {
        super.withVisible(visible);
        return this;
    }

    @Override
    public RichText withEnabled(boolean enabled) {
        super.withEnabled(enabled);
        return this;
    }

    @Override
    public RichText withWidthUndefined() {
        super.withWidthUndefined();
        return this;
    }

    @Override
    public RichText withFullHeight() {
        super.withFullHeight();
        return this;
    }

    @Override
    public RichText withFullWidth() {
        super.withFullWidth();
        return this;
    }

    @Override
    public RichText withStyleName(String ... styleNames) {
        super.withStyleName(styleNames);
        return this;
    }

    @Override
    public RichText withSize(MSize mSize) {
        super.withSize(mSize);
        return this;
    }

    @Override
    public RichText withSize(String width, String height) {
        super.withSize(width, height);
        return this;
    }

    @Override
    public RichText withHeight(String height) {
        super.withHeight(height);
        return this;
    }

    @Override
    public RichText withWidth(String width) {
        super.withWidth(width);
        return this;
    }

    @Override
    public RichText withCaption(String caption) {
        super.withCaption(caption);
        return this;
    }
}

