/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.viritin.util;

import com.vaadin.server.VaadinRequest;
import com.vaadin.server.VaadinSession;
import com.vaadin.ui.AbstractComponent;
import com.vaadin.ui.Component;
import com.vaadin.ui.HasComponents;
import com.vaadin.ui.UI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Stack;
import org.vaadin.viritin.util.Java7LocaleNegotiationStrategy;

public class VaadinLocale {
    private static final String LOCALE_SESSION_ATTRIBUTE = "org.vaadin.viritin.selectedLocale";
    private final List<Locale> supportedLocales = new ArrayList<Locale>();
    private Locale bestLocaleByAcceptHeader;
    private final LocaleNegotiationStrategey localeNegotiationStrategey;

    public VaadinLocale(LocaleNegotiationStrategey localeNegotiationStrategey, Locale ... supportedLocales) {
        if (supportedLocales == null || supportedLocales.length == 0) {
            throw new IllegalArgumentException("At least one locale must be supported");
        }
        if (localeNegotiationStrategey == null) {
            throw new IllegalArgumentException("localeNegotiatinStrategy may not be null!");
        }
        this.localeNegotiationStrategey = localeNegotiationStrategey;
        this.supportedLocales.addAll(Arrays.asList(supportedLocales));
    }

    public VaadinLocale(LocaleNegotiationStrategey localeNegotiationStrategey, VaadinRequest vaadinRequest, Locale ... supportedLocales) {
        this(localeNegotiationStrategey, supportedLocales);
        this.setVaadinRequest(vaadinRequest);
        this.updateVaadinLocale();
    }

    public VaadinLocale(Locale ... supportedLocales) {
        this((LocaleNegotiationStrategey)new Java7LocaleNegotiationStrategy(), supportedLocales);
    }

    public void setVaadinRequest(VaadinRequest vaadinRequest) {
        if (vaadinRequest == null) {
            throw new IllegalArgumentException("VaadinRequest is needed!");
        }
        this.bestLocaleByAcceptHeader = this.localeNegotiationStrategey.negotiate(this.supportedLocales, vaadinRequest);
        this.updateVaadinLocale();
    }

    public void setLocale(Locale locale) {
        if (locale != null && !this.supportedLocales.contains(locale)) {
            throw new IllegalArgumentException("Locale " + locale + " is not supported.");
        }
        if (locale == null) {
            VaadinSession.getCurrent().setAttribute(LOCALE_SESSION_ATTRIBUTE, null);
        } else {
            VaadinSession.getCurrent().setAttribute(LOCALE_SESSION_ATTRIBUTE, (Object)locale.toLanguageTag());
        }
        this.updateVaadinLocale();
    }

    public void unsetLocale() {
        this.setLocale(null);
    }

    private void updateVaadinLocale() {
        Locale locale = this.getLocale();
        UI.getCurrent().setLocale(locale);
        VaadinSession.getCurrent().setLocale(locale);
        this.recursiveSetLocale();
    }

    private void recursiveSetLocale() {
        Stack stack = new Stack();
        stack.addAll(VaadinSession.getCurrent().getUIs());
        while (!stack.isEmpty()) {
            Component component = (Component)stack.pop();
            if (component instanceof HasComponents) {
                Iterator i = ((HasComponents)component).iterator();
                while (i.hasNext()) {
                    stack.add(i.next());
                }
            }
            if (!(component instanceof AbstractComponent)) continue;
            AbstractComponent abstractComponent = (AbstractComponent)component;
            abstractComponent.setLocale(UI.getCurrent().getLocale());
        }
    }

    public Locale getLocale() {
        String locale = (String)VaadinSession.getCurrent().getAttribute(LOCALE_SESSION_ATTRIBUTE);
        if (locale != null) {
            return Locale.forLanguageTag(locale);
        }
        if (this.bestLocaleByAcceptHeader != null) {
            return this.bestLocaleByAcceptHeader;
        }
        return this.supportedLocales.get(0);
    }

    public Locale getBestLocaleByAcceptHeader() {
        return this.bestLocaleByAcceptHeader;
    }

    public List<Locale> getSupportedLocales() {
        return new ArrayList<Locale>(this.supportedLocales);
    }

    public static interface LocaleNegotiationStrategey {
        public Locale negotiate(List<Locale> var1, VaadinRequest var2);
    }
}

