/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.viritin.v7;

import com.vaadin.v7.data.Item;
import com.vaadin.v7.data.Property;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.beanutils.WrapDynaBean;
import org.apache.commons.beanutils.expression.DefaultResolver;
import org.apache.commons.lang3.ClassUtils;
import org.vaadin.viritin.v7.ListContainer;

public class DynaBeanItem<T>
implements Item {
    private static final long serialVersionUID = -5073690046197951234L;
    private final Map<Object, DynaProperty> propertyIdToProperty = new HashMap<Object, DynaProperty>();
    private final T bean;
    private transient DynaBean db;

    public DynaBeanItem(T bean) {
        this.bean = bean;
    }

    public T getBean() {
        return this.bean;
    }

    private DynaBean getDynaBean() {
        if (this.db == null) {
            this.db = new WrapDynaBean(this.bean);
        }
        return this.db;
    }

    public Property getItemProperty(Object id) {
        DefaultResolver defaultResolver;
        String propertyName = id.toString();
        if (!(this.getDynaBean().getDynaClass().getDynaProperty(propertyName) != null || (defaultResolver = new DefaultResolver()).hasNested(propertyName) || defaultResolver.isIndexed(propertyName) || defaultResolver.hasNested(propertyName))) {
            return null;
        }
        DynaProperty prop = this.propertyIdToProperty.get(id);
        if (prop == null) {
            prop = new DynaProperty(propertyName);
            this.propertyIdToProperty.put(id, prop);
        }
        return prop;
    }

    public Collection<String> getItemPropertyIds() {
        ArrayList<String> properties = new ArrayList<String>();
        for (org.apache.commons.beanutils.DynaProperty dp : this.getDynaBean().getDynaClass().getDynaProperties()) {
            properties.add(dp.getName());
        }
        properties.remove("class");
        return properties;
    }

    public boolean addItemProperty(Object id, Property property) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean removeItemProperty(Object id) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private class DynaProperty
    implements Property {
        private static final long serialVersionUID = -2419540615310696644L;
        private final String propertyName;

        DynaProperty(String property) {
            this.propertyName = property;
        }

        public Object getValue() {
            try {
                return DynaBeanItem.this.getDynaBean().get(this.propertyName);
            }
            catch (Exception e) {
                try {
                    return PropertyUtils.getProperty((Object)DynaBeanItem.this.bean, (String)this.propertyName);
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }

        public void setValue(Object newValue) throws Property.ReadOnlyException {
            DynaBeanItem.this.getDynaBean().set(this.propertyName, newValue);
        }

        public Class<?> getType() {
            try {
                org.apache.commons.beanutils.DynaProperty dynaProperty = DynaBeanItem.this.getDynaBean().getDynaClass().getDynaProperty(this.propertyName);
                Class type = dynaProperty.getType();
                if (type.isPrimitive()) {
                    return ClassUtils.primitiveToWrapper((Class)type);
                }
                return type;
            }
            catch (Exception e) {
                try {
                    return ListContainer.getNestedPropertyType(DynaBeanItem.this.getDynaBean().getDynaClass(), this.propertyName);
                }
                catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }

        public boolean isReadOnly() {
            return true;
        }

        public void setReadOnly(boolean newStatus) {
        }
    }
}

