/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.viritin.v7;

import com.vaadin.v7.data.Container;
import com.vaadin.v7.data.Item;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.data.util.AbstractContainer;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaClass;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.beanutils.NestedNullException;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.beanutils.WrapDynaBean;
import org.apache.commons.beanutils.WrapDynaClass;
import org.apache.commons.beanutils.expression.DefaultResolver;
import org.apache.commons.beanutils.expression.Resolver;
import org.apache.commons.collections.comparators.ComparableComparator;
import org.apache.commons.collections.comparators.NullComparator;
import org.apache.commons.collections.comparators.ReverseComparator;
import org.apache.commons.lang3.ClassUtils;
import org.vaadin.viritin.LazyList;
import org.vaadin.viritin.v7.SortableLazyList;

public class ListContainer<T>
extends AbstractContainer
implements Container.Indexed,
Container.Sortable,
Container.ItemSetChangeNotifier {
    private static final long serialVersionUID = -6709228455051205922L;
    private List<T> backingList;
    private List<String> properties;
    private transient DynaClass dynaClass;
    private static Resolver resolver = new DefaultResolver();

    public ListContainer(Collection<? extends T> backingList) {
        this.setCollection(backingList);
    }

    public ListContainer(Class<? extends T> type, Collection<? extends T> backingList) {
        if (type != null) {
            this.dynaClass = WrapDynaClass.createDynaClass(type);
        }
        this.setCollection(backingList);
    }

    public final void setCollection(Collection<? extends T> backingList1) {
        this.backingList = backingList1 instanceof List ? (List<Object>)backingList1 : new ArrayList<T>(backingList1);
        this.fireItemSetChange();
    }

    public ListContainer(Class<? extends T> type) {
        this.backingList = new ArrayList<T>();
        this.dynaClass = WrapDynaClass.createDynaClass(type);
    }

    public ListContainer(Class<? extends T> type, String ... properties) {
        this(type);
        this.setContainerPropertyIds(properties);
    }

    public ListContainer(DynaClass type) {
        this.backingList = new ArrayList<T>();
        this.dynaClass = type;
    }

    public ListContainer(DynaClass type, String ... properties) {
        this(type);
        this.setContainerPropertyIds(properties);
    }

    protected List<T> getBackingList() {
        return this.backingList;
    }

    private DynaClass getDynaClass() {
        if (this.dynaClass == null && !this.backingList.isEmpty()) {
            return this.getDynaClass(this.backingList.get(0));
        }
        return this.dynaClass;
    }

    private DynaClass getDynaClass(Object reference) {
        if (this.dynaClass == null && reference != null) {
            this.dynaClass = reference instanceof DynaBean ? ((DynaBean)reference).getDynaClass() : WrapDynaClass.createDynaClass(reference.getClass());
        }
        return this.dynaClass;
    }

    public int indexOfId(Object itemId) {
        return this.getBackingList().indexOf(itemId);
    }

    public int indexOf(T bean) {
        return this.indexOfId(bean);
    }

    public T getIdByIndex(int index) {
        return this.getBackingList().get(index);
    }

    public List<T> getItemIds(int startIndex, int numberOfItems) {
        if (numberOfItems < 0) {
            throw new IllegalArgumentException();
        }
        return this.getBackingList().subList(startIndex, startIndex + numberOfItems);
    }

    public Object addItemAt(int index) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Item addItemAt(int index, Object newItemId) throws UnsupportedOperationException {
        this.backingList.add(index, newItemId);
        this.fireItemSetChange();
        return this.getItem(newItemId);
    }

    public T nextItemId(Object itemId) {
        int i = this.getBackingList().indexOf(itemId) + 1;
        if (this.getBackingList().size() == i) {
            return null;
        }
        return this.getBackingList().get(i);
    }

    public T prevItemId(Object itemId) {
        int i = this.getBackingList().indexOf(itemId) - 1;
        if (i < 0) {
            return null;
        }
        return this.getBackingList().get(i);
    }

    public T firstItemId() {
        return this.getBackingList().isEmpty() ? null : (T)this.getBackingList().get(0);
    }

    public T lastItemId() {
        return this.getBackingList().isEmpty() ? null : (T)this.getBackingList().get(this.getBackingList().size() - 1);
    }

    public boolean isFirstId(Object itemId) {
        return itemId.equals(this.firstItemId());
    }

    public boolean isLastId(Object itemId) {
        return itemId.equals(this.lastItemId());
    }

    public Object addItemAfter(Object previousItemId) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Item addItemAfter(Object previousItemId, Object newItemId) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Item getItem(Object itemId) {
        if (itemId == null) {
            return null;
        }
        return new DynaBeanItem<Object>(itemId);
    }

    public Collection<String> getContainerPropertyIds() {
        if (this.properties == null) {
            if (this.getDynaClass() != null) {
                ArrayList<String> props = new ArrayList<String>();
                for (DynaProperty db : this.getDynaClass().getDynaProperties()) {
                    if (db.getType() != null) {
                        props.add(db.getName());
                        continue;
                    }
                    Logger.getLogger(ListContainer.class.getName()).log(Level.FINE, "Type not detected for property {0}", db.getName());
                }
                props.remove("class");
                this.properties = props;
            } else {
                return Collections.EMPTY_LIST;
            }
        }
        return this.properties;
    }

    public Collection<?> getItemIds() {
        return this.getBackingList();
    }

    public Property getContainerProperty(Object itemId, Object propertyId) {
        Item i = this.getItem(itemId);
        return i != null ? i.getItemProperty(propertyId) : null;
    }

    public Class<?> getType(Object propertyId) {
        String pName = propertyId.toString();
        try {
            DynaProperty dynaProperty = this.getDynaClass().getDynaProperty(pName);
            Class type = dynaProperty.getType();
            if (type.isPrimitive()) {
                return ClassUtils.primitiveToWrapper((Class)type);
            }
            return type;
        }
        catch (Exception e) {
            try {
                return ListContainer.getNestedPropertyType(this.getDynaClass(), pName);
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public static Class<?> getNestedPropertyType(DynaClass bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, ClassNotFoundException, NoSuchFieldException {
        Class<?> type;
        if (bean == null) {
            return Object.class;
        }
        while (resolver.hasNested(name)) {
            String next = resolver.next(name);
            if (resolver.isIndexed(next) || resolver.isMapped(next)) {
                String property = resolver.getProperty(next);
                Class<?> clazz = Class.forName(bean.getName());
                Class<?> detectTypeParameter = ListContainer.detectTypeParameter(clazz, property, resolver.isIndexed(name) ? 0 : 1);
                bean = WrapDynaClass.createDynaClass(detectTypeParameter);
                return ListContainer.getNestedPropertyType(bean, resolver.remove(name));
            }
            DynaProperty db = bean.getDynaProperty(next);
            bean = WrapDynaClass.createDynaClass((Class)db.getType());
            name = resolver.remove(name);
        }
        if (resolver.isMapped(name) || resolver.isIndexed(name)) {
            String property = resolver.getProperty(name);
            Class<?> clazz = Class.forName(bean.getName());
            return ListContainer.detectTypeParameter(clazz, property, resolver.isIndexed(name) ? 0 : 1);
        }
        DynaProperty dynaProperty = bean.getDynaProperty(name);
        if (dynaProperty != null) {
            type = dynaProperty.getType();
        } else {
            Method method = ListContainer.obtainGetterOfProperty(bean, name);
            type = method.getReturnType();
        }
        if (type.isPrimitive()) {
            return ClassUtils.primitiveToWrapper(type);
        }
        return type;
    }

    private static Method obtainGetterOfProperty(DynaClass beanClass, String propertyName) throws ClassNotFoundException, NoSuchMethodException, SecurityException {
        Class<?> clazz = Class.forName(beanClass.getName());
        return clazz.getMethod("get" + ListContainer.firstLetterUppercase(propertyName), new Class[0]);
    }

    private static String firstLetterUppercase(String s) {
        return Character.toUpperCase(s.charAt(0)) + (s.length() > 1 ? s.substring(1) : "");
    }

    private static Class<?> detectTypeParameter(Class clazz, String name, int idx) throws NoSuchFieldException {
        Field declaredField = clazz.getDeclaredField(name);
        Type genericType = declaredField.getGenericType();
        if (genericType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)genericType;
            return (Class)parameterizedType.getActualTypeArguments()[idx];
        }
        return Object.class;
    }

    public int size() {
        return this.getBackingList().size();
    }

    public boolean containsId(Object itemId) {
        return this.getBackingList().contains(itemId);
    }

    public Item addItem(Object itemId) throws UnsupportedOperationException {
        this.backingList.add(itemId);
        this.fireItemSetChange();
        return this.getItem(itemId);
    }

    public Object addItem() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean removeItem(Object itemId) throws UnsupportedOperationException {
        boolean remove = this.backingList.remove(itemId);
        if (remove) {
            this.fireItemSetChange();
        }
        return remove;
    }

    public boolean addContainerProperty(Object propertyId, Class<?> type, Object defaultValue) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean removeContainerProperty(Object propertyId) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean removeAllItems() throws UnsupportedOperationException {
        this.backingList.clear();
        this.fireItemSetChange();
        return true;
    }

    public ListContainer addAll(Collection<T> beans) {
        this.backingList.addAll(beans);
        this.fireItemSetChange();
        return this;
    }

    public void sort(Object[] propertyId, boolean[] ascending) {
        if (propertyId.length > 0) {
            if (this.backingList instanceof SortableLazyList) {
                SortableLazyList sll = (SortableLazyList)this.backingList;
                String[] stringProperties = new String[propertyId.length];
                System.arraycopy(propertyId, 0, stringProperties, 0, propertyId.length);
                sll.setSortProperty(stringProperties);
                sll.setSortAscending(ascending);
                sll.reset();
            } else {
                PropertyComparator comparator = new PropertyComparator(propertyId, ascending);
                Collections.sort(this.backingList, comparator);
            }
            this.fireItemSetChange();
        }
    }

    public Collection<?> getSortableContainerPropertyIds() {
        if (!(this.backingList instanceof SortableLazyList) && this.backingList instanceof LazyList) {
            return Collections.emptySet();
        }
        ArrayList<String> props = new ArrayList<String>();
        for (String a : this.getContainerPropertyIds()) {
            String propName = a.toString();
            try {
                Class<?> propType = this.getType(propName);
                if (propType == null || !propType.isPrimitive() && !Comparable.class.isAssignableFrom(propType)) continue;
                props.add(propName);
            }
            catch (Exception exception) {}
        }
        return props;
    }

    public void addItemSetChangeListener(Container.ItemSetChangeListener listener) {
        super.addItemSetChangeListener(listener);
    }

    public void removeItemSetChangeListener(Container.ItemSetChangeListener listener) {
        super.removeItemSetChangeListener(listener);
    }

    public void addListener(Container.ItemSetChangeListener listener) {
        super.addListener(listener);
    }

    public void removeListener(Container.ItemSetChangeListener listener) {
        super.removeListener(listener);
    }

    protected Comparator<?> getUnderlyingComparator(Object property) {
        return new NullComparator();
    }

    public void setContainerPropertyIds(String ... properties) {
        this.properties = Arrays.asList(properties);
    }

    public void fireItemSetChange() {
        super.fireItemSetChange();
    }

    public class DynaBeanItem<T>
    implements Item {
        private static final long serialVersionUID = 39911097876284908L;
        private final Map<Object, DynaProperty> propertyIdToProperty = new HashMap<Object, DynaProperty>();
        private final T bean;
        private transient DynaBean db;

        public DynaBeanItem(T bean) {
            this.bean = bean;
        }

        public T getBean() {
            return this.bean;
        }

        private DynaBean getDynaBean() {
            if (this.db == null) {
                try {
                    this.db = this.bean instanceof DynaBean ? (DynaBean)this.bean : new WrapDynaBean(this.bean, (WrapDynaClass)ListContainer.this.getDynaClass(this.bean));
                }
                catch (Throwable e) {
                    this.db = new WrapDynaBean(this.bean);
                }
            }
            return this.db;
        }

        public Property getItemProperty(Object id) {
            DynaProperty prop = this.propertyIdToProperty.get(id);
            if (prop == null) {
                prop = new DynaProperty(id.toString());
                this.propertyIdToProperty.put(id, prop);
            }
            return prop;
        }

        public Collection<String> getItemPropertyIds() {
            return ListContainer.this.getContainerPropertyIds();
        }

        public boolean addItemProperty(Object id, Property property) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public boolean removeItemProperty(Object id) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        private class DynaProperty
        implements Property {
            private static final long serialVersionUID = -6887983770952190177L;
            private boolean readOnly;
            private final String propertyName;

            DynaProperty(String property) {
                this.propertyName = property;
                this.readOnly = false;
            }

            public Object getValue() {
                DynaBean dynaBean = DynaBeanItem.this.getDynaBean();
                try {
                    return dynaBean.get(this.propertyName);
                }
                catch (Exception e) {
                    try {
                        return PropertyUtils.getProperty((Object)DynaBeanItem.this.bean, (String)this.propertyName);
                    }
                    catch (IndexOutOfBoundsException | NestedNullException ex) {
                        return null;
                    }
                    catch (IllegalAccessException | InvocationTargetException ex) {
                        throw new RuntimeException(ex);
                    }
                    catch (NoSuchMethodException ex) {
                        Logger.getLogger(ListContainer.class.getName()).log(Level.FINE, "Trying default method fallback for property {0}", this.propertyName);
                        try {
                            Method method = ListContainer.obtainGetterOfProperty(dynaBean.getDynaClass(), this.propertyName);
                            return method.invoke(DynaBeanItem.this.bean, new Object[0]);
                        }
                        catch (IllegalArgumentException | ReflectiveOperationException | SecurityException e2) {
                            throw new RuntimeException(e2);
                        }
                    }
                }
            }

            public void setValue(Object newValue) throws Property.ReadOnlyException {
                if (this.isReadOnly()) {
                    throw new Property.ReadOnlyException();
                }
                try {
                    PropertyUtils.setProperty((Object)DynaBeanItem.this.bean, (String)this.propertyName, (Object)newValue);
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
                    throw new RuntimeException(ex);
                }
            }

            public Class getType() {
                return ListContainer.this.getType(this.propertyName);
            }

            public boolean isReadOnly() {
                DynaClass clazz = ListContainer.this.getDynaClass();
                if (clazz instanceof WrapDynaClass) {
                    return ((WrapDynaClass)clazz).getPropertyDescriptor(this.propertyName).getWriteMethod() == null;
                }
                return this.readOnly;
            }

            public void setReadOnly(boolean newStatus) {
                this.readOnly = newStatus;
            }
        }
    }

    private class PropertyComparator
    implements Comparator<T> {
        private final Object[] propertyId;
        private final boolean[] ascending;

        private PropertyComparator(Object[] propertyId, boolean[] ascending) {
            this.propertyId = propertyId;
            this.ascending = ascending;
        }

        @Override
        public int compare(T o1, T o2) {
            for (int i = 0; i < this.propertyId.length; ++i) {
                Property o2Prop;
                Object o2Value;
                Property o1Prop;
                Object o1Value;
                int compare;
                ComparableComparator currentComparator;
                ComparableComparator underlyingComparator = ListContainer.this.getUnderlyingComparator(this.propertyId[i]);
                ComparableComparator comparableComparator = currentComparator = underlyingComparator != null ? underlyingComparator : ComparableComparator.getInstance();
                if (!this.ascending[i]) {
                    currentComparator = new ReverseComparator((Comparator)currentComparator);
                }
                if ((compare = currentComparator.compare(o1Value = (o1Prop = ListContainer.this.getContainerProperty(o1, this.propertyId[i])) != null ? o1Prop.getValue() : null, o2Value = (o2Prop = ListContainer.this.getContainerProperty(o2, this.propertyId[i])) != null ? o2Prop.getValue() : null)) == 0) continue;
                return compare;
            }
            return 0;
        }
    }
}

