/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.viritin.v7.fields;

import com.vaadin.server.Sizeable;
import com.vaadin.ui.Component;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.data.util.converter.Converter;
import com.vaadin.v7.ui.CustomField;
import com.vaadin.v7.ui.OptionGroup;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.vaadin.viritin.fields.CaptionGenerator;
import org.vaadin.viritin.v7.ListContainer;

public class CheckBoxGroup<ET>
extends CustomField<Collection> {
    private CaptionGenerator<ET> captionGenerator;
    OptionGroup optionGroup = new OptionGroup(){
        private boolean clientSideChange;
        {
            this.setMultiSelect(true);
            this.setSizeFull();
            this.setImmediate(true);
        }

        public void changeVariables(Object source, Map<String, Object> variables) {
            this.clientSideChange = true;
            super.changeVariables(source, variables);
            this.clientSideChange = false;
        }

        protected void setValue(Object newValue, boolean repaintIsNotNeeded) throws Property.ReadOnlyException {
            Set oldvalue = (Set)this.getValue();
            super.setValue(newValue, repaintIsNotNeeded);
            if (this.clientSideChange) {
                Collection collection = CheckBoxGroup.this.getEditedCollection();
                Set newvalue = (Set)this.getValue();
                HashSet orphaned = new HashSet(oldvalue);
                orphaned.removeAll(newvalue);
                collection.removeAll(orphaned);
                LinkedHashSet newValues = new LinkedHashSet(newvalue);
                newValues.removeAll(oldvalue);
                collection.addAll(newValues);
                CheckBoxGroup.this.fireValueChange(true);
            }
        }

        public String getItemCaption(Object itemId) {
            if (CheckBoxGroup.this.captionGenerator != null) {
                return CheckBoxGroup.this.captionGenerator.getCaption(itemId);
            }
            return super.getCaption();
        }
    };

    public CheckBoxGroup(String caption) {
        this();
        this.setCaption(caption);
    }

    public CheckBoxGroup<ET> setCaptionGenerator(CaptionGenerator<ET> captionGenerator) {
        this.captionGenerator = captionGenerator;
        return this;
    }

    private Collection<ET> getEditedCollection() {
        AbstractCollection c = (ArrayList)this.getValue();
        if (c == null) {
            if (this.getPropertyDataSource() == null) {
                return new HashSet();
            }
            Class fieldType = this.getPropertyDataSource().getType();
            if (fieldType.isInterface()) {
                c = fieldType == List.class ? new ArrayList() : new HashSet();
            } else {
                try {
                    c = (Collection)fieldType.newInstance();
                }
                catch (IllegalAccessException | InstantiationException ex) {
                    throw new RuntimeException("Could not instantiate the used colleciton type", ex);
                }
            }
        }
        return c;
    }

    protected Component initContent() {
        return this.optionGroup;
    }

    public Class<? extends Collection> getType() {
        return Collection.class;
    }

    protected void setInternalValue(Collection newValue) {
        super.setInternalValue((Object)newValue);
        this.optionGroup.setValue((Object)newValue);
    }

    public CheckBoxGroup<ET> setOptions(List<ET> list) {
        this.optionGroup.setContainerDataSource(new ListContainer<ET>(list));
        return this;
    }

    public CheckBoxGroup<ET> setOptions(ET ... list) {
        return this.setOptions(Arrays.asList(list));
    }

    public CheckBoxGroup() {
        this.setHeight("230px");
        this.setConverter((Converter)new Converter<Collection, Collection>(){

            public Collection convertToModel(Collection value, Class<? extends Collection> targetType, Locale locale) throws Converter.ConversionException {
                return value;
            }

            public Collection convertToPresentation(Collection value, Class<? extends Collection> targetType, Locale locale) throws Converter.ConversionException {
                return value;
            }

            public Class<Collection> getModelType() {
                return CheckBoxGroup.this.getEditedCollection().getClass();
            }

            public Class<Collection> getPresentationType() {
                return Collection.class;
            }
        });
    }

    public void select(ET objectToSelect) {
        if (!this.optionGroup.isSelected(objectToSelect)) {
            this.optionGroup.select(objectToSelect);
            this.getEditedCollection().add(objectToSelect);
        }
    }

    public void unSelect(ET objectToDeselect) {
        if (this.optionGroup.isSelected(objectToDeselect)) {
            this.optionGroup.unselect(objectToDeselect);
            this.getEditedCollection().remove(objectToDeselect);
        }
    }

    protected OptionGroup getUndelayingTable() {
        return this.optionGroup;
    }

    public CheckBoxGroup<ET> withFullWidth() {
        this.setWidth(100.0f, Sizeable.Unit.PERCENTAGE);
        return this;
    }

    public CheckBoxGroup<ET> withHeight(String height) {
        this.setHeight(height);
        return this;
    }

    public CheckBoxGroup<ET> withFullHeight() {
        return this.withHeight("100%");
    }

    public CheckBoxGroup<ET> withWidth(String width) {
        this.setWidth(width);
        return this;
    }

    public CheckBoxGroup<ET> withCaption(String caption) {
        this.setCaption(caption);
        return this;
    }

    public CheckBoxGroup<ET> withId(String id) {
        this.setId(id);
        return this;
    }
}

