/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.viritin.v7.fields;

import com.vaadin.server.AbstractErrorMessage;
import com.vaadin.server.CompositeErrorMessage;
import com.vaadin.server.ErrorMessage;
import com.vaadin.ui.AbstractComponent;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.data.Validator;
import com.vaadin.v7.data.util.converter.Converter;
import com.vaadin.v7.data.util.converter.ConverterUtil;
import com.vaadin.v7.event.FieldEvents;
import com.vaadin.v7.ui.TextField;
import java.util.EventObject;
import java.util.Locale;
import java.util.Map;
import org.vaadin.viritin.util.HtmlElementPropertySetter;
import org.vaadin.viritin.v7.fields.EagerValidateable;
import org.vaadin.viritin.v7.fluency.ui.FluentTextField;

public class MTextField
extends TextField
implements EagerValidateable,
FluentTextField<MTextField> {
    private static final long serialVersionUID = -9001913175922725871L;
    private boolean eagerValidation = false;
    private boolean eagerValidationStatus;
    private String lastKnownTextChangeValue;
    private Validator.InvalidValueException eagerValidationError;
    private AutoComplete autocomplete;
    private AutoCapitalize autocapitalize;
    private AutoCorrect autocorrect;
    private Boolean spellcheck;
    boolean userValueChange;
    private HtmlElementPropertySetter heps;
    private boolean skipValueChangeEvent = false;

    public MTextField() {
        this.configureMaddonStuff();
    }

    private void configureMaddonStuff() {
        this.setNullRepresentation("");
    }

    public MTextField(String caption) {
        super(caption);
        this.configureMaddonStuff();
    }

    public MTextField(Property dataSource) {
        super(dataSource);
        this.configureMaddonStuff();
    }

    public MTextField(String caption, Property dataSource) {
        super(caption, dataSource);
        this.configureMaddonStuff();
    }

    public MTextField(String caption, String value) {
        super(caption, value);
    }

    protected void setValue(String newFieldValue, boolean repaintIsNotNeeded) throws Property.ReadOnlyException, Converter.ConversionException, Validator.InvalidValueException {
        this.lastKnownTextChangeValue = null;
        this.eagerValidationError = null;
        super.setValue((Object)newFieldValue, repaintIsNotNeeded);
    }

    @Override
    public boolean isEagerValidation() {
        return this.eagerValidation;
    }

    @Override
    public void setEagerValidation(boolean eagerValidation) {
        this.eagerValidation = eagerValidation;
    }

    protected void fireEvent(EventObject event) {
        if (this.isEagerValidation() && event instanceof FieldEvents.TextChangeEvent) {
            this.lastKnownTextChangeValue = ((FieldEvents.TextChangeEvent)event).getText();
            this.doEagerValidation();
        }
        super.fireEvent(event);
    }

    public String getLastKnownTextContent() {
        return this.lastKnownTextChangeValue;
    }

    public void setSpellcheck(Boolean spellcheck) {
        this.spellcheck = spellcheck;
    }

    public Boolean getSpellcheck() {
        return this.spellcheck;
    }

    public MTextField withSpellCheckOff() {
        this.setSpellcheck(false);
        return this;
    }

    public MTextField withAutocompleteOff() {
        return this.setAutocomplete(AutoComplete.off);
    }

    public MTextField setAutocomplete(AutoComplete autocomplete) {
        this.autocomplete = autocomplete;
        return this;
    }

    public AutoComplete getAutocomplete() {
        return this.autocomplete;
    }

    public MTextField withAutoCapitalizeOff() {
        return this.setAutoCapitalize(AutoCapitalize.off);
    }

    public MTextField setAutoCapitalize(AutoCapitalize autoCapitalize) {
        this.autocapitalize = autoCapitalize;
        return this;
    }

    public AutoCapitalize getAutoCapitalize() {
        return this.autocapitalize;
    }

    public MTextField withAutoCorrectOff() {
        return this.setAutoCorrect(AutoCorrect.off);
    }

    public MTextField setAutoCorrect(AutoCorrect autoCorrect) {
        this.autocorrect = autoCorrect;
        return this;
    }

    public AutoCorrect getAutoCorrect() {
        return this.autocorrect;
    }

    protected HtmlElementPropertySetter getHtmlElementPropertySetter() {
        if (this.heps == null) {
            this.heps = new HtmlElementPropertySetter((AbstractComponent)this);
        }
        return this.heps;
    }

    public void beforeClientResponse(boolean initial) {
        super.beforeClientResponse(initial);
        if (initial) {
            if (this.spellcheck != null) {
                this.getHtmlElementPropertySetter().setProperty("spellcheck", this.spellcheck);
            }
            if (this.autocomplete != null) {
                this.getHtmlElementPropertySetter().setProperty("autocomplete", this.autocomplete.toString());
            }
            if (this.autocorrect != null) {
                this.getHtmlElementPropertySetter().setProperty("autocorrect", this.autocorrect.toString());
            }
            if (this.autocapitalize != null) {
                this.getHtmlElementPropertySetter().setProperty("autocapitalize", this.autocapitalize.toString());
            }
        }
    }

    public ErrorMessage getErrorMessage() {
        Validator.InvalidValueException validationError = this.getValidationError();
        ErrorMessage superError = this.getComponentError();
        if (superError == null && validationError == null && this.getCurrentBufferedSourceException() == null) {
            return null;
        }
        return new CompositeErrorMessage(new ErrorMessage[]{superError, AbstractErrorMessage.getErrorMessageForException((Throwable)validationError), AbstractErrorMessage.getErrorMessageForException((Throwable)this.getCurrentBufferedSourceException())});
    }

    protected Validator.InvalidValueException getValidationError() {
        Validator.InvalidValueException validationError;
        block4: {
            if (this.isEagerValidation() && this.lastKnownTextChangeValue != null) {
                return this.eagerValidationError;
            }
            validationError = null;
            if (this.isValidationVisible()) {
                try {
                    this.validate();
                }
                catch (Validator.InvalidValueException e) {
                    if (e.isInvisible()) break block4;
                    validationError = e;
                }
            }
        }
        return validationError;
    }

    protected void doEagerValidation() {
        boolean wasvalid = this.eagerValidationStatus;
        this.eagerValidationStatus = true;
        this.eagerValidationError = null;
        try {
            if (this.isRequired() && this.getLastKnownTextContent().isEmpty()) {
                throw new Validator.EmptyValueException(this.getRequiredError());
            }
            this.validate(this.getLastKnownTextContent());
            if (!wasvalid) {
                this.markAsDirty();
            }
            if (this.getPropertyDataSource() != null) {
                this.skipValueChangeEvent = true;
                Object convertedValue = ConverterUtil.convertToModel((Object)this.getLastKnownTextContent(), (Class)this.getPropertyDataSource().getType(), (Converter)this.getConverter(), (Locale)this.getLocale());
                this.getPropertyDataSource().setValue(convertedValue);
                this.skipValueChangeEvent = false;
            }
        }
        catch (Validator.InvalidValueException e) {
            this.eagerValidationError = e;
            this.eagerValidationStatus = false;
            this.markAsDirty();
        }
    }

    public void valueChange(Property.ValueChangeEvent event) {
        if (!this.skipValueChangeEvent) {
            super.valueChange(event);
        } else {
            this.skipValueChangeEvent = false;
        }
    }

    public boolean isValid() {
        if (this.isEagerValidation() && this.lastKnownTextChangeValue != null) {
            return this.eagerValidationStatus;
        }
        return super.isValid();
    }

    public void validate() throws Validator.InvalidValueException {
        if (this.isEagerValidation() && this.lastKnownTextChangeValue != null) {
            if (this.isRequired() && this.getLastKnownTextContent().isEmpty()) {
                throw new Validator.EmptyValueException(this.getRequiredError());
            }
            this.validate(this.getLastKnownTextContent());
        } else {
            super.validate();
        }
    }

    public void changeVariables(Object source, Map<String, Object> variables) {
        this.userValueChange = true;
        super.changeVariables(source, variables);
        this.userValueChange = false;
    }

    public boolean isUserValueChange() {
        return this.userValueChange;
    }

    public static enum AutoCapitalize {
        on,
        off;

    }

    public static enum AutoCorrect {
        on,
        off;

    }

    public static enum AutoComplete {
        on,
        off;

    }
}

