/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.viritin.v7.fields;

import com.vaadin.server.Resource;
import com.vaadin.server.Sizeable;
import com.vaadin.shared.ui.MultiSelectMode;
import com.vaadin.ui.Component;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.data.util.converter.Converter;
import com.vaadin.v7.ui.CustomField;
import com.vaadin.v7.ui.Table;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.vaadin.viritin.MSize;
import org.vaadin.viritin.v7.ListContainer;

public class MultiSelectTable<ET>
extends CustomField<Collection> {
    private static final long serialVersionUID = -3245403481676039947L;
    private String[] visProps;
    private String[] pendingHeaders;
    Table table = new Table(){
        private static final long serialVersionUID = -770469825702542170L;
        private boolean clientSideChange;
        {
            this.setSelectable(true);
            this.setMultiSelect(true);
            this.setSizeFull();
            this.setImmediate(true);
        }

        public void changeVariables(Object source, Map<String, Object> variables) {
            this.clientSideChange = true;
            super.changeVariables(source, variables);
            this.clientSideChange = false;
        }

        protected void setValue(Object newValue, boolean repaintIsNotNeeded) throws Property.ReadOnlyException {
            Set oldvalue = (Set)this.getValue();
            super.setValue(newValue, repaintIsNotNeeded);
            if (this.clientSideChange) {
                Set newvalue = (Set)this.getValue();
                HashSet orphaned = new HashSet(oldvalue);
                orphaned.removeAll(newvalue);
                MultiSelectTable.this.removeRelation(orphaned);
                MultiSelectTable.this.allRemovedRelations.addAll(orphaned);
                MultiSelectTable.this.allAddedRelations.removeAll(orphaned);
                LinkedHashSet newValues = new LinkedHashSet(newvalue);
                newValues.removeAll(oldvalue);
                MultiSelectTable.this.addRelation(newValues);
                MultiSelectTable.this.allAddedRelations.addAll(newValues);
                MultiSelectTable.this.allRemovedRelations.removeAll(newValues);
                MultiSelectTable.this.fireValueChange(true);
            }
        }
    };
    private Class<ET> optionType;
    private Set<ET> allAddedRelations = new HashSet<ET>();
    private Set<ET> allRemovedRelations = new HashSet<ET>();

    public MultiSelectTable(Class<ET> optionType) {
        this();
        this.table.setContainerDataSource(new ListContainer<ET>(optionType));
        this.optionType = optionType;
    }

    public MultiSelectTable(String caption) {
        this();
        this.setCaption(caption);
    }

    protected void addRelation(Set<ET> newValues) {
        this.getEditedCollection().addAll(newValues);
    }

    protected void removeRelation(Set<ET> orphaned) {
        this.getEditedCollection().removeAll(orphaned);
    }

    public Set<ET> getAllAddedRelations() {
        return this.allAddedRelations;
    }

    public Set<ET> getAllRemovedRelations() {
        return this.allRemovedRelations;
    }

    public Set<ET> getAllModifiedRelations() {
        HashSet<ET> all = new HashSet<ET>(this.allAddedRelations);
        all.addAll(this.allRemovedRelations);
        return all;
    }

    public void setPropertyDataSource(Property newDataSource) {
        this.clearModifiedRelations();
        super.setPropertyDataSource(newDataSource);
    }

    public void clearModifiedRelations() {
        this.allAddedRelations.clear();
        this.allRemovedRelations.clear();
    }

    protected Collection<ET> getEditedCollection() {
        AbstractCollection c = (ArrayList)this.getValue();
        if (c == null) {
            if (this.getPropertyDataSource() == null) {
                return new HashSet();
            }
            Class fieldType = this.getPropertyDataSource().getType();
            if (fieldType.isInterface()) {
                c = fieldType == List.class ? new ArrayList() : new HashSet();
            } else {
                try {
                    c = (Collection)fieldType.newInstance();
                }
                catch (IllegalAccessException | InstantiationException ex) {
                    throw new RuntimeException("Could not instantiate the used colleciton type", ex);
                }
            }
        }
        return c;
    }

    public MultiSelectTable<ET> withProperties(String ... visibleProperties) {
        this.visProps = visibleProperties;
        if (this.isContainerInitialized()) {
            this.table.setVisibleColumns((Object[])visibleProperties);
        } else {
            for (String string : visibleProperties) {
                this.table.addContainerProperty((Object)string, String.class, (Object)"");
            }
        }
        return this;
    }

    private boolean isContainerInitialized() {
        return this.table.getContainerDataSource() instanceof ListContainer;
    }

    public MultiSelectTable<ET> withColumnHeaders(String ... columnNamesForVisibleProperties) {
        if (this.isContainerInitialized()) {
            this.table.setColumnHeaders(columnNamesForVisibleProperties);
        } else {
            this.pendingHeaders = columnNamesForVisibleProperties;
            for (String prop : columnNamesForVisibleProperties) {
                this.table.addContainerProperty((Object)prop, String.class, (Object)"");
            }
        }
        return this;
    }

    protected Component initContent() {
        return this.table;
    }

    public Class<? extends Collection> getType() {
        return Collection.class;
    }

    protected void setInternalValue(Collection newValue) {
        super.setInternalValue((Object)newValue);
        this.table.setValue((Object)newValue);
    }

    public MultiSelectTable<ET> setOptions(List<ET> list) {
        if (this.visProps == null) {
            this.table.setContainerDataSource(new ListContainer<ET>(this.optionType, list));
        } else {
            this.table.setContainerDataSource(new ListContainer<ET>(this.optionType, list), Arrays.asList(this.visProps));
        }
        if (this.pendingHeaders != null) {
            this.table.setColumnHeaders(this.pendingHeaders);
        }
        return this;
    }

    public MultiSelectTable<ET> setOptions(ET ... list) {
        if (this.visProps == null) {
            this.table.setContainerDataSource(new ListContainer<ET>(this.optionType, Arrays.asList(list)));
        } else {
            this.table.setContainerDataSource(new ListContainer<ET>(this.optionType, Arrays.asList(list)), Arrays.asList(this.visProps));
        }
        if (this.pendingHeaders != null) {
            this.table.setColumnHeaders(this.pendingHeaders);
        }
        return this;
    }

    public MultiSelectTable() {
        this.setHeight("230px");
        this.setConverter((Converter)new Converter<Collection, Collection>(){
            private static final long serialVersionUID = -20358585168853508L;

            public Collection convertToModel(Collection value, Class<? extends Collection> targetType, Locale locale) throws Converter.ConversionException {
                return value;
            }

            public Collection convertToPresentation(Collection value, Class<? extends Collection> targetType, Locale locale) throws Converter.ConversionException {
                return value;
            }

            public Class<Collection> getModelType() {
                return MultiSelectTable.this.getEditedCollection().getClass();
            }

            public Class<Collection> getPresentationType() {
                return Collection.class;
            }
        });
    }

    public void select(ET objectToSelect) {
        if (!this.table.isSelected(objectToSelect)) {
            this.table.select(objectToSelect);
            this.getEditedCollection().add(objectToSelect);
        }
    }

    public void unSelect(ET objectToDeselect) {
        if (this.table.isSelected(objectToDeselect)) {
            this.table.unselect(objectToDeselect);
            this.getEditedCollection().remove(objectToDeselect);
        }
    }

    @Deprecated
    protected Table getUnderlayingTable() {
        return this.table;
    }

    public Table getTable() {
        return this.table;
    }

    public MultiSelectTable<ET> withColumnHeaderMode(Table.ColumnHeaderMode mode) {
        this.getUnderlayingTable().setColumnHeaderMode(mode);
        return this;
    }

    public MultiSelectTable<ET> withFullWidth() {
        this.setWidth(100.0f, Sizeable.Unit.PERCENTAGE);
        return this;
    }

    public MultiSelectTable<ET> withHeight(String height) {
        this.setHeight(height);
        return this;
    }

    public MultiSelectTable<ET> withFullHeight() {
        return this.withHeight("100%");
    }

    public MultiSelectTable<ET> withWidth(String width) {
        this.setWidth(width);
        return this;
    }

    public MultiSelectTable withSize(MSize mSize) {
        this.setWidth(mSize.getWidth(), mSize.getWidthUnit());
        this.setHeight(mSize.getHeight(), mSize.getHeightUnit());
        return this;
    }

    public MultiSelectTable<ET> withCaption(String caption) {
        this.setCaption(caption);
        return this;
    }

    public MultiSelectTable<ET> withStyleName(String ... styleNames) {
        for (String styleName : styleNames) {
            this.addStyleName(styleName);
        }
        return this;
    }

    public MultiSelectTable<ET> withIcon(Resource icon) {
        this.setIcon(icon);
        return this;
    }

    public MultiSelectTable<ET> withId(String id) {
        this.table.setId(id);
        return this;
    }

    public MultiSelectTable<ET> expand(String ... propertiesToExpand) {
        for (String property : propertiesToExpand) {
            this.table.setColumnExpandRatio((Object)property, 1.0f);
        }
        return this;
    }

    public void withRowHeaderMode(Table.RowHeaderMode rowHeaderMode) {
        this.getUnderlayingTable().setRowHeaderMode(rowHeaderMode);
    }

    public MultiSelectTable<ET> setMultiSelectMode(MultiSelectMode mode) {
        this.getTable().setMultiSelectMode(mode);
        return this;
    }
}

