/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.viritin.v7.fields;

import com.vaadin.server.FontAwesome;
import com.vaadin.server.Resource;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Window;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.ui.AbstractSelect;
import com.vaadin.v7.ui.ComboBox;
import com.vaadin.v7.ui.CustomField;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.vaadin.viritin.button.MButton;
import org.vaadin.viritin.fields.CaptionGenerator;
import org.vaadin.viritin.layouts.MHorizontalLayout;
import org.vaadin.viritin.layouts.MVerticalLayout;
import org.vaadin.viritin.v7.fields.MTable;
import org.vaadin.viritin.v7.fields.TypedSelect;
import org.vaadin.viritin.v7.form.AbstractForm;

public class SubSetSelector<ET>
extends CustomField<Collection>
implements AbstractForm.SavedHandler<ET>,
AbstractForm.ResetHandler<ET> {
    private Class<?> type;
    private TypedSelect<ET> cb;
    private MTable<ET> table;
    private Collection selected;
    private Button newInstanceBtn;
    private final Class<ET> elementType;
    private MHorizontalLayout toprow;
    private MVerticalLayout verticalLayout;
    private AbstractForm<ET> newInstanceForm;
    private List<ET> availableOptions;
    private int limit = Integer.MAX_VALUE;

    public SubSetSelector(Class<ET> elementType) {
        this.elementType = elementType;
        this.cb = new TypedSelect<ET>(elementType).withSelectType(ComboBox.class);
        this.table = new MTable<ET>(elementType).withFullWidth();
        this.setHeight("300px");
        this.toprow = new MHorizontalLayout(new Component[]{this.cb});
        this.verticalLayout = new MVerticalLayout(this.toprow).expand(new Component[]{this.table});
        this.table.setPageLength(5);
        this.table.withGeneratedColumn("Remove", new MTable.SimpleColumnGenerator<ET>(){

            @Override
            public Object generate(ET entity) {
                return SubSetSelector.this.getToolColumnContent(entity);
            }
        });
        this.table.setColumnHeader("Remove", "");
        this.cb.setInputPrompt("Add to selection...");
        this.cb.addValueChangeListener(new Property.ValueChangeListener(){

            public void valueChange(Property.ValueChangeEvent event) {
                if (event.getProperty().getValue() != null) {
                    Object pojo = event.getProperty().getValue();
                    SubSetSelector.this.cb.getBic().removeItem(pojo);
                    SubSetSelector.this.cb.setValue(null);
                    SubSetSelector.this.table.addItem(pojo);
                    SubSetSelector.this.selected.add(pojo);
                    SubSetSelector.this.cb.setEnabled(SubSetSelector.this.selected.size() < SubSetSelector.this.limit);
                    SubSetSelector.this.fireValueChange(true);
                }
            }
        });
    }

    protected Object getToolColumnContent(final ET entity) {
        Button button = new Button((Resource)FontAwesome.MINUS);
        button.setDescription("Removes the selection from the list");
        button.addStyleName("icon-only");
        button.addClickListener(new Button.ClickListener(){

            public void buttonClick(Button.ClickEvent event) {
                SubSetSelector.this.removeSelectedOption(entity);
            }
        });
        button.setStyleName("small");
        return button;
    }

    public void removeSelectedOption(ET entity) {
        this.cb.addOption(entity);
        this.table.removeItem(entity);
        this.selected.remove(entity);
        this.cb.setEnabled(this.selected.size() < this.limit);
        this.fireValueChange(true);
    }

    public String getAddInputPrompt() {
        return ((ComboBox)this.cb.getSelect()).getInputPrompt();
    }

    public void setAddInputPrompt(String inputPrompt) {
        this.cb.setInputPrompt(inputPrompt);
    }

    public void setNewInstanceForm(AbstractForm<ET> newInstanceForm) {
        this.newInstanceForm = newInstanceForm;
        if (newInstanceForm != null) {
            if (this.newInstanceBtn == null) {
                this.newInstanceBtn = (Button)new MButton((Resource)FontAwesome.PLUS).withStyleName(new String[]{"icon-only"});
                this.newInstanceBtn.addClickListener(new Button.ClickListener(){

                    public void buttonClick(Button.ClickEvent clickEvent) {
                        SubSetSelector.this.addEntity(null);
                    }
                });
                this.toprow.add(new Component[]{this.newInstanceBtn});
            }
        } else if (this.newInstanceBtn != null) {
            this.toprow.removeComponent((Component)this.newInstanceBtn);
            this.newInstanceBtn = null;
        }
    }

    public AbstractForm<ET> getNewInstanceForm() {
        return this.newInstanceForm;
    }

    protected String getDeleteButtonCaption() {
        return "-";
    }

    public void setColumnHeaders(String ... headers) {
        this.table.setColumnHeaders(headers);
    }

    public void setColumnHeader(Object propertyId, String header) {
        this.table.setColumnHeader(propertyId, header);
    }

    public MTable getTable() {
        return this.table;
    }

    protected void addEntity(String stringInput) {
        ET newInstance = this.instantiateOption(stringInput);
        if (this.newInstanceForm != null) {
            String caption = "Add new " + this.elementType.getSimpleName();
            this.newInstanceForm.setEntity(newInstance);
            this.newInstanceForm.setSavedHandler(this);
            this.newInstanceForm.setResetHandler(this);
            Window w = this.newInstanceForm.openInModalPopup();
            w.setWidth("70%");
            w.setCaption(caption);
        } else {
            this.onSave(newInstance);
        }
    }

    protected ET instantiateOption(String stringInput) {
        try {
            return this.elementType.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public Class<Collection> getType() {
        return this.type;
    }

    public SubSetSelector<ET> setOptions(List<ET> options) {
        this.availableOptions = options;
        this.cb.setOptions((Collection<ET>)new ArrayList<ET>(options));
        return this;
    }

    public void setPropertyDataSource(Property newDataSource) {
        if (newDataSource != null) {
            this.type = newDataSource.getType();
        }
        super.setPropertyDataSource(newDataSource);
    }

    protected void setInternalValue(Collection newValue) {
        this.selected = newValue;
        if (this.selected == null) {
            Class<Collection> clazz = this.getType();
            this.selected = clazz != null && List.class.isAssignableFrom(clazz) ? new ArrayList() : new HashSet();
            this.setValue(this.selected);
            return;
        }
        ArrayList<ET> arrayList = new ArrayList<ET>(this.availableOptions);
        arrayList.removeAll(this.selected);
        this.cb.setOptions((Collection<ET>)arrayList);
        this.cb.getBic().fireItemSetChange();
        this.cb.setEnabled(this.selected.size() < this.limit);
        this.table.setBeans(new ArrayList(this.selected));
        super.setInternalValue((Object)newValue);
    }

    protected void fireValueChange(boolean repaintIsNotNeeded) {
        super.fireValueChange(repaintIsNotNeeded);
    }

    public void setVisibleProperties(String ... visible) {
        ArrayList<String> a = new ArrayList<String>(Arrays.asList(visible));
        a.add("Remove");
        this.table.withProperties(a);
        this.table.setColumnHeader("Remove", "");
    }

    public String getNewEntityCaption() {
        return this.newInstanceBtn.getCaption();
    }

    public void setNewEntityCaption(String newEntityCaption) {
        this.newInstanceBtn.setCaption(newEntityCaption);
    }

    protected Component initContent() {
        return this.verticalLayout;
    }

    public void setCaptionGenerator(CaptionGenerator<ET> cg) {
        this.cb.setCaptionGenerator(cg);
    }

    @Override
    public void onSave(ET entity) {
        this.table.addItem(entity);
        this.selected.add(entity);
        this.cb.setEnabled(this.table.size() < this.limit);
        if (this.newInstanceForm != null) {
            this.newInstanceForm.closePopup();
        }
        this.fireValueChange(true);
    }

    @Override
    public void onReset(ET entity) {
        this.newInstanceForm.closePopup();
    }

    public void setNewItemsAllowed(boolean allowAddingNewItems) {
        this.cb.getSelect().setNewItemsAllowed(allowAddingNewItems);
        if (allowAddingNewItems) {
            this.cb.getSelect().setNewItemHandler(new AbstractSelect.NewItemHandler(){

                public void addNewItem(String s) {
                    SubSetSelector.this.addEntity(s);
                }
            });
        } else {
            this.cb.getSelect().setNewItemHandler(null);
        }
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit < 0 ? Integer.MAX_VALUE : limit;
        this.cb.setEnabled(this.selected.size() < limit);
    }
}

