/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.viritin.v7.fields;

import com.vaadin.server.ErrorMessage;
import com.vaadin.server.Resource;
import com.vaadin.server.Sizeable;
import com.vaadin.ui.Component;
import com.vaadin.v7.data.Buffered;
import com.vaadin.v7.data.Container;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.data.Validator;
import com.vaadin.v7.data.util.converter.Converter;
import com.vaadin.v7.ui.AbstractSelect;
import com.vaadin.v7.ui.ComboBox;
import com.vaadin.v7.ui.CustomField;
import com.vaadin.v7.ui.Field;
import com.vaadin.v7.ui.ListSelect;
import com.vaadin.v7.ui.NativeSelect;
import com.vaadin.v7.ui.OptionGroup;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.vaadin.viritin.fields.CaptionGenerator;
import org.vaadin.viritin.v7.ListContainer;
import org.vaadin.viritin.v7.fields.IconGenerator;
import org.vaadin.viritin.v7.fields.LazyComboBox;
import org.vaadin.viritin.v7.fields.MValueChangeEvent;
import org.vaadin.viritin.v7.fields.MValueChangeEventImpl;
import org.vaadin.viritin.v7.fields.MValueChangeListener;
import org.vaadin.viritin.v7.fields.config.ComboBoxConfig;
import org.vaadin.viritin.v7.fields.config.ListSelectConfig;
import org.vaadin.viritin.v7.fields.config.OptionGroupConfig;

public class TypedSelect<T>
extends CustomField<T> {
    private static final long serialVersionUID = -8585094121129546069L;
    private CaptionGenerator<T> captionGenerator;
    private IconGenerator<T> iconGenerator;
    private AbstractSelect select;
    private ListContainer<T> bic;
    private Class<T> fieldType;
    private Property.ValueChangeListener piggyBackListener;

    public TypedSelect(Class<T> type) {
        this.fieldType = type;
        this.bic = new ListContainer<T>(type);
    }

    public TypedSelect(T ... options) {
        this.setOptions(options);
    }

    public TypedSelect(String caption) {
        this.setCaption(caption);
    }

    public void setWidth(float width, Sizeable.Unit unit) {
        if (this.select != null) {
            this.select.setWidth(width, unit);
        }
        super.setWidth(width, unit);
    }

    public void addStyleName(String style) {
        this.getSelect().addStyleName(style);
        super.addStyleName(style);
    }

    public void removeStyleName(String style) {
        this.getSelect().removeStyleName(style);
        super.removeStyleName(style);
    }

    public void setStyleName(String style) {
        this.getSelect().setStyleName(style);
        super.setStyleName(style);
    }

    public TypedSelect(String caption, Collection<T> options) {
        this(caption);
        this.setOptions(options);
    }

    public TypedSelect<T> withCaption(String caption) {
        this.setCaption(caption);
        return this;
    }

    public TypedSelect<T> withCaption(String caption, boolean captionAsHtml) {
        this.setCaption(caption);
        this.setCaptionAsHtml(captionAsHtml);
        return this;
    }

    public TypedSelect<T> asListSelectType() {
        return this.asListSelectType(null);
    }

    public TypedSelect<T> asListSelectType(ListSelectConfig config) {
        ListSelect listSelect = new ListSelect(){
            private static final long serialVersionUID = -6410506555879530635L;

            public String getItemCaption(Object itemId) {
                return TypedSelect.this.getCaption(itemId);
            }

            public Resource getItemIcon(Object itemId) {
                if (TypedSelect.this.iconGenerator != null) {
                    return TypedSelect.this.iconGenerator.getIcon(itemId);
                }
                return super.getItemIcon(itemId);
            }
        };
        if (config != null) {
            config.configurateListSelect(listSelect);
        }
        this.setSelectInstance((AbstractSelect)listSelect);
        return this;
    }

    public TypedSelect<T> asOptionGroupType() {
        return this.asOptionGroupType(null);
    }

    public TypedSelect<T> asOptionGroupType(OptionGroupConfig config) {
        OptionGroup optionGroup = new OptionGroup(){
            private static final long serialVersionUID = 6181647051422960470L;

            public String getItemCaption(Object itemId) {
                return TypedSelect.this.getCaption(itemId);
            }

            public Resource getItemIcon(Object itemId) {
                if (TypedSelect.this.iconGenerator != null) {
                    return TypedSelect.this.iconGenerator.getIcon(itemId);
                }
                return super.getItemIcon(itemId);
            }
        };
        if (config != null) {
            config.configurateOptionGroup(optionGroup);
        }
        this.setSelectInstance((AbstractSelect)optionGroup);
        return this;
    }

    public TypedSelect<T> asComboBoxType() {
        return this.asComboBoxType(null);
    }

    public TypedSelect<T> asComboBoxType(ComboBoxConfig config) {
        ComboBox comboBox = new ComboBox(){
            private static final long serialVersionUID = -468737106391765750L;

            public String getItemCaption(Object itemId) {
                return TypedSelect.this.getCaption(itemId);
            }

            public Resource getItemIcon(Object itemId) {
                if (TypedSelect.this.iconGenerator != null) {
                    return TypedSelect.this.iconGenerator.getIcon(itemId);
                }
                return super.getItemIcon(itemId);
            }
        };
        if (config != null) {
            config.configurateComboBox(comboBox);
        }
        this.setSelectInstance((AbstractSelect)comboBox);
        LazyComboBox.fixComboBoxVaadinIssue16647(comboBox);
        return this;
    }

    public TypedSelect<T> asNativeSelectType() {
        this.setSelectInstance((AbstractSelect)new NativeSelect(){
            private static final long serialVersionUID = 7903027904040681357L;

            public String getItemCaption(Object itemId) {
                return TypedSelect.this.getCaption(itemId);
            }

            public Resource getItemIcon(Object itemId) {
                if (TypedSelect.this.iconGenerator != null) {
                    return TypedSelect.this.iconGenerator.getIcon(itemId);
                }
                return super.getItemIcon(itemId);
            }
        });
        return this;
    }

    public TypedSelect<T> withSelectType(Class<? extends AbstractSelect> selectType) {
        if (selectType == ListSelect.class) {
            this.asListSelectType();
        } else if (selectType == OptionGroup.class) {
            this.asOptionGroupType();
        } else if (selectType == ComboBox.class) {
            this.asComboBoxType();
        } else {
            this.asNativeSelectType();
        }
        return this;
    }

    protected void setSelectInstance(AbstractSelect select) {
        if (this.select != null) {
            this.piggyBackListener = null;
        }
        this.select = select;
    }

    protected AbstractSelect getSelect() {
        if (this.select == null) {
            this.withSelectType(null);
            if (this.bic != null) {
                this.select.setContainerDataSource(this.bic);
            }
        }
        this.ensurePiggybackListener();
        return this.select;
    }

    public TypedSelect<T> setInputPrompt(String inputPrompt) {
        if (this.getSelect() instanceof ComboBox) {
            ((ComboBox)this.getSelect()).setInputPrompt(inputPrompt);
        }
        return this;
    }

    protected String getCaption(T option) {
        if (this.captionGenerator != null) {
            return this.captionGenerator.getCaption(option);
        }
        return option == null ? "" : option.toString();
    }

    protected Resource getIcon(T entity) {
        if (this.iconGenerator != null) {
            return this.iconGenerator.getIcon(entity);
        }
        return null;
    }

    public void focus() {
        this.getSelect().focus();
    }

    public final TypedSelect<T> setOptions(T ... values) {
        return this.setOptions((Collection<T>)Arrays.asList(values));
    }

    public Class getType() {
        if (this.fieldType == null) {
            try {
                this.fieldType = ((Container.Ordered)this.select.getContainerDataSource()).firstItemId().getClass();
            }
            catch (Exception e) {
                return Object.class;
            }
        }
        return this.fieldType;
    }

    public TypedSelect<T> setType(Class<T> type) {
        this.fieldType = type;
        return this;
    }

    public TypedSelect<T> setFieldType(Class<T> type) {
        this.fieldType = type;
        return this;
    }

    public void setInvalidCommitted(boolean isCommitted) {
        super.setInvalidCommitted(isCommitted);
        this.getSelect().setInvalidCommitted(isCommitted);
    }

    public void commit() throws Buffered.SourceException, Validator.InvalidValueException {
        this.getSelect().commit();
        super.commit();
    }

    public void discard() throws Buffered.SourceException {
        this.getSelect().discard();
        super.discard();
    }

    public void setBuffered(boolean buffered) {
        this.getSelect().setBuffered(buffered);
        super.setBuffered(buffered);
    }

    public boolean isBuffered() {
        return this.getSelect().isBuffered();
    }

    protected void setInternalValue(T newValue) {
        super.setInternalValue(newValue);
        this.getSelect().setValue(newValue);
    }

    public TypedSelect<T> addMValueChangeListener(MValueChangeListener<T> listener) {
        this.addListener(MValueChangeEvent.class, listener, MValueChangeEventImpl.VALUE_CHANGE_METHOD);
        return this;
    }

    public TypedSelect<T> removeMValueChangeListener(MValueChangeListener<T> listener) {
        this.removeListener(MValueChangeEvent.class, listener, MValueChangeEventImpl.VALUE_CHANGE_METHOD);
        return this;
    }

    public int getTabIndex() {
        return this.getSelect().getTabIndex();
    }

    public void setTabIndex(int tabIndex) {
        this.getSelect().setTabIndex(tabIndex);
    }

    public CaptionGenerator<T> getCaptionGenerator() {
        return this.captionGenerator;
    }

    public TypedSelect<T> setCaptionGenerator(CaptionGenerator<T> captionGenerator) {
        this.captionGenerator = captionGenerator;
        return this;
    }

    public TypedSelect<T> setIconGenerator(IconGenerator<T> generator) {
        this.iconGenerator = generator;
        return this;
    }

    public IconGenerator<T> getIconGenerator() {
        return this.iconGenerator;
    }

    public final TypedSelect<T> setOptions(Collection<T> options) {
        if (this.bic != null) {
            this.bic.setCollection(options);
        } else {
            this.bic = new ListContainer<T>(options);
        }
        this.getSelect().setContainerDataSource(this.bic);
        return this;
    }

    public final List<T> getOptions() {
        if (this.bic == null) {
            return Collections.EMPTY_LIST;
        }
        return (List)this.bic.getItemIds();
    }

    public TypedSelect<T> setNullSelectionAllowed(boolean nullAllowed) {
        this.getSelect().setNullSelectionAllowed(nullAllowed);
        return this;
    }

    public TypedSelect<T> setBeans(Collection<T> options) {
        return this.setOptions(options);
    }

    public Collection<T> getBeans() {
        return this.bic.getItemIds();
    }

    public void attach() {
        this.ensureContainerSet();
        super.attach();
    }

    private void ensureContainerSet() {
        if (this.bic != null && this.getSelect().getContainerDataSource() != this.bic) {
            this.getSelect().setContainerDataSource(this.bic);
        }
    }

    public void setValue(T newFieldValue) throws Property.ReadOnlyException, Converter.ConversionException {
        this.ensureContainerSet();
        super.setValue(newFieldValue);
    }

    private void ensurePiggybackListener() {
        if (this.piggyBackListener == null) {
            this.piggyBackListener = new Property.ValueChangeListener(){
                private static final long serialVersionUID = 8457613845310646169L;

                public void valueChange(Property.ValueChangeEvent event) {
                    TypedSelect.this.setValue(event.getProperty().getValue());
                    TypedSelect.this.fireEvent(new MValueChangeEventImpl((Field)TypedSelect.this));
                }
            };
            this.getSelect().addValueChangeListener(this.piggyBackListener);
        }
    }

    public TypedSelect<T> withFullWidth() {
        this.setWidth("100%");
        return this;
    }

    public TypedSelect<T> withReadOnly(boolean readOnly) {
        this.setReadOnly(readOnly);
        return this;
    }

    public TypedSelect<T> withValidator(Validator validator) {
        this.setImmediate(true);
        this.addValidator(validator);
        return this;
    }

    public TypedSelect<T> withWidth(float width, Sizeable.Unit unit) {
        this.setWidth(width, unit);
        return this;
    }

    public TypedSelect<T> withWidth(String width) {
        this.setWidth(width);
        return this;
    }

    public TypedSelect<T> withWidthUndefined() {
        this.setWidthUndefined();
        return this;
    }

    public TypedSelect<T> withId(String id) {
        this.setId(id);
        return this;
    }

    public TypedSelect<T> withStyleName(String ... styleNames) {
        for (String styleName : styleNames) {
            this.addStyleName(styleName);
        }
        return this;
    }

    public TypedSelect<T> withIcon(Resource icon) {
        this.setIcon(icon);
        return this;
    }

    public void selectFirst() {
        if (this.bic != null && this.bic.size() > 0) {
            this.getSelect().setValue(this.bic.getIdByIndex(0));
        }
    }

    public TypedSelect<T> withNullSelectionAllowed(boolean nullAllowed) {
        this.setNullSelectionAllowed(nullAllowed);
        return this;
    }

    public TypedSelect<T> withVisible(boolean visible) {
        this.setVisible(visible);
        return this;
    }

    public TypedSelect<T> withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public TypedSelect<T> withEnabled(boolean enabled) {
        this.setEnabled(enabled);
        return this;
    }

    protected ListContainer<T> getBic() {
        return this.bic;
    }

    protected void setBic(ListContainer<T> listContainer) {
        this.bic = listContainer;
    }

    public void setReadOnly(boolean readOnly) {
        super.setReadOnly(readOnly);
        this.getSelect().setReadOnly(readOnly);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.getSelect().setEnabled(enabled);
    }

    protected Component initContent() {
        return this.getSelect();
    }

    public void addOption(T option) {
        this.getBic().addItem(option);
    }

    public ErrorMessage getErrorMessage() {
        ErrorMessage errorMessage = super.getErrorMessage();
        this.getSelect().setStyleName("error", errorMessage != null);
        return errorMessage;
    }
}

