/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.viritin.v7.fields.config;

import com.vaadin.v7.ui.OptionGroup;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class OptionGroupConfig {
    Boolean htmlContentAllowed;
    Set<Object> disabledItemIds;

    public static final OptionGroupConfig build() {
        return new OptionGroupConfig();
    }

    public OptionGroupConfig withHtmlContentAllowed(boolean htmlContentAllowed) {
        this.htmlContentAllowed = htmlContentAllowed;
        return this;
    }

    public OptionGroupConfig withDisabledItemIds(List<Object> objectList) {
        if (this.disabledItemIds == null) {
            this.disabledItemIds = new HashSet<Object>();
        }
        this.disabledItemIds.add(objectList);
        return this;
    }

    public OptionGroupConfig withDisabledItemIds(Object ... objects) {
        return this.withDisabledItemIds(Arrays.asList(objects));
    }

    public void configurateOptionGroup(OptionGroup optionGroup) {
        if (this.htmlContentAllowed != null) {
            optionGroup.setHtmlContentAllowed(this.htmlContentAllowed.booleanValue());
        }
        if (this.disabledItemIds != null) {
            for (Object o : this.disabledItemIds) {
                optionGroup.setItemEnabled(o, false);
            }
        }
    }
}

