/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.viritin.v7.grid;

import com.vaadin.v7.data.Item;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.data.util.PropertyValueGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.vaadin.viritin.v7.ListContainer;
import org.vaadin.viritin.v7.grid.StringPropertyValueGenerator;
import org.vaadin.viritin.v7.grid.TypedPropertyValueGenerator;

public class GeneratedPropertyListContainer<T>
extends ListContainer<T> {
    private static final long serialVersionUID = -8384723868776183241L;
    private final Map<String, PropertyValueGenerator<?>> propertyGenerators = new HashMap();
    protected final Class<T> type;

    public GeneratedPropertyListContainer(Class<T> type) {
        super(type);
        this.type = type;
    }

    public GeneratedPropertyListContainer(Class<T> type, String ... properties) {
        super(type);
        this.type = type;
        this.setContainerPropertyIds(properties);
    }

    public void addGeneratedProperty(String propertyId, PropertyValueGenerator<?> generator) {
        this.propertyGenerators.put(propertyId, generator);
        this.fireContainerPropertySetChange();
    }

    public <P> void addGeneratedProperty(String propertyId, Class<P> presentationType, TypedPropertyValueGenerator.ValueGenerator<T, P> generator) {
        TypedPropertyValueGenerator<T, P> lambdaPropertyValueGenerator = new TypedPropertyValueGenerator<T, P>(this.type, presentationType, generator);
        this.propertyGenerators.put(propertyId, lambdaPropertyValueGenerator);
        this.fireContainerPropertySetChange();
    }

    public void addGeneratedProperty(String propertyId, StringPropertyValueGenerator.ValueGenerator<T> generator) {
        StringPropertyValueGenerator<T> lambdaPropertyValueGenerator = new StringPropertyValueGenerator<T>(this.type, generator);
        this.propertyGenerators.put(propertyId, lambdaPropertyValueGenerator);
        this.fireContainerPropertySetChange();
    }

    @Override
    public Class<?> getType(Object propertyId) {
        if (this.propertyGenerators.containsKey(propertyId)) {
            return this.propertyGenerators.get(propertyId).getType();
        }
        return super.getType(propertyId);
    }

    @Override
    public Item getItem(Object itemId) {
        if (itemId == null) {
            return null;
        }
        Item item = super.getItem(itemId);
        return this.createGeneratedPropertyItem(itemId, item);
    }

    @Override
    public Collection<String> getContainerPropertyIds() {
        ArrayList<String> properties = new ArrayList<String>();
        properties.addAll(super.getContainerPropertyIds());
        properties.addAll(this.propertyGenerators.keySet());
        return properties;
    }

    private <T> Property<T> createProperty(Item item, Object propertyId, Object itemId, PropertyValueGenerator<T> generator) {
        return new GeneratedProperty<T>(item, propertyId, itemId, generator);
    }

    private Item createGeneratedPropertyItem(Object itemId, Item item) {
        return new GeneratedPropertyItem(itemId, item);
    }

    protected class GeneratedPropertyItem
    implements Item {
        private static final long serialVersionUID = 8231832690836075843L;
        private final Item wrappedItem;
        private final Object itemId;

        protected GeneratedPropertyItem(Object itemId, Item item) {
            this.itemId = itemId;
            this.wrappedItem = item;
        }

        public Property getItemProperty(Object id) {
            if (GeneratedPropertyListContainer.this.propertyGenerators.containsKey(id)) {
                return GeneratedPropertyListContainer.this.createProperty(this.wrappedItem, id, this.itemId, (PropertyValueGenerator)GeneratedPropertyListContainer.this.propertyGenerators.get(id));
            }
            return this.wrappedItem.getItemProperty(id);
        }

        public Collection<?> getItemPropertyIds() {
            HashSet wrappedProperties = new HashSet(this.wrappedItem.getItemPropertyIds());
            wrappedProperties.addAll(GeneratedPropertyListContainer.this.propertyGenerators.keySet());
            return wrappedProperties;
        }

        public boolean addItemProperty(Object id, Property property) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("GeneratedPropertyItem does not support adding properties");
        }

        public boolean removeItemProperty(Object id) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("GeneratedPropertyItem does not support removing properties");
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || !obj.getClass().equals(GeneratedPropertyItem.class)) {
                return false;
            }
            GeneratedPropertyItem li = (GeneratedPropertyItem)obj;
            return this.getContainer() == li.getContainer() && this.itemId.equals(li.itemId);
        }

        public int hashCode() {
            return this.itemId.hashCode();
        }

        private GeneratedPropertyListContainer getContainer() {
            return GeneratedPropertyListContainer.this;
        }
    }

    protected static class GeneratedProperty<T>
    implements Property<T> {
        private static final long serialVersionUID = -538857801793925329L;
        private final Item item;
        private final Object itemId;
        private final Object propertyId;
        private final PropertyValueGenerator<T> generator;

        GeneratedProperty(Item item, Object propertyId, Object itemId, PropertyValueGenerator<T> generator) {
            this.item = item;
            this.itemId = itemId;
            this.propertyId = propertyId;
            this.generator = generator;
        }

        public T getValue() {
            return (T)this.generator.getValue(this.item, this.itemId, this.propertyId);
        }

        public void setValue(T newValue) throws Property.ReadOnlyException {
            throw new Property.ReadOnlyException("Generated properties are read only");
        }

        public Class<? extends T> getType() {
            return this.generator.getType();
        }

        public boolean isReadOnly() {
            return true;
        }

        public void setReadOnly(boolean newStatus) {
            if (newStatus) {
                return;
            }
            throw new UnsupportedOperationException("Generated properties are read only");
        }
    }
}

