/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.ldap.authentication.ad;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.AuthenticationException;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.ldap.InitialLdapContext;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.ldap.core.DistinguishedName;
import org.springframework.ldap.core.support.DefaultDirObjectFactory;
import org.springframework.ldap.support.LdapUtils;
import org.springframework.security.authentication.AccountExpiredException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.CredentialsExpiredException;
import org.springframework.security.authentication.DisabledException;
import org.springframework.security.authentication.LockedException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.ldap.SpringSecurityLdapTemplate;
import org.springframework.security.ldap.authentication.AbstractLdapAuthenticationProvider;
import org.springframework.security.ldap.authentication.ad.ActiveDirectoryAuthenticationException;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public final class ActiveDirectoryLdapAuthenticationProvider
extends AbstractLdapAuthenticationProvider {
    private static final Pattern SUB_ERROR_CODE = Pattern.compile(".*data\\s([0-9a-f]{3,4}).*");
    private static final int USERNAME_NOT_FOUND = 1317;
    private static final int INVALID_PASSWORD = 1326;
    private static final int NOT_PERMITTED = 1328;
    private static final int PASSWORD_EXPIRED = 1330;
    private static final int ACCOUNT_DISABLED = 1331;
    private static final int ACCOUNT_EXPIRED = 1793;
    private static final int PASSWORD_NEEDS_RESET = 1907;
    private static final int ACCOUNT_LOCKED = 1909;
    private final String domain;
    private final String rootDn;
    private final String url;
    private boolean convertSubErrorCodesToExceptions;
    private String searchFilter = "(&(objectClass=user)(userPrincipalName={0}))";
    private Map<String, Object> contextEnvironmentProperties = new HashMap<String, Object>();
    ContextFactory contextFactory = new ContextFactory();

    public ActiveDirectoryLdapAuthenticationProvider(String domain, String url, String rootDn) {
        Assert.isTrue((boolean)StringUtils.hasText((String)url), (String)"Url cannot be empty");
        this.domain = StringUtils.hasText((String)domain) ? domain.toLowerCase() : null;
        this.url = url;
        this.rootDn = StringUtils.hasText((String)rootDn) ? rootDn.toLowerCase() : null;
    }

    public ActiveDirectoryLdapAuthenticationProvider(String domain, String url) {
        Assert.isTrue((boolean)StringUtils.hasText((String)url), (String)"Url cannot be empty");
        this.domain = StringUtils.hasText((String)domain) ? domain.toLowerCase() : null;
        this.url = url;
        this.rootDn = this.domain == null ? null : this.rootDnFromDomain(this.domain);
    }

    @Override
    protected DirContextOperations doAuthentication(UsernamePasswordAuthenticationToken auth) {
        String username = auth.getName();
        String password = (String)auth.getCredentials();
        DirContext ctx = this.bindAsUser(username, password);
        try {
            DirContextOperations dirContextOperations = this.searchForUser(ctx, username);
            return dirContextOperations;
        }
        catch (NamingException e) {
            this.logger.error((Object)("Failed to locate directory entry for authenticated user: " + username), (Throwable)e);
            throw this.badCredentials(e);
        }
        finally {
            LdapUtils.closeContext((DirContext)ctx);
        }
    }

    @Override
    protected Collection<? extends GrantedAuthority> loadUserAuthorities(DirContextOperations userData, String username, String password) {
        String[] groups = userData.getStringAttributes("memberOf");
        if (groups == null) {
            this.logger.debug((Object)"No values for 'memberOf' attribute.");
            return AuthorityUtils.NO_AUTHORITIES;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("'memberOf' attribute values: " + Arrays.asList(groups)));
        }
        ArrayList<SimpleGrantedAuthority> authorities = new ArrayList<SimpleGrantedAuthority>(groups.length);
        for (String group : groups) {
            authorities.add(new SimpleGrantedAuthority(new DistinguishedName(group).removeLast().getValue()));
        }
        return authorities;
    }

    private DirContext bindAsUser(String username, String password) {
        String bindUrl = this.url;
        Hashtable<String, Object> env = new Hashtable<String, Object>();
        env.put("java.naming.security.authentication", "simple");
        String bindPrincipal = this.createBindPrincipal(username);
        env.put("java.naming.security.principal", bindPrincipal);
        env.put("java.naming.provider.url", bindUrl);
        env.put("java.naming.security.credentials", password);
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.factory.object", DefaultDirObjectFactory.class.getName());
        env.putAll(this.contextEnvironmentProperties);
        try {
            return this.contextFactory.createContext(env);
        }
        catch (NamingException e) {
            if (e instanceof AuthenticationException || e instanceof OperationNotSupportedException) {
                this.handleBindException(bindPrincipal, e);
                throw this.badCredentials(e);
            }
            throw LdapUtils.convertLdapException((NamingException)e);
        }
    }

    private void handleBindException(String bindPrincipal, NamingException exception) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Authentication for " + bindPrincipal + " failed:" + exception));
        }
        this.handleResolveObj(exception);
        int subErrorCode = this.parseSubErrorCode(exception.getMessage());
        if (subErrorCode <= 0) {
            this.logger.debug((Object)"Failed to locate AD-specific sub-error code in message");
            return;
        }
        this.logger.info((Object)("Active Directory authentication failed: " + this.subCodeToLogMessage(subErrorCode)));
        if (this.convertSubErrorCodesToExceptions) {
            this.raiseExceptionForErrorCode(subErrorCode, exception);
        }
    }

    private void handleResolveObj(NamingException exception) {
        Object resolvedObj = exception.getResolvedObj();
        boolean serializable = resolvedObj instanceof Serializable;
        if (resolvedObj != null && !serializable) {
            exception.setResolvedObj(null);
        }
    }

    private int parseSubErrorCode(String message) {
        Matcher m = SUB_ERROR_CODE.matcher(message);
        if (m.matches()) {
            return Integer.parseInt(m.group(1), 16);
        }
        return -1;
    }

    private void raiseExceptionForErrorCode(int code, NamingException exception) {
        String hexString = Integer.toHexString(code);
        ActiveDirectoryAuthenticationException cause = new ActiveDirectoryAuthenticationException(hexString, exception.getMessage(), exception);
        switch (code) {
            case 1330: {
                throw new CredentialsExpiredException(this.messages.getMessage("LdapAuthenticationProvider.credentialsExpired", "User credentials have expired"), (Throwable)((Object)cause));
            }
            case 1331: {
                throw new DisabledException(this.messages.getMessage("LdapAuthenticationProvider.disabled", "User is disabled"), (Throwable)((Object)cause));
            }
            case 1793: {
                throw new AccountExpiredException(this.messages.getMessage("LdapAuthenticationProvider.expired", "User account has expired"), (Throwable)((Object)cause));
            }
            case 1909: {
                throw new LockedException(this.messages.getMessage("LdapAuthenticationProvider.locked", "User account is locked"), (Throwable)((Object)cause));
            }
        }
        throw this.badCredentials((Throwable)((Object)cause));
    }

    private String subCodeToLogMessage(int code) {
        switch (code) {
            case 1317: {
                return "User was not found in directory";
            }
            case 1326: {
                return "Supplied password was invalid";
            }
            case 1328: {
                return "User not permitted to logon at this time";
            }
            case 1330: {
                return "Password has expired";
            }
            case 1331: {
                return "Account is disabled";
            }
            case 1793: {
                return "Account expired";
            }
            case 1907: {
                return "User must reset password";
            }
            case 1909: {
                return "Account locked";
            }
        }
        return "Unknown (error code " + Integer.toHexString(code) + ")";
    }

    private BadCredentialsException badCredentials() {
        return new BadCredentialsException(this.messages.getMessage("LdapAuthenticationProvider.badCredentials", "Bad credentials"));
    }

    private BadCredentialsException badCredentials(Throwable cause) {
        return (BadCredentialsException)this.badCredentials().initCause(cause);
    }

    private DirContextOperations searchForUser(DirContext context, String username) throws NamingException {
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        String bindPrincipal = this.createBindPrincipal(username);
        String searchRoot = this.rootDn != null ? this.rootDn : this.searchRootFromPrincipal(bindPrincipal);
        try {
            return SpringSecurityLdapTemplate.searchForSingleEntryInternal(context, searchControls, searchRoot, this.searchFilter, new Object[]{bindPrincipal, username});
        }
        catch (IncorrectResultSizeDataAccessException incorrectResults) {
            if (incorrectResults.getActualSize() != 0) {
                throw incorrectResults;
            }
            UsernameNotFoundException userNameNotFoundException = new UsernameNotFoundException("User " + username + " not found in directory.", (Throwable)incorrectResults);
            throw this.badCredentials(userNameNotFoundException);
        }
    }

    private String searchRootFromPrincipal(String bindPrincipal) {
        int atChar = bindPrincipal.lastIndexOf(64);
        if (atChar < 0) {
            this.logger.debug((Object)("User principal '" + bindPrincipal + "' does not contain the domain, and no domain has been configured"));
            throw this.badCredentials();
        }
        return this.rootDnFromDomain(bindPrincipal.substring(atChar + 1, bindPrincipal.length()));
    }

    private String rootDnFromDomain(String domain) {
        String[] tokens = StringUtils.tokenizeToStringArray((String)domain, (String)".");
        StringBuilder root = new StringBuilder();
        for (String token : tokens) {
            if (root.length() > 0) {
                root.append(',');
            }
            root.append("dc=").append(token);
        }
        return root.toString();
    }

    String createBindPrincipal(String username) {
        if (this.domain == null || username.toLowerCase().endsWith(this.domain)) {
            return username;
        }
        return username + "@" + this.domain;
    }

    public void setConvertSubErrorCodesToExceptions(boolean convertSubErrorCodesToExceptions) {
        this.convertSubErrorCodesToExceptions = convertSubErrorCodesToExceptions;
    }

    public void setSearchFilter(String searchFilter) {
        Assert.hasText((String)searchFilter, (String)"searchFilter must have text");
        this.searchFilter = searchFilter;
    }

    public void setContextEnvironmentProperties(Map<String, Object> environment) {
        Assert.notEmpty(environment, (String)"environment must not be empty");
        this.contextEnvironmentProperties = new Hashtable<String, Object>(environment);
    }

    static class ContextFactory {
        ContextFactory() {
        }

        DirContext createContext(Hashtable<?, ?> env) throws NamingException {
            return new InitialLdapContext(env, null);
        }
    }
}

