/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.runtime.control.util;

import com.google.common.base.Strings;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.util.List;
import org.openthinclient.api.distributions.InstallableDistribution;
import org.openthinclient.api.distributions.InstallableDistributions;
import org.openthinclient.wizard.model.InstallModel;

public class DistributionsUtil {
    public static InstallableDistribution getInstallableDistribution(String distributionSource, String distribution, String proxyHost, Integer proxyPort) throws Exception {
        InstallableDistribution installableDistribution;
        if (Strings.isNullOrEmpty((String)distributionSource)) {
            installableDistribution = Strings.isNullOrEmpty((String)distribution) ? InstallModel.DEFAULT_DISTRIBUTION : (InstallableDistribution)InstallableDistributions.getDefaultDistributions().getInstallableDistributions().stream().filter(dist -> distribution.equals(dist.getName())).findFirst().orElse(null);
        } else {
            InstallableDistributions installableDistributions = DistributionsUtil.loadInstallableDistributions(distributionSource, proxyHost, proxyPort);
            installableDistribution = Strings.isNullOrEmpty((String)distribution) ? installableDistributions.getPreferred() : (InstallableDistribution)installableDistributions.getInstallableDistributions().stream().filter(dist -> distribution.equals(dist.getName())).findFirst().orElse(null);
        }
        return installableDistribution;
    }

    public static List<InstallableDistribution> getInstallableDistributions(String distributionSource, String proxyHost, Integer proxyPort) throws Exception {
        if (Strings.isNullOrEmpty((String)distributionSource)) {
            return InstallableDistributions.getDefaultDistributions().getInstallableDistributions();
        }
        return DistributionsUtil.loadInstallableDistributions(distributionSource, proxyHost, proxyPort).getInstallableDistributions();
    }

    private static InstallableDistributions loadInstallableDistributions(String distributionSource, String proxyHost, Integer proxyPort) throws Exception {
        InstallableDistributions installableDistributions;
        if (proxyHost != null && proxyPort != null) {
            Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, (int)proxyPort));
            installableDistributions = InstallableDistributions.load((URL)new URL(distributionSource), (Proxy)proxy);
        } else {
            installableDistributions = InstallableDistributions.load((URL)new URL(distributionSource));
        }
        return installableDistributions;
    }
}

