/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.tools.commands.importcmd;

import java.io.File;
import java.io.IOException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.directory.server.tools.commands.importcmd.ImportCommandExecutorStub;
import org.apache.directory.server.tools.execution.ToolCommandExecutorStub;
import org.apache.directory.server.tools.request.BaseToolCommandCL;
import org.apache.directory.server.tools.util.Parameter;

public class ImportCommandCL
extends BaseToolCommandCL {
    private File ldifFile;
    private boolean ignoreErrors = false;

    public ImportCommandCL() {
        super("import");
    }

    @Override
    public Options getOptions() {
        Options opts = new Options();
        Option op = new Option("h", "host", true, "server host: defaults to localhost");
        op.setRequired(false);
        opts.addOption(op);
        op = new Option("p", "port", true, "server port: defaults to 10389 or server.xml specified port");
        op.setRequired(false);
        opts.addOption(op);
        op = new Option("u", "user", true, "the user: default to uid=admin, ou=system");
        op.setRequired(false);
        opts.addOption(op);
        op = new Option("w", "password", true, "the apacheds administrator's password: defaults to secret");
        op.setRequired(false);
        opts.addOption(op);
        op = new Option("a", "auth", true, "the authentication mode: defaults to 'simple'");
        op.setRequired(false);
        opts.addOption(op);
        op = new Option("f", "file", true, "the ldif file to import");
        op.setRequired(true);
        opts.addOption(op);
        op = new Option("e", "ignore", false, "continue to process the file even if errors are encountered ");
        op.setRequired(false);
        opts.addOption(op);
        return opts;
    }

    @Override
    public void processOptions(CommandLine cmd) {
        if (this.isDebugEnabled()) {
            System.out.println("Processing options for launching import ...");
        }
        if (cmd.hasOption('h')) {
            this.host = cmd.getOptionValue('h');
            if (this.isDebugEnabled()) {
                System.out.println("host overriden by -h option: true");
            }
            this.parameters.add(new Parameter("host", this.host));
        }
        if (cmd.hasOption('p')) {
            String val = cmd.getOptionValue('p');
            try {
                this.port = Integer.parseInt(val);
            }
            catch (NumberFormatException e) {
                System.err.println("port value of '" + val + "' is not a number");
                System.exit(1);
            }
            if (this.port > 49151) {
                System.err.println("port value of '" + val + "' is larger than max port number: " + 49151);
                System.exit(1);
            } else if (this.port < 1) {
                System.err.println("port value of '" + val + "' is smaller than the minimum port number: " + 1);
                System.exit(1);
            }
            if (this.isDebugEnabled()) {
                System.out.println("port overriden by -p option: " + this.port);
            }
            this.parameters.add(new Parameter("port", new Integer(this.port)));
        }
        if (cmd.hasOption('u')) {
            this.user = cmd.getOptionValue('u');
            if (this.isDebugEnabled()) {
                System.out.println("user overriden by -u option: " + this.user);
            }
            this.parameters.add(new Parameter("user", this.user));
        }
        if (cmd.hasOption('w')) {
            this.password = cmd.getOptionValue('w');
            if (this.isDebugEnabled()) {
                System.out.println("password overriden by -w option: " + this.password);
            }
            this.parameters.add(new Parameter("password", this.password));
        }
        if (cmd.hasOption('a')) {
            this.auth = cmd.getOptionValue('a');
            if (this.isDebugEnabled()) {
                System.out.println("authentication type overriden by -a option: " + this.auth);
            }
            this.parameters.add(new Parameter("auth", this.auth));
        }
        if (cmd.hasOption('e')) {
            this.ignoreErrors = true;
            if (this.isDebugEnabled()) {
                System.out.println("ignore-errors overriden by -e option: true");
            }
            this.parameters.add(new Parameter("ignore-errors", new Boolean(this.ignoreErrors)));
        }
        if (cmd.hasOption('f')) {
            String ldifFileName = cmd.getOptionValue('f');
            this.ldifFile = new File(ldifFileName);
            if (!this.ldifFile.exists()) {
                System.err.println("ldif file '" + ldifFileName + "' does not exist");
                System.exit(1);
            }
            if (!this.ldifFile.canRead()) {
                System.err.println("ldif file '" + ldifFileName + "' can't be read");
                System.exit(1);
            }
            if (this.isDebugEnabled()) {
                try {
                    System.out.println("ldif file to import: " + this.ldifFile.getCanonicalPath());
                }
                catch (IOException ioe) {
                    System.out.println("ldif file to import: " + ldifFileName);
                }
            }
        } else {
            System.err.println("ldif file name must be provided");
            System.exit(1);
        }
        this.parameters.add(new Parameter("file", this.ldifFile));
        if (cmd.hasOption('i')) {
            this.parameters.add(new Parameter("install-path", cmd.getOptionValue('i')));
        } else if (cmd.hasOption('c')) {
            System.err.println("forced configuration load (-c) requires the -i option");
            System.exit(1);
        }
        if (cmd.hasOption('c')) {
            this.parameters.add(new Parameter("configuration", new Boolean(true)));
        }
        this.parameters.add(new Parameter("debug", new Boolean(this.isDebugEnabled())));
        this.parameters.add(new Parameter("quiet", new Boolean(this.isQuietEnabled())));
        this.parameters.add(new Parameter("verbose", new Boolean(this.isVerboseEnabled())));
    }

    @Override
    public ToolCommandExecutorStub getStub() {
        return new ImportCommandExecutorStub();
    }
}

