/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.wizard.install;

import java.io.File;
import java.security.SecureRandom;
import java.util.Collection;
import java.util.Date;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.naming.NamingException;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.LdapName;
import javax.security.auth.callback.CallbackHandler;
import org.openthinclient.api.context.InstallContext;
import org.openthinclient.api.distributions.ImportItem;
import org.openthinclient.api.distributions.ImportableProfileProvider;
import org.openthinclient.api.distributions.InstallableDistribution;
import org.openthinclient.api.importer.config.ImporterConfiguration;
import org.openthinclient.api.importer.impl.RestModelImporter;
import org.openthinclient.api.rest.model.AbstractProfileObject;
import org.openthinclient.common.config.LDAPServicesConfiguration;
import org.openthinclient.common.directory.ACLUtils;
import org.openthinclient.common.directory.LDAPDirectory;
import org.openthinclient.common.model.OrganizationalUnit;
import org.openthinclient.common.model.Realm;
import org.openthinclient.common.model.User;
import org.openthinclient.common.model.UserGroup;
import org.openthinclient.common.model.schema.provider.SchemaProvider;
import org.openthinclient.common.model.schema.provider.ServerLocalSchemaProvider;
import org.openthinclient.ldap.DirectoryException;
import org.openthinclient.ldap.LDAPConnectionDescriptor;
import org.openthinclient.ldap.Mapping;
import org.openthinclient.ldap.TypeMapping;
import org.openthinclient.ldap.auth.UsernamePasswordHandler;
import org.openthinclient.progress.LoggingProgressReceiver;
import org.openthinclient.progress.ProgressReceiver;
import org.openthinclient.service.apacheds.DirectoryService;
import org.openthinclient.service.apacheds.DirectoryServiceConfiguration;
import org.openthinclient.service.common.home.ManagerHome;
import org.openthinclient.wizard.FirstStartWizardMessages;
import org.openthinclient.wizard.install.AbstractInstallStep;
import org.openthinclient.wizard.model.DirectoryModel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

public class BootstrapLDAPInstallStep
extends AbstractInstallStep {
    private final DirectoryModel directoryModel;
    private final InstallableDistribution distribution;
    private final ImportableProfileProvider profileProvider;

    public BootstrapLDAPInstallStep(DirectoryModel directoryModel, InstallableDistribution distribution, ImportableProfileProvider profileProvider) {
        this.directoryModel = directoryModel;
        this.distribution = distribution;
        this.profileProvider = profileProvider;
    }

    public static void setupDefaultOUs(LDAPDirectory dir, OrganizationalUnit primaryOU) throws DirectoryException {
        Mapping rootMapping = dir.getMapping();
        Collection typeMappers = rootMapping.getTypes().values();
        for (TypeMapping mapping : typeMappers) {
            OrganizationalUnit ou = new OrganizationalUnit();
            String baseDN = mapping.getBaseRDN();
            if (null == baseDN) continue;
            ou.setName(baseDN.substring(baseDN.indexOf("=") + 1));
            dir.save((Object)ou, primaryOU.getDn());
        }
    }

    @Override
    protected void doExecute(InstallContext installContext) throws Exception {
        ManagerHome managerHome = installContext.getManagerHome();
        DirectoryServiceConfiguration directoryServiceConfiguration = (DirectoryServiceConfiguration)managerHome.getConfiguration(DirectoryServiceConfiguration.class);
        directoryServiceConfiguration.setPrimaryOU(this.directoryModel.getPrimaryOU().getName());
        this.log.info("Starting the embedded LDAP server and bootstrapping the configuration");
        DirectoryService directoryService = new DirectoryService();
        directoryService.setConfiguration(directoryServiceConfiguration);
        directoryService.startService();
        this.bootstrapDirectory(directoryServiceConfiguration, directoryService);
        this.log.info("Saving the ldap configuration.");
        managerHome.save(DirectoryServiceConfiguration.class);
        directoryService.flushEmbeddedServerData();
        this.log.info("Loading and configuring base profiles");
        try (AnnotationConfigApplicationContext importAppContext = new AnnotationConfigApplicationContext();){
            importAppContext.getBeanFactory().registerSingleton("managerHome", (Object)installContext.getManagerHome());
            importAppContext.register(new Class[]{BootstrapConfiguration.class});
            importAppContext.refresh();
            RestModelImporter importer = (RestModelImporter)importAppContext.getBean(RestModelImporter.class);
            for (ImportItem importItem : this.distribution.getImportItems()) {
                this.log.info("Loading profile from " + importItem.getPath());
                AbstractProfileObject profileObject = this.profileProvider.access(installContext, importItem, (ProgressReceiver)new LoggingProgressReceiver());
                importer.importProfileObject(profileObject);
            }
        }
        this.log.info("Stopping the embedded LDAP server.");
        directoryService.stopService();
    }

    private void bootstrapDirectory(DirectoryServiceConfiguration directoryServiceConfiguration, DirectoryService directoryService) throws Exception {
        LDAPConnectionDescriptor lcd = this.createLdapConnectionDescriptor(directoryServiceConfiguration);
        LDAPDirectory ldapDirectory = LDAPDirectory.openEnv((LDAPConnectionDescriptor)lcd);
        OrganizationalUnit primaryOU = this.setupRootOU(ldapDirectory, directoryServiceConfiguration);
        Realm realm = this.setupRealm(ldapDirectory, primaryOU);
        BootstrapLDAPInstallStep.setupDefaultOUs(ldapDirectory, primaryOU);
        this.setupAdminUser(ldapDirectory, primaryOU, realm);
        this.setupACLs(lcd, primaryOU, directoryServiceConfiguration);
        this.secureContextSecurityCredentials(directoryServiceConfiguration, directoryService);
    }

    private Realm setupRealm(LDAPDirectory ldapDirectory, OrganizationalUnit primaryOU) throws Exception {
        Realm realm = new Realm();
        realm.setDescription(primaryOU.getDescription());
        UserGroup admins = new UserGroup();
        admins.setName("administrators");
        realm.setAdministrators(admins);
        String date = new Date().toString();
        realm.setValue("invisibleObjects.initialized", date);
        User roPrincipal = new User();
        roPrincipal.setName("roPrincipal");
        roPrincipal.setSn("Read Only User");
        roPrincipal.setNewPassword("secret");
        realm.setReadOnlyPrincipal(roPrincipal);
        ldapDirectory.save((Object)realm, primaryOU.getDn());
        return realm;
    }

    private void setupAdminUser(LDAPDirectory ldapDirectory, OrganizationalUnit primaryOU, Realm realm) throws Exception {
        User admin = this.directoryModel.getAdministratorUser();
        ldapDirectory.save((Object)admin, new LdapName(primaryOU.getDn()).add("ou=users").toString());
        UserGroup administrators = realm.getAdministrators();
        administrators.getMembers().add(admin);
        ldapDirectory.save((Object)administrators);
        ldapDirectory.save((Object)realm);
    }

    private OrganizationalUnit setupRootOU(LDAPDirectory ldapDirectory, DirectoryServiceConfiguration directoryServiceConfiguration) throws DirectoryException {
        OrganizationalUnit primaryOU = this.directoryModel.getPrimaryOU();
        ldapDirectory.save((Object)primaryOU, directoryServiceConfiguration.getEmbeddedCustomRootPartitionName());
        return primaryOU;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupACLs(LDAPConnectionDescriptor lcd, OrganizationalUnit primaryOU, DirectoryServiceConfiguration configuration) throws NamingException {
        lcd = new LDAPConnectionDescriptor(lcd);
        lcd.setBaseDN(primaryOU.getDn());
        try (LdapContext ctx = lcd.createDirectoryFacade().createDirContext();){
            ACLUtils aclUtils = new ACLUtils(ctx);
            aclUtils.makeACSA("");
            aclUtils.enableSearchForAllUsers("");
            aclUtils.enableAdminUsers("");
        }
        configuration.setAccessControlEnabled(true);
    }

    private void secureContextSecurityCredentials(DirectoryServiceConfiguration configuration, DirectoryService service) {
        SecureRandom RNG = new SecureRandom();
        String[] PW_CHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_-".split("");
        String password = Stream.generate(() -> PW_CHARS[RNG.nextInt(PW_CHARS.length)]).limit(32L).collect(Collectors.joining());
        service.changedEmbeddedAdminPassword(configuration.getContextSecurityCredentials(), password);
    }

    private LDAPConnectionDescriptor createLdapConnectionDescriptor(DirectoryServiceConfiguration directoryServiceConfiguration) {
        LDAPConnectionDescriptor lcd = new LDAPConnectionDescriptor();
        lcd.setConnectionMethod(LDAPConnectionDescriptor.ConnectionMethod.PLAIN);
        lcd.setProviderType(LDAPConnectionDescriptor.ProviderType.SUN);
        lcd.setHostname("localhost");
        lcd.setAuthenticationMethod(LDAPConnectionDescriptor.AuthenticationMethod.SIMPLE);
        lcd.setPortNumber((short)directoryServiceConfiguration.getEmbeddedLdapPort());
        lcd.setCallbackHandler((CallbackHandler)new UsernamePasswordHandler(directoryServiceConfiguration.getContextSecurityPrincipal(), (Object)directoryServiceConfiguration.getContextSecurityCredentials()));
        return lcd;
    }

    @Override
    public String getName() {
        return this.mc.getMessage((Enum)FirstStartWizardMessages.UI_FIRSTSTART_INSTALL_BOOTSTRAPLDAPINSTALLSTEP_LABEL, new Object[0]);
    }

    @Override
    public double getProgress() {
        return 1.0;
    }

    @Configuration
    @Import(value={LDAPServicesConfiguration.class, ImporterConfiguration.class})
    public static class BootstrapConfiguration {
        @Autowired
        ManagerHome managerHome;

        @Bean
        public LDAPConnectionDescriptor ldapConnectionDescriptor() {
            LDAPConnectionDescriptor lcd = new LDAPConnectionDescriptor();
            lcd.setProviderType(LDAPConnectionDescriptor.ProviderType.SUN);
            lcd.setAuthenticationMethod(LDAPConnectionDescriptor.AuthenticationMethod.SIMPLE);
            DirectoryServiceConfiguration configuration = (DirectoryServiceConfiguration)this.managerHome.getConfiguration(DirectoryServiceConfiguration.class);
            lcd.setCallbackHandler((CallbackHandler)new UsernamePasswordHandler(configuration.getContextSecurityPrincipal(), configuration.getContextSecurityCredentials().toCharArray()));
            return lcd;
        }

        @Bean
        public SchemaProvider schemaProvider() {
            File homeDirectory = this.managerHome.getLocation();
            return new ServerLocalSchemaProvider(homeDirectory.toPath().resolve("nfs").resolve("root").resolve("schema"));
        }
    }
}

