/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.wizard.ui.steps;

import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.VerticalLayout;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.openthinclient.wizard.FirstStartWizardMessages;
import org.openthinclient.wizard.model.CheckStatus;
import org.openthinclient.wizard.model.SystemSetupModel;
import org.openthinclient.wizard.ui.steps.AbstractCheckExecutingStep;
import org.vaadin.teemu.wizards.Wizard;
import org.vaadin.teemu.wizards.WizardStep;

public class CheckEnvironmentStep
extends AbstractCheckExecutingStep
implements WizardStep {
    private final SystemSetupModel systemSetupModel;
    private final Button runChecksButton;
    private final List<AbstractCheckExecutingStep.CheckStatusLabel> statusLabels;

    public CheckEnvironmentStep(Wizard wizard, SystemSetupModel systemSetupModel) {
        super(wizard);
        this.systemSetupModel = systemSetupModel;
        VerticalLayout contents = new VerticalLayout();
        contents.setMargin(true);
        contents.setSpacing(true);
        contents.addComponent((Component)this.createLabelH1(this.mc.getMessage((Enum)FirstStartWizardMessages.UI_FIRSTSTART_INSTALLSTEPS_CHECKENVIRONMENTSTEP_HEADLINE, new Object[0])));
        contents.addComponent((Component)this.createLabelLarge(this.mc.getMessage((Enum)FirstStartWizardMessages.UI_FIRSTSTART_INSTALLSTEPS_CHECKENVIRONMENTSTEP_TEXT, new Object[0])));
        this.statusLabels = systemSetupModel.getCheckEnvironmentModel().getCheckStates().stream().map(this::createCheckstatusComponent).collect(Collectors.toList());
        this.getStatusLabels().forEach(arg_0 -> ((VerticalLayout)contents).addComponent(arg_0));
        this.runChecksButton = new Button(this.mc.getMessage((Enum)FirstStartWizardMessages.UI_FIRSTSTART_INSTALLSTEPS_CHECKENVIRONMENTSTEP_BUTTON_RUN, new Object[0]), (Button.ClickListener & Serializable)e -> this.runChecks());
        this.runChecksButton.setStyleName("large");
        contents.addComponent((Component)this.runChecksButton);
        this.setContent((Component)contents);
        this.updateStatusLabels();
    }

    @Override
    protected List<AbstractCheckExecutingStep.CheckStatusLabel> getStatusLabels() {
        return this.statusLabels;
    }

    @Override
    protected void onRunChecks() {
        this.systemSetupModel.getCheckEnvironmentModel().runChecks();
        this.runChecksButton.setEnabled(false);
    }

    @Override
    protected void onChecksFinished() {
        this.runChecksButton.setCaption(this.mc.getMessage((Enum)FirstStartWizardMessages.UI_FIRSTSTART_INSTALLSTEPS_CHECKENVIRONMENTSTEP_BUTTON_RERUN, new Object[0]));
        this.runChecksButton.setEnabled(true);
    }

    @Override
    protected boolean isChecksFinished() {
        return this.systemSetupModel.getCheckEnvironmentModel().allChecksRunned();
    }

    private AbstractCheckExecutingStep.CheckStatusLabel createCheckstatusComponent(CheckStatus checkStatus) {
        return new AbstractCheckExecutingStep.CheckStatusLabel(checkStatus);
    }

    public String getCaption() {
        return this.mc.getMessage((Enum)FirstStartWizardMessages.UI_FIRSTSTART_INSTALLSTEPS_CHECKENVIRONMENTSTEP_TITLE, new Object[0]);
    }

    public boolean onAdvance() {
        return this.systemSetupModel.getCheckEnvironmentModel().isAcceptable();
    }

    public boolean onBack() {
        return !this.systemSetupModel.getCheckEnvironmentModel().isRunning();
    }
}

