/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.runtime.web.comptest.ui;

import com.vaadin.annotations.Theme;
import com.vaadin.server.FontAwesome;
import com.vaadin.server.Resource;
import com.vaadin.server.VaadinRequest;
import com.vaadin.spring.annotation.SpringUI;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Panel;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import java.io.Serializable;
import java.util.function.Supplier;
import org.openthinclient.runtime.web.comptest.ui.ComponentTestTile;
import org.openthinclient.runtime.web.comptest.ui.tests.ComponentTest;
import org.openthinclient.runtime.web.comptest.ui.tests.InstallationPlanSummaryDialogTest;
import org.openthinclient.runtime.web.comptest.ui.tests.ProgressDialogTest;

@SpringUI
@Theme(value="openthinclient")
public class ComponentTestUI
extends UI {
    private MainView mainView;
    private Panel contentArea;
    private Label titleLabel;
    private Button backButton;

    protected void init(VaadinRequest request) {
        this.mainView = new MainView(this, new ProgressDialogTest(), new InstallationPlanSummaryDialogTest());
        this.titleLabel = new Label();
        this.titleLabel.addStyleName("h1");
        this.backButton = new Button("Back");
        this.backButton.setIcon((Resource)FontAwesome.CHEVRON_LEFT);
        this.backButton.addStyleName("borderless-colored");
        this.backButton.addStyleName("huge");
        this.backButton.addClickListener((Button.ClickListener & Serializable)e -> this.showMainView());
        VerticalLayout content = new VerticalLayout();
        HorizontalLayout top = new HorizontalLayout();
        top.setSpacing(true);
        top.addComponent((Component)this.titleLabel);
        top.addComponent((Component)this.backButton);
        this.contentArea = new Panel();
        this.contentArea.addStyleName("borderless");
        content.setMargin(true);
        content.addComponent((Component)top);
        content.addComponent((Component)this.contentArea);
        this.setContent((Component)content);
        this.showMainView();
    }

    public void show(String title, Supplier<Component> supplier) {
        if (supplier == null) {
            this.showMainView();
        } else {
            this.titleLabel.setValue(title);
            this.contentArea.setContent(supplier.get());
            this.backButton.setVisible(true);
        }
    }

    public void showMainView() {
        this.titleLabel.setValue("Component Tests");
        this.contentArea.setContent((Component)this.mainView);
        this.backButton.setVisible(false);
    }

    public static class MainView
    extends HorizontalLayout {
        public MainView(ComponentTestUI ui, ComponentTest ... componentTests) {
            this.setSpacing(true);
            this.addStyleName("wrapping");
            for (ComponentTest test : componentTests) {
                this.addComponent((Component)new ComponentTestTile(ui, test.getTitle(), test.getDetails(), test));
            }
        }
    }
}

