/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.pkgmgr.op;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.openthinclient.pkgmgr.db.Package;
import org.openthinclient.pkgmgr.op.InstallPlan;
import org.openthinclient.pkgmgr.op.PackageManagerOperation;
import org.openthinclient.pkgmgr.op.PackageManagerOperationResolver;

public class DefaultPackageManagerOperation
implements PackageManagerOperation {
    private final List<Package> packagesToInstall;
    private final List<Package> packagesToUninstall;
    private final PackageManagerOperationResolver resolver;
    private PackageManagerOperationResolver.ResolveState resolveState;

    public DefaultPackageManagerOperation(PackageManagerOperationResolver resolver) {
        this.resolver = resolver;
        this.packagesToInstall = new ArrayList<Package>();
        this.packagesToUninstall = new ArrayList<Package>();
    }

    @Override
    public void install(Package pkg) {
        this.packagesToInstall.add(pkg);
    }

    @Override
    public void uninstall(Package pkg) {
        this.packagesToUninstall.add(pkg);
    }

    @Override
    public boolean isResolved() {
        return this.resolveState != null && this.resolver.isValid(this.resolveState);
    }

    @Override
    public void resolve() {
        this.resolveState = this.resolver.resolve(this.packagesToInstall, this.packagesToUninstall);
    }

    @Override
    public Collection<Package> getSuggested() {
        return this.resolveState != null ? this.resolveState.getSuggested() : Collections.emptyList();
    }

    @Override
    public Collection<PackageManagerOperation.PackageConflict> getConflicts() {
        return this.resolveState != null ? this.resolveState.getConflicts() : Collections.emptyList();
    }

    @Override
    public Collection<PackageManagerOperation.UnresolvedDependency> getUnresolved() {
        return this.resolveState != null ? this.resolveState.getUnresolved() : Collections.emptyList();
    }

    @Override
    public InstallPlan getInstallPlan() {
        return this.resolveState != null ? this.resolveState.getInstallPlan() : null;
    }

    @Override
    public PackageManagerOperationResolver.ResolveState getResolveState() {
        return this.resolveState;
    }

    @Override
    public boolean hasPackagesToUninstall() {
        return !this.packagesToUninstall.isEmpty();
    }
}

