/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.pkgmgr.op;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.openthinclient.pkgmgr.db.Package;

public abstract class InstallPlanStep {

    public static class PackageUninstallStep
    extends InstallPlanStep {
        private final Package installedPackage;

        public PackageUninstallStep(Package installedPackage) {
            this.installedPackage = installedPackage;
        }

        public Package getInstalledPackage() {
            return this.installedPackage;
        }

        public String toString() {
            return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("installedPackage", (Object)this.installedPackage.forConflictsToString()).toString();
        }
    }

    public static class PackageVersionChangeStep
    extends InstallPlanStep {
        private final Package installedPackage;
        private final Package targetPackage;

        public PackageVersionChangeStep(Package installedPackage, Package targetPackage) {
            this.installedPackage = installedPackage;
            this.targetPackage = targetPackage;
        }

        public Package getInstalledPackage() {
            return this.installedPackage;
        }

        public Package getTargetPackage() {
            return this.targetPackage;
        }

        public String toString() {
            return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("installedPackage", (Object)this.installedPackage.forConflictsToString()).append("targetPackage", (Object)this.targetPackage.forConflictsToString()).toString();
        }

        public boolean equals(Object obj) {
            if (obj instanceof PackageVersionChangeStep) {
                PackageVersionChangeStep other = (PackageVersionChangeStep)obj;
                return this.installedPackage.equals(other.installedPackage) && this.targetPackage.equals(other.targetPackage);
            }
            return false;
        }

        public int hashCode() {
            int hash = 7;
            hash = 31 * hash + this.installedPackage.hashCode();
            hash = 31 * hash + this.targetPackage.hashCode();
            return hash;
        }
    }

    public static class PackageInstallStep
    extends InstallPlanStep {
        private final Package pkg;

        public PackageInstallStep(Package pkg) {
            this.pkg = pkg;
        }

        public Package getPackage() {
            return this.pkg;
        }

        public String toString() {
            return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("pkg", (Object)this.pkg.forConflictsToString()).toString();
        }

        public boolean equals(Object obj) {
            if (obj instanceof PackageInstallStep) {
                return this.pkg.equals(((PackageInstallStep)obj).pkg);
            }
            return false;
        }

        public int hashCode() {
            return this.pkg.hashCode();
        }
    }
}

