/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.pkgmgr;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.openthinclient.manager.util.http.DownloadManager;
import org.openthinclient.manager.util.http.config.NetworkConfiguration;
import org.openthinclient.pkgmgr.PackageManagerConfiguration;
import org.openthinclient.pkgmgr.PackageManagerDirectoryStructure;
import org.openthinclient.pkgmgr.PackageManagerDirectoryStructureImpl;
import org.openthinclient.pkgmgr.PackageManagerException;
import org.openthinclient.pkgmgr.PackageManagerTaskSummary;
import org.openthinclient.pkgmgr.SourcesList;
import org.openthinclient.pkgmgr.connect.PackageListDownloader;
import org.openthinclient.pkgmgr.db.Package;
import org.openthinclient.pkgmgr.db.PackageManagerDatabase;
import org.openthinclient.pkgmgr.db.Source;
import org.openthinclient.pkgmgr.op.PackageListUpdateReport;
import org.openthinclient.progress.ProgressReceiver;
import org.openthinclient.progress.ProgressTask;
import org.openthinclient.util.dpkg.LocalPackageList;
import org.openthinclient.util.dpkg.PackagesListParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateDatabase
implements ProgressTask<PackageListUpdateReport> {
    private static final Logger LOG = LoggerFactory.getLogger(UpdateDatabase.class);
    private final PackageManagerConfiguration configuration;
    private final SourcesList sourcesList;
    private final PackageManagerDatabase db;
    private final PackageManagerDirectoryStructure directoryStructure;
    private final DownloadManager downloadManager;

    public UpdateDatabase(PackageManagerConfiguration configuration, SourcesList sourcesList, PackageManagerDatabase db, DownloadManager downloadManager) {
        this.configuration = configuration;
        this.sourcesList = sourcesList;
        this.db = db;
        this.directoryStructure = new PackageManagerDirectoryStructureImpl(configuration);
        this.downloadManager = downloadManager;
    }

    private static URL createPackageChangeLogURL(Package pkg) {
        try {
            URL serverPath = pkg.getSource().getUrl();
            if (!serverPath.toExternalForm().endsWith("/")) {
                serverPath = new URL(serverPath.toExternalForm() + "/");
            }
            return new URL(serverPath, pkg.getName() + ".changelog");
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Failed to access changelog due to illegal url", e);
        }
    }

    private boolean downloadChangelogFile(NetworkConfiguration.ProxyConfiguration proxyConfiguration, Source source, Package pkg, PackageManagerTaskSummary taskSummary) throws PackageManagerException {
        try {
            Path changelogFile = this.directoryStructure.changelogFileLocation(source, pkg);
            Files.createDirectories(changelogFile.getParent(), new FileAttribute[0]);
            this.downloadManager.downloadTo(UpdateDatabase.createPackageChangeLogURL(pkg), changelogFile.toFile());
            return true;
        }
        catch (Exception e) {
            if (null != taskSummary) {
                taskSummary.addWarning(e.toString());
            }
            LOG.warn("Changelog download failed for package " + pkg.getName());
            return false;
        }
    }

    private void processPackage(Source source, Package updatedPkg, PackageListUpdateReport report) {
        Package existing = this.db.getBySourceAndNameAndVersion(source, updatedPkg.getName(), updatedPkg.getVersion());
        if (existing != null) {
            if (existing.equals(updatedPkg)) {
                LOG.info("Skipping already existing and equal {}", (Object)updatedPkg.toStringWithNameAndVersion());
                report.incSkipped();
            } else {
                LOG.info("Updating the package metadata for: {}", (Object)existing.toStringWithNameAndVersion());
                existing.updateFrom(updatedPkg);
                existing.setChangeLog(this.extractChangelogEntries(source, updatedPkg));
                this.db.getPackageRepository().save(existing);
                report.incUpdated();
            }
        } else {
            updatedPkg.setChangeLog(this.extractChangelogEntries(source, updatedPkg));
            LOG.info("Adding new package {}", (Object)updatedPkg.toStringWithNameAndVersion());
            this.db.getPackageRepository().save(updatedPkg);
            report.incAdded();
        }
    }

    private String extractChangelogEntries(Source source, Package pkg) {
        LOG.info("Extract the Changelog for {}", (Object)pkg.toStringWithNameAndVersion());
        PackageManagerTaskSummary taskSummary = new PackageManagerTaskSummary();
        this.downloadChangelogFile(this.configuration.getProxyConfiguration(), source, pkg, taskSummary);
        LOG.trace("taskSummary for downloadChangelogFile: {}", taskSummary.getWarnings());
        String nameAndVersion = pkg.getName() + " (" + pkg.getDisplayVersion() + ")";
        List<String> lines = this.parseChangelogFile(source, pkg);
        StringBuilder sb = new StringBuilder();
        boolean addLines = false;
        for (String line : lines) {
            if (line.toLowerCase().contains(nameAndVersion.toLowerCase())) {
                addLines = true;
            }
            if (!addLines || !StringUtils.isNotBlank((CharSequence)line)) continue;
            sb.append(line).append("\n");
        }
        return sb.toString();
    }

    private List<String> parseChangelogFile(Source source, Package pkg) {
        try {
            Path changelogFile = this.directoryStructure.changelogFileLocation(source, pkg);
            LOG.trace("changelogFile: {}", (Object)changelogFile);
            return Files.lines(changelogFile).collect(Collectors.toList());
        }
        catch (IOException e) {
            LOG.error("Cannot read changelogFile for package " + pkg.toStringWithNameAndVersion());
            return Collections.emptyList();
        }
    }

    private Stream<Package> parsePackagesList(LocalPackageList localPackageList) {
        LOG.info("Processing packages for {}", (Object)localPackageList.getSource().getUrl());
        try {
            return new PackagesListParser().parse(Files.newInputStream(localPackageList.getPackagesFile().toPath(), new OpenOption[0])).stream().map(p -> {
                p.setSource(localPackageList.getSource());
                return p;
            });
        }
        catch (IOException e) {
            LOG.error("Failed to parse packages list for " + localPackageList.getSource().getUrl(), (Throwable)e);
            return Stream.empty();
        }
    }

    public ProgressTask.ProgressTaskDescription getDescription(Locale locale) {
        return null;
    }

    public PackageListUpdateReport execute(ProgressReceiver progressReceiver) {
        PackageListDownloader packageListDownloader = new PackageListDownloader(this.configuration, this.downloadManager);
        PackageListUpdateReport report = new PackageListUpdateReport();
        for (Source source : this.sourcesList.getSources()) {
            if (!source.isEnabled()) {
                LOG.info("Disabled source {} skipped.", (Object)source);
                continue;
            }
            this.updateProgress(progressReceiver, source);
            LocalPackageList localPackageList = packageListDownloader.download(source, progressReceiver);
            List<Package> parsePackagesList = this.parsePackagesList(localPackageList).collect(Collectors.toList());
            parsePackagesList.forEach(pkg -> this.processPackage(source, (Package)pkg, report));
            List<Package> outdatedPackages = this.collectOutdatedPackages(source, parsePackagesList);
            outdatedPackages.forEach(existingPkg -> {
                if (existingPkg.isInstalled()) {
                    LOG.warn("Keep existing {} installed, but {} doesn't provide it anymore.", (Object)existingPkg.toStringWithNameAndVersion(), (Object)source);
                } else {
                    LOG.info("Deleting existing {}, because {} doesn't provide it anymore.", (Object)existingPkg.toStringWithNameAndVersion(), (Object)source);
                    this.db.getPackageRepository().delete(existingPkg);
                    report.incRemoved();
                }
            });
            source.setLastUpdated(LocalDateTime.now());
            this.db.getSourceRepository().save(source);
        }
        return report;
    }

    protected List<Package> collectOutdatedPackages(Source source, List<Package> newPackageList) {
        List<Package> existingPackages = this.db.getPackageRepository().findBySource(source);
        return this.collectOutdatedPackages(newPackageList, existingPackages);
    }

    protected List<Package> collectOutdatedPackages(List<Package> newPackageList, List<Package> existingPackages) {
        return existingPackages.stream().filter(p1 -> newPackageList.stream().noneMatch(p2 -> this.packageMetadataEquals((Package)p1, (Package)p2))).collect(Collectors.toList());
    }

    protected boolean packageMetadataEquals(Package p1, Package p2) {
        return Objects.equals(p1.getSource(), p2.getSource()) && Objects.equals(p1.getName(), p2.getName()) && Objects.equals(p1.getVersion(), p2.getVersion());
    }

    private void updateProgress(ProgressReceiver progressReceiver, Source currentSource) {
        List<Source> sources = this.sourcesList.getSources();
        int sourceCount = sources.size();
        boolean multipleSources = sourceCount != 1;
        String message = "Updating " + currentSource.getUrl();
        double progress = multipleSources ? (double)sources.indexOf(currentSource) * (1.0 / (double)sourceCount) : -1.0;
        progressReceiver.progress(message, progress);
    }
}

