/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.pkgmgr.db;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import org.openthinclient.pkgmgr.I18N;

@Embeddable
@Access(value=AccessType.FIELD)
public class Version
implements Comparable,
Serializable {
    private static final long serialVersionUID = 3258135760426317876L;
    private static final Pattern SPECIFIER_PATTERN = Pattern.compile("(?:(\\d+)\\:)?([\\w\\+\\.\\:\\-~]+)");
    @Column(name="version_epoch")
    private int epoch = 0;
    @Column(name="version_upstream")
    private String upstreamVersion;
    @Column(name="version_revision")
    private String debianRevision;
    private transient int hashCode = -1;

    private static int compareRevision(String v1, String v2) {
        int i1 = 0;
        int i2 = 0;
        int digitStart1 = -1;
        int digitStart2 = -1;
        while (i1 < v1.length() && i2 < v2.length()) {
            int d2;
            while (i1 < v1.length() && i2 < v2.length() && !Character.isDigit(v1.charAt(i1)) && !Character.isDigit(v2.charAt(i2)) && v1.charAt(i1) == v2.charAt(i2)) {
                ++i1;
                ++i2;
            }
            if (i1 >= v1.length() || i2 >= v2.length() || !Character.isDigit(v1.charAt(i1)) && Character.isDigit(v2.charAt(i2))) break;
            digitStart1 = i1;
            digitStart2 = i2;
            while (i1 < v1.length() && Character.isDigit(v1.charAt(i1))) {
                ++i1;
            }
            while (i2 < v2.length() && Character.isDigit(v2.charAt(i2))) {
                ++i2;
            }
            int d1 = i1 > digitStart1 ? Integer.parseInt(v1.substring(digitStart1, i1)) : 0;
            int n = d2 = i2 > digitStart2 ? Integer.parseInt(v2.substring(digitStart2, i2)) : 0;
            if (d1 < d2) {
                return -1;
            }
            if (d1 > d2) {
                return 1;
            }
            digitStart2 = -1;
            digitStart1 = -1;
        }
        if (i1 < v1.length() && i2 >= v2.length()) {
            return 1;
        }
        if (i1 >= v1.length() && i2 < v2.length()) {
            return -1;
        }
        if (digitStart1 >= 0) {
            if (v1.charAt(i1) < v2.charAt(i2)) {
                return -1;
            }
            if (v1.charAt(i1) > v2.charAt(i2)) {
                return 1;
            }
        }
        return 0;
    }

    public static Version parse(String specifier) {
        String upstreamVersion;
        int epoch = 0;
        String debianRevision = null;
        try {
            String version;
            int index;
            Matcher m = SPECIFIER_PATTERN.matcher(specifier);
            if (!m.matches()) {
                throw new IllegalArgumentException(I18N.getMessage("Version.cantParseVersion") + ": " + specifier);
            }
            if (m.group(1) != null) {
                epoch = Integer.parseInt(m.group(1));
            }
            if ((index = (version = m.group(2)).lastIndexOf(45)) > 0) {
                upstreamVersion = version.substring(0, index);
                debianRevision = version.substring(index + 1);
            } else {
                upstreamVersion = version;
            }
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
            throw new IllegalArgumentException(I18N.getMessage("Version.cantParseVersion") + ": ", e);
        }
        Version version = new Version();
        version.setEpoch(epoch);
        version.setUpstreamVersion(upstreamVersion);
        version.setDebianRevision(debianRevision);
        return version;
    }

    public int getEpoch() {
        return this.epoch;
    }

    public void setEpoch(int epoch) {
        this.epoch = epoch;
    }

    public String getUpstreamVersion() {
        return this.upstreamVersion;
    }

    public void setUpstreamVersion(String upstreamVersion) {
        this.upstreamVersion = upstreamVersion;
    }

    public String getDebianRevision() {
        return this.debianRevision;
    }

    public void setDebianRevision(String debianRevision) {
        this.debianRevision = debianRevision;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.epoch >= 0) {
            sb.append(this.epoch).append(":");
        }
        sb.append(this.upstreamVersion);
        if (null != this.debianRevision) {
            sb.append("-").append(this.debianRevision);
        }
        return sb.toString();
    }

    public String toStringWithoutEpoch() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.upstreamVersion);
        if (null != this.debianRevision) {
            sb.append("-").append(this.debianRevision);
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        return o instanceof Version && this.compareTo(o) == 0;
    }

    public int hashCode() {
        if (-1 == this.hashCode) {
            this.hashCode = 0x9BD74 ^ this.epoch ^ (this.upstreamVersion != null ? this.upstreamVersion.hashCode() : 0) ^ (this.debianRevision != null ? this.debianRevision.hashCode() : 0);
        }
        return this.hashCode;
    }

    public int compareTo(Object o) {
        int r;
        if (!(o instanceof Version)) {
            throw new IllegalArgumentException("Version can't be compared to a " + o.getClass());
        }
        Version v = (Version)o;
        if (this.epoch < v.epoch) {
            return -1;
        }
        if (this.epoch > v.epoch) {
            return 1;
        }
        if (this.upstreamVersion != null && v.upstreamVersion == null) {
            return 1;
        }
        if (this.upstreamVersion == null && v.upstreamVersion != null) {
            return -1;
        }
        if (this.upstreamVersion != null && v.upstreamVersion != null && (r = Version.compareRevision(this.upstreamVersion, v.upstreamVersion)) != 0) {
            return r;
        }
        if (this.debianRevision != null && v.debianRevision == null) {
            return 1;
        }
        if (this.debianRevision == null && v.debianRevision != null) {
            return -1;
        }
        if (this.debianRevision != null && v.debianRevision != null) {
            return Version.compareRevision(this.debianRevision, v.debianRevision);
        }
        return 0;
    }
}

