/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.pkgmgr.progress;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import org.openthinclient.progress.ListenableProgressFuture;
import org.openthinclient.progress.ProgressManager;
import org.openthinclient.progress.ProgressTask;
import org.openthinclient.progress.Registration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.util.concurrent.ListenableFuture;

public class PackageManagerExecutionEngine {
    private static final Logger LOG = LoggerFactory.getLogger(PackageManagerExecutionEngine.class);
    private final ThreadPoolTaskExecutor executor;
    private final AtomicReference<ProgressManager<?>> currentTask;
    private final CopyOnWriteArrayList<ProgressManager<?>> queuedTasks;
    private final CopyOnWriteArrayList<TaskActivatedHandler> taskActivatedHandlers;
    private final CopyOnWriteArrayList<TaskFinalizedHandler> taskFinalizedHandlers;

    public PackageManagerExecutionEngine(ThreadPoolTaskExecutor executor) {
        this.executor = executor;
        this.currentTask = new AtomicReference();
        this.queuedTasks = new CopyOnWriteArrayList();
        this.taskActivatedHandlers = new CopyOnWriteArrayList();
        this.taskFinalizedHandlers = new CopyOnWriteArrayList();
    }

    public ListenableProgressFuture<?> getCurrentTask() {
        ProgressManager<?> cur = this.currentTask.get();
        if (cur != null) {
            return cur.getFuture();
        }
        return null;
    }

    public List<ProgressManager<?>> getQueuedTasks() {
        return this.queuedTasks;
    }

    public <V> ListenableProgressFuture<V> enqueue(ProgressTask<V> task) {
        ProgressManager progressManager = new ProgressManager(task);
        progressManager.onTaskActivation(this::taskActivated);
        progressManager.onTaskFinalization(this::taskFinalized);
        this.queuedTasks.add(progressManager);
        ListenableFuture future = this.executor.submitListenable(progressManager.asCallable());
        return progressManager.wrap(future);
    }

    private <V> void taskFinalized(ProgressManager<V> progressManager) {
        this.queuedTasks.remove(progressManager);
        this.currentTask.set(null);
        this.taskFinalizedHandlers.forEach(handler -> {
            try {
                handler.taskFinalized(progressManager.getFuture());
            }
            catch (Exception e) {
                LOG.error("task finalized handler failed", (Throwable)e);
            }
        });
    }

    private <V> void taskActivated(ProgressManager<V> progressManager) {
        this.currentTask.set(progressManager);
        this.taskActivatedHandlers.forEach(handler -> {
            try {
                handler.taskActivated(progressManager.getFuture());
            }
            catch (Exception e) {
                LOG.error("task activation handler failed", (Throwable)e);
            }
        });
    }

    public Registration addTaskActivatedHandler(TaskActivatedHandler handler) {
        this.taskActivatedHandlers.add(handler);
        return () -> this.taskActivatedHandlers.remove(handler);
    }

    public Registration addTaskFinalizedHandler(TaskFinalizedHandler handler) {
        this.taskFinalizedHandlers.add(handler);
        return () -> this.taskFinalizedHandlers.remove(handler);
    }

    public static interface TaskFinalizedHandler {
        public void taskFinalized(ListenableProgressFuture<?> var1);
    }

    public static interface TaskActivatedHandler {
        public void taskActivated(ListenableProgressFuture<?> var1);
    }
}

