/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.pkgmgr;

import java.nio.file.Path;
import org.openthinclient.pkgmgr.PackageManagerConfiguration;
import org.openthinclient.pkgmgr.PackageManagerDirectoryStructure;
import org.openthinclient.pkgmgr.db.Package;
import org.openthinclient.pkgmgr.db.Source;

public class PackageManagerDirectoryStructureImpl
implements PackageManagerDirectoryStructure {
    private final PackageManagerConfiguration configuration;

    public PackageManagerDirectoryStructureImpl(PackageManagerConfiguration configuration) {
        this.configuration = configuration;
    }

    private String asChangelogDirectoryName(Source source) {
        String changelogdir = source.getUrl().getHost() + "_" + source.getUrl().getFile().replace("Packages.gz", "");
        if (changelogdir.endsWith("/")) {
            changelogdir = changelogdir.substring(0, changelogdir.lastIndexOf("/"));
        }
        changelogdir = changelogdir.replace('/', '_');
        changelogdir = changelogdir.replaceAll("\\.", "_");
        changelogdir = changelogdir.replaceAll("-", "_");
        changelogdir = changelogdir.replaceAll(":", "_COLON_");
        return changelogdir;
    }

    @Override
    public Path changelogFileLocation(Source source, Package pkg) {
        Path changelogRoot = this.configuration.getListsDir().toPath();
        return changelogRoot.resolve(this.asChangelogDirectoryName(source)).resolve(pkg.getName() + ".changelog");
    }
}

