/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.pkgmgr;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.openthinclient.pkgmgr.SourcesList;
import org.openthinclient.pkgmgr.SourcesListException;
import org.openthinclient.pkgmgr.db.Source;

public class SourcesListParser {
    public static final String DEB_SRC = "deb-src";
    public static final String DEB = "deb";

    public SourcesList parse(Path file) {
        try {
            List<String> lines = Files.readAllLines(file);
            return this.parse(lines);
        }
        catch (IOException e) {
            throw new SourcesListException(e);
        }
    }

    public SourcesList parse(List<String> lines) {
        SourcesList sourcesList = new SourcesList();
        ArrayList commentLines = new ArrayList();
        lines.forEach(line -> {
            String trimmedLine = line.trim();
            List<String> prefixes = Arrays.asList("#deb-src", "#deb", DEB_SRC, DEB);
            if (prefixes.stream().anyMatch(trimmedLine::startsWith)) {
                boolean enabled = true;
                if (trimmedLine.startsWith("#")) {
                    trimmedLine = trimmedLine.substring(1);
                    enabled = false;
                }
                Source source = this.parseSource(trimmedLine);
                source.setEnabled(enabled);
                source.setDescription(commentLines.stream().collect(Collectors.joining("\n")));
                commentLines.clear();
                sourcesList.getSources().add(source);
            } else if (trimmedLine.startsWith("#")) {
                commentLines.add(trimmedLine.substring(1));
            } else if (!trimmedLine.isEmpty()) {
                throw new SourcesListException("Illegal content in sources.list. Line'" + line + "'");
            }
        });
        return sourcesList;
    }

    protected Source parseSource(String trimmedLine) {
        Source source = new Source();
        String[] segments = trimmedLine.split("\\s");
        if (segments.length < 2) {
            throw new SourcesListException("incorrect line '" + trimmedLine + "'");
        }
        if (!DEB.equals(segments[0])) {
            if (DEB_SRC.equals(segments[0])) {
                throw new SourcesListException("deb-src is not supported");
            }
            throw new SourcesListException("Illegal type: " + segments[0]);
        }
        try {
            source.setUrl(new URL(segments[1]));
        }
        catch (MalformedURLException e) {
            throw new SourcesListException("Illegal url: '" + segments[1] + "'");
        }
        return source;
    }
}

