/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.pkgmgr.db;

import java.nio.file.Path;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.hibernate.annotations.GenericGenerator;
import org.openthinclient.pkgmgr.db.Installation;
import org.openthinclient.pkgmgr.db.Package;
import org.openthinclient.pkgmgr.db.PackageInstalledContent;

@Entity
@Table(name="otc_installation_log")
public class InstallationLogEntry {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="native")
    @GenericGenerator(name="native", strategy="native")
    private Long id;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="installation_id")
    private Installation installation;
    @Column(length=10, columnDefinition="char")
    @Enumerated(value=EnumType.STRING)
    private PackageInstalledContent.Type type;
    @Column
    private Path path;
    @Column(name="package_name")
    private String packageName;
    @Column(name="package_version")
    private String packageVersion;
    @Column(name="package_source_url")
    private String packageSourceUrl;

    @Deprecated
    public InstallationLogEntry() {
    }

    InstallationLogEntry(Installation installation, Package pkg, PackageInstalledContent.Type type, Path path) {
        this.installation = installation;
        this.type = type;
        this.path = path;
        this.packageName = pkg.getName();
        this.packageVersion = pkg.getVersion() != null ? pkg.getVersion().toString() : "";
        this.packageSourceUrl = pkg.getSource() != null && pkg.getSource().getUrl() != null ? pkg.getSource().getUrl().toString() : "";
    }

    public static InstallationLogEntry file(Installation installation, Package pkg, Path path) {
        return new InstallationLogEntry(installation, pkg, PackageInstalledContent.Type.FILE, path);
    }

    public static InstallationLogEntry symlink(Installation installation, Package pkg, Path path) {
        return new InstallationLogEntry(installation, pkg, PackageInstalledContent.Type.SYMLINK, path);
    }

    public static InstallationLogEntry dir(Installation installation, Package pkg, Path path) {
        return new InstallationLogEntry(installation, pkg, PackageInstalledContent.Type.DIR, path);
    }

    public Installation getInstallation() {
        return this.installation;
    }

    public Path getPath() {
        return this.path;
    }

    public Long getId() {
        return this.id;
    }

    public PackageInstalledContent.Type getType() {
        return this.type;
    }

    public String toString() {
        return "InstallationLogEntry{type=" + (Object)((Object)this.type) + ", path=" + this.path + ", packageName=" + this.packageName + ", packageVersion=" + this.packageVersion + '}';
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getPackageVersion() {
        return this.packageVersion;
    }

    public String getPackageSourceUrl() {
        return this.packageSourceUrl;
    }
}

