/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.pkgmgr.op;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.openthinclient.pkgmgr.db.Installation;
import org.openthinclient.pkgmgr.db.InstallationLogEntry;
import org.openthinclient.pkgmgr.db.Package;
import org.openthinclient.pkgmgr.db.PackageManagerDatabase;
import org.openthinclient.pkgmgr.op.PackageOperationContext;
import org.openthinclient.util.dpkg.LocalPackageRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPackageOperationContext
implements PackageOperationContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultPackageOperationContext.class);
    private final PackageManagerDatabase packageManagerDatabase;
    private final Installation installation;
    private final Path targetDirectory;
    private final List<InstallationLogEntry> log;
    private final Package pkg;
    private final LocalPackageRepository localPackageRepository;

    public DefaultPackageOperationContext(LocalPackageRepository localPackageRepository, PackageManagerDatabase packageManagerDatabase, Installation installation, Path targetDirectory, Package pkg) {
        this.packageManagerDatabase = packageManagerDatabase;
        this.installation = installation;
        this.localPackageRepository = localPackageRepository;
        this.targetDirectory = targetDirectory;
        this.pkg = pkg;
        this.log = new ArrayList<InstallationLogEntry>();
    }

    @Override
    public LocalPackageRepository getLocalPackageRepository() {
        return this.localPackageRepository;
    }

    @Override
    public OutputStream createFile(Path path) throws IOException {
        LOGGER.info("Creating file {}", (Object)path);
        this.log.add(InstallationLogEntry.file(this.installation, this.pkg, path));
        return Files.newOutputStream(this.combine(this.targetDirectory, path), new OpenOption[0]);
    }

    @Override
    public void createDirectory(Path path) throws IOException {
        LOGGER.info("Creating directory {}", (Object)path);
        this.log.add(InstallationLogEntry.dir(this.installation, this.pkg, path));
        Files.createDirectories(this.combine(this.targetDirectory, path), new FileAttribute[0]);
    }

    @Override
    public void createSymlink(Path link, Path target) throws IOException {
        LOGGER.info("Symlinking {} -> {}", (Object)link, (Object)target);
        this.log.add(InstallationLogEntry.symlink(this.installation, this.pkg, link));
        Files.createLink(this.combine(this.targetDirectory, link), target);
    }

    @Override
    public InputStream newInputStream(Path path) throws IOException {
        LOGGER.info("reading file {}", (Object)path);
        return Files.newInputStream(this.combine(this.targetDirectory, path), new OpenOption[0]);
    }

    @Override
    public void delete(Path path) throws IOException {
        Path actualPath = this.combine(this.targetDirectory, path);
        Files.delete(actualPath);
    }

    @Override
    public Stream<Path> list(Path path) throws IOException {
        return Files.list(this.combine(this.targetDirectory, path));
    }

    @Override
    public boolean isRegularFile(Path path) {
        return Files.isRegularFile(this.combine(this.targetDirectory, path), new LinkOption[0]);
    }

    protected Path combine(Path root, Path relative) {
        return root.resolve(relative);
    }

    public List<InstallationLogEntry> getLog() {
        return this.log;
    }

    @Override
    public PackageManagerDatabase getDatabase() {
        return this.packageManagerDatabase;
    }
}

