/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.util.dpkg;

import java.util.ArrayList;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openthinclient.pkgmgr.db.Package;
import org.openthinclient.util.dpkg.PackageReference;

public class PackageReferenceList
extends ArrayList<PackageReference> {
    private static final long serialVersionUID = 6466163962933898656L;

    @Override
    public String toString() {
        return this.stream().map(PackageReference::toString).collect(Collectors.joining(", "));
    }

    public boolean isReferenced(Package pkg) {
        return this.stream().flatMap(ref -> {
            if (ref instanceof PackageReference.SingleReference) {
                return Stream.of((PackageReference.SingleReference)ref);
            }
            return ((PackageReference.OrReference)ref).getReferences().stream();
        }).filter(ref -> ref.matches(pkg)).findFirst().isPresent();
    }
}

